/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.stp;

import cn.dev33.satoken.SaTokenManager;
import cn.dev33.satoken.annotation.SaCheckLogin;
import cn.dev33.satoken.annotation.SaCheckPermission;
import cn.dev33.satoken.annotation.SaCheckRole;
import cn.dev33.satoken.annotation.SaMode;
import cn.dev33.satoken.config.SaTokenConfig;
import cn.dev33.satoken.dao.SaTokenDao;
import cn.dev33.satoken.exception.NotLoginException;
import cn.dev33.satoken.exception.NotPermissionException;
import cn.dev33.satoken.exception.NotRoleException;
import cn.dev33.satoken.fun.SaFunction;
import cn.dev33.satoken.session.SaSession;
import cn.dev33.satoken.session.TokenSign;
import cn.dev33.satoken.stp.SaLoginModel;
import cn.dev33.satoken.stp.SaTokenInfo;
import cn.dev33.satoken.util.SaTokenInsideUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class StpLogic {
    public String loginKey = "";

    public StpLogic(String loginKey) {
        this.loginKey = loginKey;
        SaTokenManager.putStpLogic(this);
    }

    public String getLoginKey() {
        return this.loginKey;
    }

    public StpLogic setLoginKey(String loginKey) {
        this.loginKey = loginKey;
        return this;
    }

    public String getTokenName() {
        return this.splicingKeyTokenName();
    }

    public String createTokenValue(Object loginId) {
        return SaTokenManager.getSaTokenAction().createToken(loginId, this.loginKey);
    }

    public void setTokenValue(String tokenValue, int cookieTimeout) {
        SaTokenConfig config = this.getConfig();
        HttpServletRequest request = SaTokenManager.getSaTokenServlet().getRequest();
        String tokenPrefix = config.getTokenPrefix();
        if (SaTokenInsideUtil.isEmpty(tokenPrefix)) {
            request.setAttribute(this.splicingKeyJustCreatedSave(), (Object)tokenValue);
        } else {
            request.setAttribute(this.splicingKeyJustCreatedSave(), (Object)(tokenPrefix + " " + tokenValue));
        }
        if (config.getIsReadCookie().booleanValue()) {
            HttpServletResponse response = SaTokenManager.getSaTokenServlet().getResponse();
            SaTokenManager.getSaTokenCookie().addCookie(response, this.getTokenName(), tokenValue, "/", config.getCookieDomain(), cookieTimeout);
        }
    }

    public String getTokenValue() {
        String tokenPrefix;
        Cookie cookie;
        HttpServletRequest request = SaTokenManager.getSaTokenServlet().getRequest();
        SaTokenConfig config = this.getConfig();
        String keyTokenName = this.getTokenName();
        String tokenValue = null;
        if (request.getAttribute(this.splicingKeyJustCreatedSave()) != null) {
            tokenValue = String.valueOf(request.getAttribute(this.splicingKeyJustCreatedSave()));
        }
        if (tokenValue == null && config.getIsReadBody().booleanValue()) {
            tokenValue = request.getParameter(keyTokenName);
        }
        if (tokenValue == null && config.getIsReadHead().booleanValue()) {
            tokenValue = request.getHeader(keyTokenName);
        }
        if (tokenValue == null && config.getIsReadCookie().booleanValue() && (cookie = SaTokenManager.getSaTokenCookie().getCookie(request, keyTokenName)) != null) {
            tokenValue = cookie.getValue();
        }
        if (!SaTokenInsideUtil.isEmpty(tokenPrefix = this.getConfig().getTokenPrefix()) && !SaTokenInsideUtil.isEmpty(tokenValue)) {
            tokenValue = tokenValue.startsWith(tokenPrefix + " ") ? tokenValue.substring(tokenPrefix.length() + " ".length()) : null;
        }
        return tokenValue;
    }

    public SaTokenInfo getTokenInfo() {
        SaTokenInfo info = new SaTokenInfo();
        info.tokenName = this.getTokenName();
        info.tokenValue = this.getTokenValue();
        info.isLogin = this.isLogin();
        info.loginId = this.getLoginIdDefaultNull();
        info.loginKey = this.getLoginKey();
        info.tokenTimeout = this.getTokenTimeout();
        info.sessionTimeout = this.getSessionTimeout();
        info.tokenSessionTimeout = this.getTokenSessionTimeout();
        info.tokenActivityTimeout = this.getTokenActivityTimeout();
        info.loginDevice = this.getLoginDevice();
        return info;
    }

    public void setLoginId(Object loginId) {
        this.setLoginId(loginId, new SaLoginModel());
    }

    public void setLoginId(Object loginId, String device) {
        this.setLoginId(loginId, new SaLoginModel().setDevice(device));
    }

    public void setLoginId(Object loginId, boolean isLastingCookie) {
        this.setLoginId(loginId, new SaLoginModel().setIsLastingCookie(isLastingCookie));
    }

    public void setLoginId(Object loginId, SaLoginModel loginModel) {
        SaSession session;
        SaTokenConfig config = this.getConfig();
        SaTokenDao dao = SaTokenManager.getSaTokenDao();
        loginModel.build(config);
        String tokenValue = null;
        if (config.getAllowConcurrentLogin().booleanValue()) {
            if (config.getIsShare().booleanValue()) {
                tokenValue = this.getTokenValueByLoginId(loginId, loginModel.getDevice());
            }
        } else {
            session = this.getSessionByLoginId(loginId, false);
            if (session != null) {
                List<TokenSign> tokenSignList = session.getTokenSignList();
                for (TokenSign tokenSign : tokenSignList) {
                    if (!tokenSign.getDevice().equals(loginModel.getDevice())) continue;
                    dao.update(this.splicingKeyTokenValue(tokenSign.getValue()), "-4");
                    this.clearLastActivity(tokenSign.getValue());
                    session.removeTokenSign(tokenSign.getValue());
                }
            }
        }
        if (tokenValue == null) {
            tokenValue = this.createTokenValue(loginId);
        }
        if ((session = this.getSessionByLoginId(loginId, false)) == null) {
            session = this.getSessionByLoginId(loginId);
        } else {
            session.updateMinTimeout(loginModel.getTimeout());
        }
        session.addTokenSign(new TokenSign(tokenValue, loginModel.getDevice()));
        dao.set(this.splicingKeyTokenValue(tokenValue), String.valueOf(loginId), loginModel.getTimeout());
        this.setLastActivityToNow(tokenValue);
        this.setTokenValue(tokenValue, loginModel.getCookieTimeout());
    }

    public void logout() {
        String tokenValue = this.getTokenValue();
        if (tokenValue == null) {
            return;
        }
        if (this.getConfig().getIsReadCookie().booleanValue()) {
            SaTokenManager.getSaTokenCookie().delCookie(SaTokenManager.getSaTokenServlet().getRequest(), SaTokenManager.getSaTokenServlet().getResponse(), this.getTokenName());
        }
        this.logoutByTokenValue(tokenValue);
    }

    public void logoutByTokenValue(String tokenValue) {
        this.clearLastActivity(tokenValue);
        String loginId = this.getLoginIdNotHandle(tokenValue);
        if (loginId == null || NotLoginException.ABNORMAL_LIST.contains(loginId)) {
            return;
        }
        SaTokenManager.getSaTokenDao().delete(this.splicingKeyTokenValue(tokenValue));
        SaSession session = this.getSessionByLoginId(loginId, false);
        if (session == null) {
            return;
        }
        session.removeTokenSign(tokenValue);
        session.logoutByTokenSignCountToZero();
    }

    public void logoutByLoginId(Object loginId) {
        this.logoutByLoginId(loginId, null);
    }

    public void logoutByLoginId(Object loginId, String device) {
        SaSession session = this.getSessionByLoginId(loginId);
        if (session == null) {
            return;
        }
        List<TokenSign> tokenSignList = session.getTokenSignList();
        for (TokenSign tokenSign : tokenSignList) {
            if (device != null && !tokenSign.getDevice().equals(device)) continue;
            String tokenValue = tokenSign.getValue();
            this.clearLastActivity(tokenValue);
            SaTokenManager.getSaTokenDao().update(this.splicingKeyTokenValue(tokenValue), "-5");
            session.removeTokenSign(tokenValue);
        }
        session.logoutByTokenSignCountToZero();
    }

    public boolean isLogin() {
        return this.getLoginIdDefaultNull() != null;
    }

    public void checkLogin() {
        this.getLoginId();
    }

    public Object getLoginId() {
        if (this.isSwitch()) {
            return this.getSwitchLoginId();
        }
        String tokenValue = this.getTokenValue();
        if (tokenValue == null) {
            throw NotLoginException.newInstance(this.loginKey, "-1");
        }
        String loginId = this.getLoginIdNotHandle(tokenValue);
        if (loginId == null) {
            throw NotLoginException.newInstance(this.loginKey, "-2");
        }
        if (loginId.equals("-3")) {
            throw NotLoginException.newInstance(this.loginKey, "-3");
        }
        if (loginId.equals("-4")) {
            throw NotLoginException.newInstance(this.loginKey, "-4");
        }
        if (loginId.equals("-5")) {
            throw NotLoginException.newInstance(this.loginKey, "-5");
        }
        if (this.getConfig().getAutoRenew().booleanValue()) {
            this.checkActivityTimeout(tokenValue);
            this.updateLastActivityToNow(tokenValue);
        }
        return loginId;
    }

    public <T> T getLoginId(T defaultValue) {
        Object loginId = this.getLoginIdDefaultNull();
        if (loginId == null) {
            return defaultValue;
        }
        if (defaultValue instanceof Integer) {
            return (T)Integer.valueOf(loginId.toString());
        }
        if (defaultValue instanceof Long) {
            return (T)Long.valueOf(loginId.toString());
        }
        if (defaultValue instanceof String) {
            return (T)loginId.toString();
        }
        return (T)loginId;
    }

    public Object getLoginIdDefaultNull() {
        if (this.isSwitch()) {
            return this.getSwitchLoginId();
        }
        String tokenValue = this.getTokenValue();
        if (tokenValue == null) {
            return null;
        }
        String loginId = this.getLoginIdNotHandle(tokenValue);
        if (loginId == null || NotLoginException.ABNORMAL_LIST.contains(loginId)) {
            return null;
        }
        if (this.getTokenActivityTimeoutByToken(tokenValue) == SaTokenDao.NOT_VALUE_EXPIRE.longValue()) {
            return null;
        }
        return loginId;
    }

    public String getLoginIdAsString() {
        return String.valueOf(this.getLoginId());
    }

    public int getLoginIdAsInt() {
        return Integer.valueOf(String.valueOf(this.getLoginId()));
    }

    public long getLoginIdAsLong() {
        return Long.valueOf(String.valueOf(this.getLoginId()));
    }

    public Object getLoginIdByToken(String tokenValue) {
        if (tokenValue == null) {
            return null;
        }
        return this.getLoginIdNotHandle(tokenValue);
    }

    public String getLoginIdNotHandle(String tokenValue) {
        return SaTokenManager.getSaTokenDao().get(this.splicingKeyTokenValue(tokenValue));
    }

    public SaSession getSessionBySessionId(String sessionId, boolean isCreate) {
        SaSession session = SaTokenManager.getSaTokenDao().getSession(sessionId);
        if (session == null && isCreate) {
            session = SaTokenManager.getSaTokenAction().createSession(sessionId);
            SaTokenManager.getSaTokenDao().setSession(session, this.getConfig().getTimeout());
        }
        return session;
    }

    public SaSession getSessionBySessionId(String sessionId) {
        return this.getSessionBySessionId(sessionId, false);
    }

    public SaSession getSessionByLoginId(Object loginId, boolean isCreate) {
        return this.getSessionBySessionId(this.splicingKeySession(loginId), isCreate);
    }

    public SaSession getSessionByLoginId(Object loginId) {
        return this.getSessionByLoginId(loginId, true);
    }

    public SaSession getSession(boolean isCreate) {
        return this.getSessionByLoginId(this.getLoginId(), isCreate);
    }

    public SaSession getSession() {
        return this.getSession(true);
    }

    public SaSession getTokenSessionByToken(String tokenValue, boolean isCreate) {
        return this.getSessionBySessionId(this.splicingKeyTokenSession(tokenValue), isCreate);
    }

    public SaSession getTokenSessionByToken(String tokenValue) {
        return this.getSessionBySessionId(this.splicingKeyTokenSession(tokenValue), true);
    }

    public SaSession getTokenSession(boolean isCreate) {
        if (this.getConfig().getTokenSessionCheckLogin().booleanValue()) {
            this.checkLogin();
        } else {
            String tokenValue = this.getTokenValue();
            if (tokenValue == null || Objects.equals(tokenValue, "")) {
                tokenValue = this.createTokenValue(null);
                this.setLastActivityToNow(tokenValue);
                int cookieTimeout = (int)(this.getConfig().getTimeout() == SaTokenDao.NEVER_EXPIRE.longValue() ? Integer.MAX_VALUE : this.getConfig().getTimeout());
                this.setTokenValue(tokenValue, cookieTimeout);
            }
        }
        return this.getSessionBySessionId(this.splicingKeyTokenSession(this.getTokenValue()), isCreate);
    }

    public SaSession getTokenSession() {
        return this.getTokenSession(true);
    }

    protected void setLastActivityToNow(String tokenValue) {
        if (tokenValue == null || this.getConfig().getActivityTimeout() == SaTokenDao.NEVER_EXPIRE.longValue()) {
            return;
        }
        SaTokenManager.getSaTokenDao().set(this.splicingKeyLastActivityTime(tokenValue), String.valueOf(System.currentTimeMillis()), this.getConfig().getTimeout());
    }

    protected void clearLastActivity(String tokenValue) {
        if (tokenValue == null || this.getConfig().getActivityTimeout() == SaTokenDao.NEVER_EXPIRE.longValue()) {
            return;
        }
        SaTokenManager.getSaTokenDao().delete(this.splicingKeyLastActivityTime(tokenValue));
        SaTokenManager.getSaTokenServlet().getRequest().removeAttribute("TOKEN_ACTIVITY_TIMEOUT_CHECKED_KEY_");
    }

    public void checkActivityTimeout(String tokenValue) {
        if (tokenValue == null || this.getConfig().getActivityTimeout() == SaTokenDao.NEVER_EXPIRE.longValue()) {
            return;
        }
        HttpServletRequest request = SaTokenManager.getSaTokenServlet().getRequest();
        if (request.getAttribute("TOKEN_ACTIVITY_TIMEOUT_CHECKED_KEY_") != null) {
            return;
        }
        long timeout = this.getTokenActivityTimeoutByToken(tokenValue);
        if (timeout == SaTokenDao.NEVER_EXPIRE) {
            return;
        }
        if (timeout == SaTokenDao.NOT_VALUE_EXPIRE) {
            throw NotLoginException.newInstance(this.loginKey, "-3");
        }
        request.setAttribute("TOKEN_ACTIVITY_TIMEOUT_CHECKED_KEY_", (Object)true);
    }

    public void checkActivityTimeout() {
        this.checkActivityTimeout(this.getTokenValue());
    }

    public void updateLastActivityToNow(String tokenValue) {
        if (tokenValue == null || this.getConfig().getActivityTimeout() == SaTokenDao.NEVER_EXPIRE.longValue()) {
            return;
        }
        SaTokenManager.getSaTokenDao().update(this.splicingKeyLastActivityTime(tokenValue), String.valueOf(System.currentTimeMillis()));
    }

    public void updateLastActivityToNow() {
        this.updateLastActivityToNow(this.getTokenValue());
    }

    public long getTokenTimeout() {
        return SaTokenManager.getSaTokenDao().getTimeout(this.splicingKeyTokenValue(this.getTokenValue()));
    }

    public long getTokenTimeoutByLoginId(Object loginId) {
        return SaTokenManager.getSaTokenDao().getTimeout(this.splicingKeyTokenValue(this.getTokenValueByLoginId(loginId)));
    }

    public long getSessionTimeout() {
        return this.getSessionTimeoutByLoginId(this.getLoginIdDefaultNull());
    }

    public long getSessionTimeoutByLoginId(Object loginId) {
        return SaTokenManager.getSaTokenDao().getSessionTimeout(this.splicingKeySession(loginId));
    }

    public long getTokenSessionTimeout() {
        return this.getTokenSessionTimeoutByTokenValue(this.getTokenValue());
    }

    public long getTokenSessionTimeoutByTokenValue(String tokenValue) {
        return SaTokenManager.getSaTokenDao().getSessionTimeout(this.splicingKeyTokenSession(tokenValue));
    }

    public long getTokenActivityTimeout() {
        return this.getTokenActivityTimeoutByToken(this.getTokenValue());
    }

    public long getTokenActivityTimeoutByToken(String tokenValue) {
        if (tokenValue == null) {
            return SaTokenDao.NOT_VALUE_EXPIRE;
        }
        if (this.getConfig().getActivityTimeout() == SaTokenDao.NEVER_EXPIRE.longValue()) {
            return SaTokenDao.NEVER_EXPIRE;
        }
        String keyLastActivityTime = this.splicingKeyLastActivityTime(tokenValue);
        String lastActivityTimeString = SaTokenManager.getSaTokenDao().get(keyLastActivityTime);
        if (lastActivityTimeString == null) {
            return SaTokenDao.NOT_VALUE_EXPIRE;
        }
        long lastActivityTime = Long.valueOf(lastActivityTimeString);
        long apartSecond = (System.currentTimeMillis() - lastActivityTime) / 1000L;
        long timeout = this.getConfig().getActivityTimeout() - apartSecond;
        if (timeout < 0L) {
            return SaTokenDao.NOT_VALUE_EXPIRE;
        }
        return timeout;
    }

    public boolean hasRole(Object loginId, String role) {
        List<String> roleList = SaTokenManager.getStpInterface().getRoleList(loginId, this.loginKey);
        return roleList != null && roleList.contains(role);
    }

    public boolean hasRole(String role) {
        return this.hasRole(this.getLoginId(), role);
    }

    public void checkRole(String role) {
        if (!this.hasRole(role)) {
            throw new NotRoleException(role, this.loginKey);
        }
    }

    public void checkRoleAnd(String ... roleArray) {
        Object loginId = this.getLoginId();
        List<String> roleList = SaTokenManager.getStpInterface().getRoleList(loginId, this.loginKey);
        for (String role : roleArray) {
            if (roleList.contains(role)) continue;
            throw new NotRoleException(role, this.loginKey);
        }
    }

    public void checkRoleOr(String ... roleArray) {
        Object loginId = this.getLoginId();
        List<String> roleList = SaTokenManager.getStpInterface().getRoleList(loginId, this.loginKey);
        for (String role : roleArray) {
            if (!roleList.contains(role)) continue;
            return;
        }
        if (roleArray.length > 0) {
            throw new NotRoleException(roleArray[0], this.loginKey);
        }
    }

    public boolean hasPermission(Object loginId, String permission) {
        List<String> permissionList = SaTokenManager.getStpInterface().getPermissionList(loginId, this.loginKey);
        return permissionList != null && permissionList.contains(permission);
    }

    public boolean hasPermission(String permission) {
        return this.hasPermission(this.getLoginId(), permission);
    }

    public void checkPermission(String permission) {
        if (!this.hasPermission(permission)) {
            throw new NotPermissionException(permission, this.loginKey);
        }
    }

    public void checkPermissionAnd(String ... permissionArray) {
        Object loginId = this.getLoginId();
        List<String> permissionList = SaTokenManager.getStpInterface().getPermissionList(loginId, this.loginKey);
        for (String permission : permissionArray) {
            if (permissionList.contains(permission)) continue;
            throw new NotPermissionException(permission, this.loginKey);
        }
    }

    public void checkPermissionOr(String ... permissionArray) {
        Object loginId = this.getLoginId();
        List<String> permissionList = SaTokenManager.getStpInterface().getPermissionList(loginId, this.loginKey);
        for (String permission : permissionArray) {
            if (!permissionList.contains(permission)) continue;
            return;
        }
        if (permissionArray.length > 0) {
            throw new NotPermissionException(permissionArray[0], this.loginKey);
        }
    }

    public String getTokenValueByLoginId(Object loginId) {
        return this.getTokenValueByLoginId(loginId, "default-device");
    }

    public String getTokenValueByLoginId(Object loginId, String device) {
        List<String> tokenValueList = this.getTokenValueListByLoginId(loginId, device);
        return tokenValueList.size() == 0 ? null : tokenValueList.get(tokenValueList.size() - 1);
    }

    public List<String> getTokenValueListByLoginId(Object loginId) {
        return this.getTokenValueListByLoginId(loginId, "default-device");
    }

    public List<String> getTokenValueListByLoginId(Object loginId, String device) {
        SaSession session = this.getSessionByLoginId(loginId, false);
        if (session == null) {
            return Arrays.asList(new String[0]);
        }
        List<TokenSign> tokenSignList = session.getTokenSignList();
        ArrayList<String> tokenValueList = new ArrayList<String>();
        for (TokenSign tokenSign : tokenSignList) {
            if (!tokenSign.getDevice().equals(device)) continue;
            tokenValueList.add(tokenSign.getValue());
        }
        return tokenValueList;
    }

    public String getLoginDevice() {
        String tokenValue = this.getTokenValue();
        if (tokenValue == null) {
            return null;
        }
        if (!this.isLogin()) {
            return null;
        }
        SaSession session = this.getSessionByLoginId(this.getLoginIdDefaultNull(), false);
        if (session == null) {
            return null;
        }
        List<TokenSign> tokenSignList = session.getTokenSignList();
        for (TokenSign tokenSign : tokenSignList) {
            if (!tokenSign.getValue().equals(tokenValue)) continue;
            return tokenSign.getDevice();
        }
        return null;
    }

    public List<String> searchTokenValue(String keyword, int start, int size) {
        return SaTokenManager.getSaTokenDao().searchData(this.splicingKeyTokenValue(""), keyword, start, size);
    }

    public List<String> searchSessionId(String keyword, int start, int size) {
        return SaTokenManager.getSaTokenDao().searchData(this.splicingKeySession(""), keyword, start, size);
    }

    public List<String> searchTokenSessionId(String keyword, int start, int size) {
        return SaTokenManager.getSaTokenDao().searchData(this.splicingKeyTokenSession(""), keyword, start, size);
    }

    public String splicingKeyTokenName() {
        return this.getConfig().getTokenName();
    }

    public String splicingKeyTokenValue(String tokenValue) {
        return this.getConfig().getTokenName() + ":" + this.loginKey + ":token:" + tokenValue;
    }

    public String splicingKeySession(Object loginId) {
        return this.getConfig().getTokenName() + ":" + this.loginKey + ":session:" + loginId;
    }

    public String splicingKeyTokenSession(String tokenValue) {
        return this.getConfig().getTokenName() + ":" + this.loginKey + ":token-session:" + tokenValue;
    }

    public String splicingKeyLastActivityTime(String tokenValue) {
        return this.getConfig().getTokenName() + ":" + this.loginKey + ":last-activity:" + tokenValue;
    }

    public String splicingKeySwitch() {
        return "SWITCH_TO_SAVE_KEY_" + this.loginKey;
    }

    public String splicingKeyJustCreatedSave() {
        return "JUST_CREATED_SAVE_KEY_" + this.loginKey;
    }

    public SaTokenConfig getConfig() {
        return SaTokenManager.getConfig();
    }

    public void checkMethodAnnotation(Method method) {
        String[] permissionArray;
        SaCheckPermission scp;
        String[] roleArray;
        SaCheckRole scr;
        if (method.isAnnotationPresent(SaCheckLogin.class) || method.getDeclaringClass().isAnnotationPresent(SaCheckLogin.class)) {
            this.checkLogin();
        }
        if ((scr = method.getAnnotation(SaCheckRole.class)) != null) {
            roleArray = scr.value();
            if (scr.mode() == SaMode.AND) {
                this.checkRoleAnd(roleArray);
            } else {
                this.checkRoleOr(roleArray);
            }
        }
        if ((scr = method.getDeclaringClass().getAnnotation(SaCheckRole.class)) != null) {
            roleArray = scr.value();
            if (scr.mode() == SaMode.AND) {
                this.checkRoleAnd(roleArray);
            } else {
                this.checkRoleOr(roleArray);
            }
        }
        if ((scp = method.getAnnotation(SaCheckPermission.class)) != null) {
            permissionArray = scp.value();
            if (scp.mode() == SaMode.AND) {
                this.checkPermissionAnd(permissionArray);
            } else {
                this.checkPermissionOr(permissionArray);
            }
        }
        if ((scp = method.getDeclaringClass().getAnnotation(SaCheckPermission.class)) != null) {
            permissionArray = scp.value();
            if (scp.mode() == SaMode.AND) {
                this.checkPermissionAnd(permissionArray);
            } else {
                this.checkPermissionOr(permissionArray);
            }
        }
    }

    public void switchTo(Object loginId) {
        SaTokenManager.getSaTokenServlet().getRequest().setAttribute(this.splicingKeySwitch(), loginId);
    }

    public void endSwitch() {
        SaTokenManager.getSaTokenServlet().getRequest().removeAttribute(this.splicingKeySwitch());
    }

    public boolean isSwitch() {
        return SaTokenManager.getSaTokenServlet().getRequest().getAttribute(this.splicingKeySwitch()) != null;
    }

    public Object getSwitchLoginId() {
        return SaTokenManager.getSaTokenServlet().getRequest().getAttribute(this.splicingKeySwitch());
    }

    public void switchTo(Object loginId, SaFunction function) {
        try {
            this.switchTo(loginId);
            function.run();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.endSwitch();
        }
    }
}

