/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.io;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.ArrayUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;

public class CharsetDetector {
    private static final Charset[] DEFAULT_CHARSETS;

    public static Charset detect(InputStream in, Charset ... charsets) {
        if (ArrayUtil.isEmpty(charsets)) {
            charsets = DEFAULT_CHARSETS;
        }
        for (Charset charset : charsets) {
            if (null == (charset = CharsetDetector.detectCharset(in, charset))) continue;
            return charset;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Charset detectCharset(InputStream in, Charset charset) {
        try (BufferedInputStream input = IoUtil.toBuffered(in);){
            CharsetDecoder decoder = charset.newDecoder();
            byte[] buffer = new byte[512];
            do {
                if (input.read(buffer) <= -1) return null;
            } while (!CharsetDetector.identify(buffer, decoder));
            Charset charset2 = charset;
            return charset2;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    private static boolean identify(byte[] bytes, CharsetDecoder decoder) {
        try {
            decoder.decode(ByteBuffer.wrap(bytes));
        }
        catch (CharacterCodingException e) {
            return false;
        }
        return true;
    }

    static {
        String[] names = new String[]{"US-ASCII", "UTF-8", "GBK", "GB2312", "BIG5", "GB18030", "UTF-16BE", "UTF-16LE", "UTF-16", "UNICODE"};
        ArrayList<Charset> list = new ArrayList<Charset>();
        for (String name : names) {
            try {
                list.add(Charset.forName(name));
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                // empty catch block
            }
        }
        DEFAULT_CHARSETS = list.toArray(new Charset[0]);
    }
}

