/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.http.cookie;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.util.URLUtil;
import cn.hutool.http.HttpConnection;
import cn.hutool.http.cookie.ThreadLocalCookieStore;
import java.io.IOException;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GlobalCookieManager {
    private static CookieManager cookieManager = new CookieManager(new ThreadLocalCookieStore(), CookiePolicy.ACCEPT_ALL);

    public static void setCookieManager(CookieManager customCookieManager) {
        cookieManager = customCookieManager;
    }

    public static CookieManager getCookieManager() {
        return cookieManager;
    }

    public static void add(HttpConnection conn) {
        Map<String, List<String>> cookieHeader;
        if (null == cookieManager) {
            return;
        }
        try {
            cookieHeader = cookieManager.get(URLUtil.toURI((URL)conn.getUrl()), new HashMap<String, List<String>>(0));
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        conn.header(cookieHeader, false);
    }

    public static void store(HttpConnection conn) {
        if (null == cookieManager) {
            return;
        }
        try {
            cookieManager.put(URLUtil.toURI((URL)conn.getUrl()), conn.headers());
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }
}

