/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.http.server;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.lang.Console;
import cn.hutool.http.server.action.Action;
import cn.hutool.http.server.action.RootAction;
import cn.hutool.http.server.handler.ActionHandler;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.Executor;

public class SimpleServer {
    HttpServer server;

    public SimpleServer(int port) {
        this(new InetSocketAddress(port));
    }

    public SimpleServer(String hostname, int port) {
        this(new InetSocketAddress(hostname, port));
    }

    public SimpleServer(InetSocketAddress address) {
        try {
            this.server = HttpServer.create(address, 0);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    public SimpleServer addHandler(String path, HttpHandler handler) {
        this.server.createContext(path, handler);
        return this;
    }

    public SimpleServer setRoot(String root) {
        return this.addAction("/", new RootAction(root));
    }

    public SimpleServer addAction(String path, Action action) {
        return this.addHandler(path, new ActionHandler(action));
    }

    public SimpleServer setExecutor(Executor executor) {
        this.server.setExecutor(executor);
        return this;
    }

    public HttpServer getRawServer() {
        return this.server;
    }

    public InetSocketAddress getAddress() {
        return this.server.getAddress();
    }

    public void start() {
        InetSocketAddress address = this.getAddress();
        Console.log((String)"Hutool Simple Http Server listen on \u3010{}:{}\u3011", (Object[])new Object[]{address.getHostName(), address.getPort()});
        this.server.start();
    }
}

