/*
 * Decompiled with CFR 0.152.
 */
package capsule;

import capsule.org.eclipse.aether.artifact.Artifact;
import capsule.org.eclipse.aether.graph.Dependency;
import capsule.org.eclipse.aether.graph.DependencyNode;
import capsule.org.eclipse.aether.graph.DependencyVisitor;
import capsule.org.eclipse.aether.util.artifact.ArtifactIdUtils;
import capsule.org.eclipse.aether.util.graph.manager.DependencyManagerUtils;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public final class ConsoleDependencyGraphDumper
implements DependencyVisitor {
    private final PrintStream out;
    private final Deque<ChildInfo> childInfos = new ArrayDeque<ChildInfo>();
    private final Set<Artifact> visitedNodes = Collections.newSetFromMap(new HashMap(512));

    public ConsoleDependencyGraphDumper(PrintStream out) {
        this.out = out;
    }

    @Override
    public boolean visitEnter(DependencyNode node) {
        boolean visited = !this.visit(node);
        String nstr = this.formatNode(node);
        if (nstr != null) {
            this.out.println(this.formatIndentation() + nstr + (visited ? " (*)" : ""));
        }
        this.childInfos.add(new ChildInfo(node.getChildren().size()));
        return !visited;
    }

    @Override
    public boolean visitLeave(DependencyNode node) {
        if (!this.childInfos.isEmpty()) {
            this.childInfos.removeLast();
        }
        if (!this.childInfos.isEmpty()) {
            ++this.childInfos.getLast().index;
        }
        return true;
    }

    private boolean visit(DependencyNode node) {
        return this.visitedNodes.add(node.getArtifact());
    }

    private String formatIndentation() {
        StringBuilder buffer = new StringBuilder(128);
        Iterator<ChildInfo> it = this.childInfos.iterator();
        while (it.hasNext()) {
            buffer.append(it.next().formatIndentation(!it.hasNext()));
        }
        return buffer.toString();
    }

    private String formatNode(DependencyNode node) {
        DependencyNode winner;
        String premanagedScope;
        Artifact a = node.getArtifact();
        if (a == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(this.toString(a));
        Dependency d = node.getDependency();
        String premanagedVersion = DependencyManagerUtils.getPremanagedVersion(node);
        if (premanagedVersion != null && !premanagedVersion.equals(a.getBaseVersion())) {
            buffer.append(" (version managed from ").append(premanagedVersion).append(")");
        }
        if ((premanagedScope = DependencyManagerUtils.getPremanagedScope(node)) != null && !premanagedScope.equals(d.getScope())) {
            buffer.append(" (scope managed from ").append(premanagedScope).append(")");
        }
        if ((winner = (DependencyNode)node.getData().get("conflict.winner")) != null && !ArtifactIdUtils.equalsId(a, winner.getArtifact())) {
            Artifact w = winner.getArtifact();
            buffer.append(" -> ");
            if (ArtifactIdUtils.toVersionlessId(a).equals(ArtifactIdUtils.toVersionlessId(w))) {
                buffer.append(w.getVersion());
            } else {
                buffer.append(w);
            }
        }
        return buffer.toString();
    }

    private String toString(Artifact a) {
        return a.getGroupId() + ":" + a.getArtifactId() + ":" + a.getVersion();
    }

    private static class ChildInfo {
        final int count;
        int index;

        public ChildInfo(int count) {
            this.count = count;
        }

        public String formatIndentation(boolean end) {
            boolean last;
            boolean bl = last = this.index + 1 >= this.count;
            if (end) {
                return last ? "\\--- " : "+--- ";
            }
            return last ? "     " : "|    ";
        }
    }
}

