/*
 * Decompiled with CFR 0.152.
 */
package capsule;

import capsule.org.eclipse.aether.AbstractRepositoryListener;
import capsule.org.eclipse.aether.RepositoryEvent;
import java.io.PrintStream;

public final class ConsoleRepositoryListener
extends AbstractRepositoryListener {
    private final PrintStream out;
    private final boolean verbose;

    public ConsoleRepositoryListener(boolean verbose, PrintStream out) {
        this.out = out;
        this.verbose = verbose;
    }

    private void println(String str) {
        this.out.println(str);
    }

    private void verbose(String str) {
        if (this.verbose) {
            this.println(str);
        }
    }

    @Override
    public void artifactDownloading(RepositoryEvent ev) {
        if (!this.verbose) {
            this.println("Downloading dependency " + ev.getArtifact());
        } else {
            this.println("Downloading artifact " + ev.getArtifact() + " from " + ev.getRepository());
        }
    }

    @Override
    public void artifactDownloaded(RepositoryEvent ev) {
        this.verbose("Downloaded artifact " + ev.getArtifact() + " from " + ev.getRepository());
    }

    @Override
    public void artifactResolving(RepositoryEvent ev) {
        this.verbose("Resolving artifact " + ev.getArtifact());
    }

    @Override
    public void artifactResolved(RepositoryEvent ev) {
        this.verbose("Resolved artifact " + ev.getArtifact() + " from " + ev.getRepository());
    }

    @Override
    public void metadataResolved(RepositoryEvent ev) {
        this.verbose("Resolved metadata " + ev.getMetadata() + " from " + ev.getRepository());
    }

    @Override
    public void metadataResolving(RepositoryEvent ev) {
        this.verbose("Resolving metadata " + ev.getMetadata() + " from " + ev.getRepository());
    }

    @Override
    public void metadataInvalid(RepositoryEvent ev) {
        this.println("Invalid metadata " + ev.getMetadata());
    }

    @Override
    public void artifactDescriptorInvalid(RepositoryEvent ev) {
        this.println("Invalid artifact descriptor for " + ev.getArtifact() + ": " + ev.getException().getMessage());
    }

    @Override
    public void artifactDescriptorMissing(RepositoryEvent ev) {
        this.println("Missing artifact descriptor for " + ev.getArtifact());
    }

    @Override
    public void artifactInstalling(RepositoryEvent ev) {
        this.println("Installing " + ev.getArtifact() + " to " + ev.getFile());
    }

    @Override
    public void artifactInstalled(RepositoryEvent ev) {
        this.println("Installed " + ev.getArtifact() + " to " + ev.getFile());
    }

    @Override
    public void artifactDeploying(RepositoryEvent ev) {
        this.println("Deploying " + ev.getArtifact() + " to " + ev.getRepository());
    }

    @Override
    public void artifactDeployed(RepositoryEvent ev) {
        this.println("Deployed " + ev.getArtifact() + " to " + ev.getRepository());
    }

    @Override
    public void metadataDeploying(RepositoryEvent ev) {
        this.println("Deploying " + ev.getMetadata() + " to " + ev.getRepository());
    }

    @Override
    public void metadataDeployed(RepositoryEvent ev) {
        this.println("Deployed " + ev.getMetadata() + " to " + ev.getRepository());
    }

    @Override
    public void metadataInstalling(RepositoryEvent ev) {
        this.println("Installing " + ev.getMetadata() + " to " + ev.getFile());
    }

    @Override
    public void metadataInstalled(RepositoryEvent ev) {
        this.println("Installed " + ev.getMetadata() + " to " + ev.getFile());
    }
}

