/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.apache.commons.codec.binary;

public abstract class BaseNCodec {
    protected final byte PAD = (byte)61;
    private final int unencodedBlockSize;
    private final int encodedBlockSize;
    protected final int lineLength;
    private final int chunkSeparatorLength;
    protected byte[] buffer;
    protected int pos;
    private int readPos;
    protected boolean eof;
    protected int currentLinePos;
    protected int modulus;

    protected BaseNCodec(int unencodedBlockSize, int encodedBlockSize, int lineLength, int chunkSeparatorLength) {
        this.unencodedBlockSize = unencodedBlockSize;
        this.encodedBlockSize = encodedBlockSize;
        this.lineLength = lineLength > 0 && chunkSeparatorLength > 0 ? lineLength / encodedBlockSize * encodedBlockSize : 0;
        this.chunkSeparatorLength = chunkSeparatorLength;
    }

    int available() {
        return this.buffer != null ? this.pos - this.readPos : 0;
    }

    protected int getDefaultBufferSize() {
        return 8192;
    }

    private void resizeBuffer() {
        if (this.buffer == null) {
            this.buffer = new byte[this.getDefaultBufferSize()];
            this.pos = 0;
            this.readPos = 0;
        } else {
            byte[] b = new byte[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, b, 0, this.buffer.length);
            this.buffer = b;
        }
    }

    protected void ensureBufferSize(int size) {
        if (this.buffer == null || this.buffer.length < this.pos + size) {
            this.resizeBuffer();
        }
    }

    int readResults(byte[] b, int bPos, int bAvail) {
        if (this.buffer != null) {
            int len = Math.min(this.available(), bAvail);
            System.arraycopy(this.buffer, this.readPos, b, bPos, len);
            this.readPos += len;
            if (this.readPos >= this.pos) {
                this.buffer = null;
            }
            return len;
        }
        return this.eof ? -1 : 0;
    }

    private void reset() {
        this.buffer = null;
        this.pos = 0;
        this.readPos = 0;
        this.currentLinePos = 0;
        this.modulus = 0;
        this.eof = false;
    }

    public byte[] decode(byte[] pArray) {
        this.reset();
        if (pArray == null || pArray.length == 0) {
            return pArray;
        }
        this.decode(pArray, 0, pArray.length);
        this.decode(pArray, 0, -1);
        byte[] result = new byte[this.pos];
        this.readResults(result, 0, result.length);
        return result;
    }

    public byte[] encode(byte[] pArray) {
        this.reset();
        if (pArray == null || pArray.length == 0) {
            return pArray;
        }
        this.encode(pArray, 0, pArray.length);
        this.encode(pArray, 0, -1);
        byte[] buf = new byte[this.pos - this.readPos];
        this.readResults(buf, 0, buf.length);
        return buf;
    }

    abstract void encode(byte[] var1, int var2, int var3);

    abstract void decode(byte[] var1, int var2, int var3);

    protected abstract boolean isInAlphabet(byte var1);

    protected boolean containsAlphabetOrPad(byte[] arrayOctet) {
        if (arrayOctet == null) {
            return false;
        }
        for (byte element : arrayOctet) {
            if (61 != element && !this.isInAlphabet(element)) continue;
            return true;
        }
        return false;
    }

    public long getEncodedLength(byte[] pArray) {
        long len = (long)((pArray.length + this.unencodedBlockSize - 1) / this.unencodedBlockSize) * (long)this.encodedBlockSize;
        if (this.lineLength > 0) {
            len += (len + (long)this.lineLength - 1L) / (long)this.lineLength * (long)this.chunkSeparatorLength;
        }
        return len;
    }
}

