/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.apache.http.client.methods;

import capsule.org.apache.http.ProtocolVersion;
import capsule.org.apache.http.RequestLine;
import capsule.org.apache.http.client.config.RequestConfig;
import capsule.org.apache.http.client.methods.AbstractExecutionAwareRequest;
import capsule.org.apache.http.client.methods.Configurable;
import capsule.org.apache.http.client.methods.HttpUriRequest;
import capsule.org.apache.http.message.BasicRequestLine;
import capsule.org.apache.http.params.HttpProtocolParams;
import java.net.URI;

public abstract class HttpRequestBase
extends AbstractExecutionAwareRequest
implements Configurable,
HttpUriRequest {
    private ProtocolVersion version;
    private URI uri;
    private RequestConfig config;

    public abstract String getMethod();

    public void setProtocolVersion(ProtocolVersion version) {
        this.version = version;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.version != null ? this.version : HttpProtocolParams.getVersion(this.getParams());
    }

    public URI getURI() {
        return this.uri;
    }

    public RequestLine getRequestLine() {
        String method = this.getMethod();
        ProtocolVersion ver = this.getProtocolVersion();
        URI uri = this.getURI();
        String uritext = null;
        if (uri != null) {
            uritext = uri.toASCIIString();
        }
        if (uritext == null || uritext.length() == 0) {
            uritext = "/";
        }
        return new BasicRequestLine(method, uritext, ver);
    }

    public RequestConfig getConfig() {
        return this.config;
    }

    public void setConfig(RequestConfig config) {
        this.config = config;
    }

    public void setURI(URI uri) {
        this.uri = uri;
    }

    public String toString() {
        return this.getMethod() + " " + this.getURI() + " " + this.getProtocolVersion();
    }
}

