/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.apache.http.client.methods;

import capsule.org.apache.http.HttpEntity;
import capsule.org.apache.http.HttpEntityEnclosingRequest;
import capsule.org.apache.http.HttpRequest;
import capsule.org.apache.http.NameValuePair;
import capsule.org.apache.http.ProtocolVersion;
import capsule.org.apache.http.client.config.RequestConfig;
import capsule.org.apache.http.client.entity.UrlEncodedFormEntity;
import capsule.org.apache.http.client.methods.Configurable;
import capsule.org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import capsule.org.apache.http.client.methods.HttpRequestBase;
import capsule.org.apache.http.client.methods.HttpUriRequest;
import capsule.org.apache.http.client.utils.URIBuilder;
import capsule.org.apache.http.message.HeaderGroup;
import capsule.org.apache.http.protocol.HTTP;
import capsule.org.apache.http.util.Args;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;

public class RequestBuilder {
    private String method;
    private ProtocolVersion version;
    private URI uri;
    private HeaderGroup headergroup;
    private HttpEntity entity;
    private LinkedList<NameValuePair> parameters;
    private RequestConfig config;

    RequestBuilder(String method) {
        this.method = method;
    }

    RequestBuilder() {
        this(null);
    }

    public static RequestBuilder copy(HttpRequest request) {
        Args.notNull(request, "HTTP request");
        return new RequestBuilder().doCopy(request);
    }

    private RequestBuilder doCopy(HttpRequest request) {
        if (request == null) {
            return this;
        }
        this.method = request.getRequestLine().getMethod();
        this.version = request.getRequestLine().getProtocolVersion();
        this.uri = request instanceof HttpUriRequest ? ((HttpUriRequest)request).getURI() : URI.create(request.getRequestLine().getUri());
        if (this.headergroup == null) {
            this.headergroup = new HeaderGroup();
        }
        this.headergroup.clear();
        this.headergroup.setHeaders(request.getAllHeaders());
        this.entity = request instanceof HttpEntityEnclosingRequest ? ((HttpEntityEnclosingRequest)request).getEntity() : null;
        this.config = request instanceof Configurable ? ((Configurable)((Object)request)).getConfig() : null;
        this.parameters = null;
        return this;
    }

    public RequestBuilder setUri(URI uri) {
        this.uri = uri;
        return this;
    }

    public HttpUriRequest build() {
        HttpRequestBase result;
        URI uri = this.uri != null ? this.uri : URI.create("/");
        HttpEntity entity = this.entity;
        if (this.parameters != null && !this.parameters.isEmpty()) {
            if (entity == null && ("POST".equalsIgnoreCase(this.method) || "PUT".equalsIgnoreCase(this.method))) {
                entity = new UrlEncodedFormEntity(this.parameters, HTTP.DEF_CONTENT_CHARSET);
            } else {
                try {
                    uri = new URIBuilder(uri).addParameters(this.parameters).build();
                }
                catch (URISyntaxException ex) {
                    // empty catch block
                }
            }
        }
        if (entity == null) {
            result = new InternalRequest(this.method);
        } else {
            InternalEntityEclosingRequest request = new InternalEntityEclosingRequest(this.method);
            request.setEntity(entity);
            result = request;
        }
        result.setProtocolVersion(this.version);
        result.setURI(uri);
        if (this.headergroup != null) {
            result.setHeaders(this.headergroup.getAllHeaders());
        }
        result.setConfig(this.config);
        return result;
    }

    static class InternalEntityEclosingRequest
    extends HttpEntityEnclosingRequestBase {
        private final String method;

        InternalEntityEclosingRequest(String method) {
            this.method = method;
        }

        public String getMethod() {
            return this.method;
        }
    }

    static class InternalRequest
    extends HttpRequestBase {
        private final String method;

        InternalRequest(String method) {
            this.method = method;
        }

        public String getMethod() {
            return this.method;
        }
    }
}

