/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.apache.http.impl.auth;

import capsule.org.apache.commons.codec.binary.Base64;
import capsule.org.apache.http.Consts;
import capsule.org.apache.http.Header;
import capsule.org.apache.http.HttpRequest;
import capsule.org.apache.http.auth.AuthenticationException;
import capsule.org.apache.http.auth.Credentials;
import capsule.org.apache.http.auth.MalformedChallengeException;
import capsule.org.apache.http.impl.auth.RFC2617Scheme;
import capsule.org.apache.http.message.BufferedHeader;
import capsule.org.apache.http.protocol.BasicHttpContext;
import capsule.org.apache.http.protocol.HttpContext;
import capsule.org.apache.http.util.Args;
import capsule.org.apache.http.util.CharArrayBuffer;
import capsule.org.apache.http.util.EncodingUtils;
import java.nio.charset.Charset;

public class BasicScheme
extends RFC2617Scheme {
    private final Base64 base64codec = new Base64(0);
    private boolean complete = false;

    public BasicScheme(Charset credentialsCharset) {
        super(credentialsCharset);
    }

    public BasicScheme() {
        this(Consts.ASCII);
    }

    public String getSchemeName() {
        return "basic";
    }

    public void processChallenge(Header header) throws MalformedChallengeException {
        super.processChallenge(header);
        this.complete = true;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean isConnectionBased() {
        return false;
    }

    @Deprecated
    public Header authenticate(Credentials credentials, HttpRequest request) throws AuthenticationException {
        return this.authenticate(credentials, request, new BasicHttpContext());
    }

    public Header authenticate(Credentials credentials, HttpRequest request, HttpContext context) throws AuthenticationException {
        Args.notNull(credentials, "Credentials");
        Args.notNull(request, "HTTP request");
        StringBuilder tmp = new StringBuilder();
        tmp.append(credentials.getUserPrincipal().getName());
        tmp.append(":");
        tmp.append(credentials.getPassword() == null ? "null" : credentials.getPassword());
        byte[] base64password = this.base64codec.encode(EncodingUtils.getBytes(tmp.toString(), this.getCredentialsCharset(request)));
        CharArrayBuffer buffer = new CharArrayBuffer(32);
        if (this.isProxy()) {
            buffer.append("Proxy-Authorization");
        } else {
            buffer.append("Authorization");
        }
        buffer.append(": Basic ");
        buffer.append(base64password, 0, base64password.length);
        return new BufferedHeader(buffer);
    }
}

