/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.apache.maven.model.building;

import capsule.org.apache.maven.model.DependencyManagement;
import capsule.org.apache.maven.model.Model;
import capsule.org.apache.maven.model.building.ModelData;

interface ModelCacheTag<T> {
    public static final ModelCacheTag<ModelData> RAW = new ModelCacheTag<ModelData>(){

        @Override
        public String getName() {
            return "raw";
        }

        @Override
        public Class<ModelData> getType() {
            return ModelData.class;
        }

        public ModelData intoCache(ModelData data) {
            Model model = data.getModel() != null ? data.getModel().clone() : null;
            return new ModelData(data.getSource(), model, data.getGroupId(), data.getArtifactId(), data.getVersion());
        }

        public ModelData fromCache(ModelData data) {
            return this.intoCache(data);
        }
    };
    public static final ModelCacheTag<DependencyManagement> IMPORT = new ModelCacheTag<DependencyManagement>(){

        @Override
        public String getName() {
            return "import";
        }

        @Override
        public Class<DependencyManagement> getType() {
            return DependencyManagement.class;
        }

        public DependencyManagement intoCache(DependencyManagement data) {
            return data != null ? data.clone() : null;
        }

        public DependencyManagement fromCache(DependencyManagement data) {
            return this.intoCache(data);
        }
    };

    public String getName();

    public Class<T> getType();

    public Object intoCache(Object var1);

    public Object fromCache(Object var1);
}

