/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.eclipse.aether.internal.impl;

import capsule.org.eclipse.aether.RepositorySystemSession;
import capsule.org.eclipse.aether.artifact.Artifact;
import capsule.org.eclipse.aether.internal.impl.SimpleLocalRepositoryManager;
import capsule.org.eclipse.aether.internal.impl.TrackingFileManager;
import capsule.org.eclipse.aether.repository.LocalArtifactRegistration;
import capsule.org.eclipse.aether.repository.LocalArtifactRequest;
import capsule.org.eclipse.aether.repository.LocalArtifactResult;
import capsule.org.eclipse.aether.repository.RemoteRepository;
import capsule.org.eclipse.aether.spi.log.Logger;
import capsule.org.eclipse.aether.util.ConfigUtils;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EnhancedLocalRepositoryManager
extends SimpleLocalRepositoryManager {
    private final String trackingFilename;
    private final TrackingFileManager trackingFileManager;

    public EnhancedLocalRepositoryManager(File basedir, RepositorySystemSession session) {
        super(basedir, "enhanced");
        String filename = ConfigUtils.getString(session, "", "aether.enhancedLocalRepository.trackingFilename");
        if (filename.length() <= 0 || filename.contains("/") || filename.contains("\\") || filename.contains("..")) {
            filename = "_remote.repositories";
        }
        this.trackingFilename = filename;
        this.trackingFileManager = new TrackingFileManager();
    }

    @Override
    public EnhancedLocalRepositoryManager setLogger(Logger logger) {
        super.setLogger(logger);
        this.trackingFileManager.setLogger(logger);
        return this;
    }

    @Override
    public LocalArtifactResult find(RepositorySystemSession session, LocalArtifactRequest request) {
        String path = this.getPathForArtifact(request.getArtifact(), false);
        File file = new File(this.getRepository().getBasedir(), path);
        LocalArtifactResult result = new LocalArtifactResult(request);
        if (file.isFile()) {
            result.setFile(file);
            Properties props = this.readRepos(file);
            if (props.get(this.getKey(file, "")) != null) {
                result.setAvailable(true);
            } else {
                String context = request.getContext();
                for (RemoteRepository repository : request.getRepositories()) {
                    if (props.get(this.getKey(file, this.getRepositoryKey(repository, context))) == null) continue;
                    result.setAvailable(true);
                    result.setRepository(repository);
                    break;
                }
                if (!result.isAvailable() && !this.isTracked(props, file)) {
                    result.setAvailable(true);
                }
            }
        }
        return result;
    }

    @Override
    public void add(RepositorySystemSession session, LocalArtifactRegistration request) {
        Collection<String> repositories = request.getRepository() == null ? Collections.singleton("") : this.getRepositoryKeys(request.getRepository(), request.getContexts());
        this.addArtifact(request.getArtifact(), repositories, request.getRepository() == null);
    }

    private Collection<String> getRepositoryKeys(RemoteRepository repository, Collection<String> contexts) {
        HashSet<String> keys = new HashSet<String>();
        if (contexts != null) {
            for (String context : contexts) {
                keys.add(this.getRepositoryKey(repository, context));
            }
        }
        return keys;
    }

    private void addArtifact(Artifact artifact, Collection<String> repositories, boolean local) {
        if (artifact == null) {
            throw new IllegalArgumentException("artifact to register not specified");
        }
        String path = this.getPathForArtifact(artifact, local);
        File file = new File(this.getRepository().getBasedir(), path);
        this.addRepo(file, repositories);
    }

    private Properties readRepos(File artifactFile) {
        File trackingFile = this.getTrackingFile(artifactFile);
        Properties props = this.trackingFileManager.read(trackingFile);
        return props != null ? props : new Properties();
    }

    private void addRepo(File artifactFile, Collection<String> repositories) {
        HashMap<String, String> updates = new HashMap<String, String>();
        for (String repository : repositories) {
            updates.put(this.getKey(artifactFile, repository), "");
        }
        File trackingFile = this.getTrackingFile(artifactFile);
        this.trackingFileManager.update(trackingFile, updates);
    }

    private File getTrackingFile(File artifactFile) {
        return new File(artifactFile.getParentFile(), this.trackingFilename);
    }

    private String getKey(File file, String repository) {
        return file.getName() + '>' + repository;
    }

    private boolean isTracked(Properties props, File file) {
        if (props != null) {
            String keyPrefix = file.getName() + '>';
            for (Object key : props.keySet()) {
                if (!key.toString().startsWith(keyPrefix)) continue;
                return true;
            }
        }
        return false;
    }
}

