/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.eclipse.aether.spi.connector.transport;

import capsule.org.eclipse.aether.spi.connector.transport.GetTask;
import capsule.org.eclipse.aether.spi.connector.transport.PeekTask;
import capsule.org.eclipse.aether.spi.connector.transport.TransportListener;
import capsule.org.eclipse.aether.spi.connector.transport.TransportTask;
import capsule.org.eclipse.aether.spi.connector.transport.Transporter;
import capsule.org.eclipse.aether.transfer.TransferCancelledException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractTransporter
implements Transporter {
    private final AtomicBoolean closed = new AtomicBoolean();

    protected AbstractTransporter() {
    }

    public void peek(PeekTask task) throws Exception {
        this.failIfClosed(task);
        this.implPeek(task);
    }

    protected abstract void implPeek(PeekTask var1) throws Exception;

    public void get(GetTask task) throws Exception {
        this.failIfClosed(task);
        this.implGet(task);
    }

    protected abstract void implGet(GetTask var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void utilGet(GetTask task, InputStream is, boolean close, long length, boolean resume) throws IOException, TransferCancelledException {
        try {
            task.getListener().transportStarted(resume ? task.getResumeOffset() : 0L, length);
            OutputStream os = task.newOutputStream(resume);
            try {
                AbstractTransporter.copy(os, is, task.getListener());
                os.close();
            }
            finally {
                AbstractTransporter.close(os);
            }
        }
        finally {
            if (close) {
                AbstractTransporter.close(is);
            }
        }
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.implClose();
        }
    }

    protected abstract void implClose();

    private void failIfClosed(TransportTask task) {
        if (this.closed.get()) {
            throw new IllegalStateException("transporter closed, cannot execute task " + task);
        }
    }

    private static void copy(OutputStream os, InputStream is, TransportListener listener) throws IOException, TransferCancelledException {
        ByteBuffer buffer = ByteBuffer.allocate(32768);
        byte[] array = buffer.array();
        int read = is.read(array);
        while (read >= 0) {
            os.write(array, 0, read);
            buffer.rewind();
            buffer.limit(read);
            listener.transportProgressed(buffer);
            read = is.read(array);
        }
    }

    private static void close(Closeable file) {
        if (file != null) {
            try {
                file.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

