/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.eclipse.aether.transport.http;

import capsule.org.apache.http.HttpHost;
import capsule.org.apache.http.auth.AuthScope;
import capsule.org.apache.http.auth.Credentials;
import capsule.org.apache.http.client.CredentialsProvider;

final class DemuxCredentialsProvider
implements CredentialsProvider {
    private final CredentialsProvider serverCredentialsProvider;
    private final CredentialsProvider proxyCredentialsProvider;
    private final HttpHost proxy;

    public DemuxCredentialsProvider(CredentialsProvider serverCredentialsProvider, CredentialsProvider proxyCredentialsProvider, HttpHost proxy) {
        this.serverCredentialsProvider = serverCredentialsProvider;
        this.proxyCredentialsProvider = proxyCredentialsProvider;
        this.proxy = proxy;
    }

    private CredentialsProvider getDelegate(AuthScope authScope) {
        if (this.proxy.getPort() == authScope.getPort() && this.proxy.getHostName().equalsIgnoreCase(authScope.getHost())) {
            return this.proxyCredentialsProvider;
        }
        return this.serverCredentialsProvider;
    }

    public Credentials getCredentials(AuthScope authScope) {
        return this.getDelegate(authScope).getCredentials(authScope);
    }

    public void setCredentials(AuthScope authScope, Credentials credentials) {
        this.getDelegate(authScope).setCredentials(authScope, credentials);
    }
}

