/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.eclipse.aether.transport.http;

import capsule.org.apache.http.HttpHost;
import capsule.org.apache.http.auth.AuthScheme;
import capsule.org.apache.http.conn.ClientConnectionManager;
import capsule.org.eclipse.aether.RepositorySystemSession;
import capsule.org.eclipse.aether.repository.RemoteRepository;
import capsule.org.eclipse.aether.transport.http.AuthSchemePool;
import capsule.org.eclipse.aether.transport.http.GlobalState;
import capsule.org.eclipse.aether.transport.http.SslConfig;
import capsule.org.eclipse.aether.util.ConfigUtils;
import java.io.Closeable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

final class LocalState
implements Closeable {
    private final GlobalState global;
    private final ClientConnectionManager connMgr;
    private final GlobalState.CompoundKey userTokenKey;
    private volatile Object userToken;
    private final GlobalState.CompoundKey expectContinueKey;
    private volatile boolean probed;
    private volatile Boolean expectContinue;
    private volatile Boolean webDav;
    private final ConcurrentMap<HttpHost, AuthSchemePool> authSchemePools;

    public LocalState(RepositorySystemSession session, RemoteRepository repo, SslConfig sslConfig) {
        this.global = GlobalState.get(session);
        this.userToken = this;
        if (this.global == null) {
            this.connMgr = GlobalState.newConnectionManager(sslConfig);
            this.userTokenKey = null;
            this.expectContinueKey = null;
            this.authSchemePools = new ConcurrentHashMap<HttpHost, AuthSchemePool>();
        } else {
            this.connMgr = this.global.getConnectionManager(sslConfig);
            this.userTokenKey = new GlobalState.CompoundKey(repo.getId(), repo.getUrl(), repo.getAuthentication(), repo.getProxy());
            this.expectContinueKey = new GlobalState.CompoundKey(repo.getUrl(), repo.getProxy());
            this.authSchemePools = this.global.getAuthSchemePools();
        }
        if (!ConfigUtils.getBoolean(session, true, "aether.connector.http.webDav." + repo.getId(), "aether.connector.http.webDav")) {
            this.webDav = false;
        }
    }

    public ClientConnectionManager getConnectionManager() {
        return this.connMgr;
    }

    public Object getUserToken() {
        if (this.userToken == this) {
            this.userToken = this.global != null ? this.global.getUserToken(this.userTokenKey) : null;
        }
        return this.userToken;
    }

    public void setUserToken(Object userToken) {
        this.userToken = userToken;
        if (this.global != null) {
            this.global.setUserToken(this.userTokenKey, userToken);
        }
    }

    public boolean isProbed() {
        return this.probed;
    }

    public void setProbed() {
        this.probed = true;
    }

    public boolean isExpectContinue() {
        if (this.expectContinue == null) {
            this.expectContinue = !Boolean.FALSE.equals(this.global != null ? this.global.getExpectContinue(this.expectContinueKey) : null);
        }
        return this.expectContinue;
    }

    public boolean isWebDav() {
        return Boolean.TRUE.equals(this.webDav);
    }

    public void setWebDav(boolean webDav) {
        if (this.webDav == null) {
            this.webDav = webDav;
        }
    }

    public AuthScheme getAuthScheme(HttpHost host) {
        AuthSchemePool pool = (AuthSchemePool)this.authSchemePools.get(host);
        if (pool != null) {
            return pool.get();
        }
        return null;
    }

    public void setAuthScheme(HttpHost host, AuthScheme authScheme) {
        AuthSchemePool p;
        AuthSchemePool pool = (AuthSchemePool)this.authSchemePools.get(host);
        if (pool == null && (pool = this.authSchemePools.putIfAbsent(host, p = new AuthSchemePool())) == null) {
            pool = p;
        }
        pool.put(authScheme);
    }

    public void close() {
        if (this.global == null) {
            this.connMgr.shutdown();
        }
    }
}

