/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.eclipse.aether.util;

import capsule.org.eclipse.aether.RepositorySystemSession;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfigUtils {
    public static String getString(Map<?, ?> properties, String defaultValue, String ... keys) {
        for (String key : keys) {
            Object value = properties.get(key);
            if (!(value instanceof String) && !(value instanceof Boolean) && !(value instanceof Number)) continue;
            return value.toString();
        }
        return defaultValue;
    }

    public static String getString(RepositorySystemSession session, String defaultValue, String ... keys) {
        return ConfigUtils.getString(session.getConfigProperties(), defaultValue, keys);
    }

    public static int getInteger(Map<?, ?> properties, int defaultValue, String ... keys) {
        for (String key : keys) {
            Object value = properties.get(key);
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            try {
                return Integer.valueOf((String)value);
            }
            catch (Exception e) {
            }
        }
        return defaultValue;
    }

    public static int getInteger(RepositorySystemSession session, int defaultValue, String ... keys) {
        return ConfigUtils.getInteger(session.getConfigProperties(), defaultValue, keys);
    }

    public static long getLong(Map<?, ?> properties, long defaultValue, String ... keys) {
        for (String key : keys) {
            Object value = properties.get(key);
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            try {
                return Long.valueOf((String)value);
            }
            catch (Exception e) {
            }
        }
        return defaultValue;
    }

    public static long getLong(RepositorySystemSession session, long defaultValue, String ... keys) {
        return ConfigUtils.getLong(session.getConfigProperties(), defaultValue, keys);
    }

    public static float getFloat(Map<?, ?> properties, float defaultValue, String ... keys) {
        for (String key : keys) {
            Object value = properties.get(key);
            if (value instanceof Number) {
                return ((Number)value).floatValue();
            }
            try {
                return Float.valueOf((String)value).floatValue();
            }
            catch (Exception e) {
            }
        }
        return defaultValue;
    }

    public static boolean getBoolean(Map<?, ?> properties, boolean defaultValue, String ... keys) {
        for (String key : keys) {
            Object value = properties.get(key);
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (!(value instanceof String)) continue;
            return Boolean.parseBoolean((String)value);
        }
        return defaultValue;
    }

    public static boolean getBoolean(RepositorySystemSession session, boolean defaultValue, String ... keys) {
        return ConfigUtils.getBoolean(session.getConfigProperties(), defaultValue, keys);
    }

    public static Map<?, ?> getMap(Map<?, ?> properties, Map<?, ?> defaultValue, String ... keys) {
        for (String key : keys) {
            Object value = properties.get(key);
            if (!(value instanceof Map)) continue;
            return (Map)value;
        }
        return defaultValue;
    }

    public static Map<?, ?> getMap(RepositorySystemSession session, Map<?, ?> defaultValue, String ... keys) {
        return ConfigUtils.getMap(session.getConfigProperties(), defaultValue, keys);
    }
}

