/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.ajax;

import java.io.IOException;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractTransformer;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.RedundantNamespacesFilter;
import org.apache.cocoon.xml.XMLConsumer;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class BrowserUpdateTransformer
extends AbstractTransformer {
    public static final String AJAXMODE_PARAM = "cocoon-ajax";
    public static final String BU_NSURI = "http://apache.org/cocoon/browser-update/1.0";
    private boolean ajaxRequest = false;
    private int replaceDepth = 0;
    private boolean inUpdateTag = false;
    private String updateTagId = null;
    Locator locator;

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        this.ajaxRequest = request.getParameter(AJAXMODE_PARAM) != null;
        this.replaceDepth = 0;
        this.inUpdateTag = false;
    }

    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
        this.locator = locator;
    }

    public void startDocument() throws SAXException {
        if (this.ajaxRequest) {
            RedundantNamespacesFilter nsPipe = new RedundantNamespacesFilter();
            if (this.xmlConsumer != null) {
                nsPipe.setConsumer(this.xmlConsumer);
            } else {
                nsPipe.setContentHandler(this.contentHandler);
            }
            this.setConsumer((XMLConsumer)nsPipe);
        }
        super.startDocument();
        if (this.ajaxRequest) {
            super.startPrefixMapping("bu", BU_NSURI);
            super.startElement(BU_NSURI, "document", "bu:document", (Attributes)new AttributesImpl());
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (!this.ajaxRequest || this.replaceDepth > 0) {
            super.startPrefixMapping(prefix, uri);
        }
    }

    public void startElement(String uri, String loc, String raw, Attributes attrs) throws SAXException {
        if (BU_NSURI.equals(uri) && "replace".equals(loc)) {
            this.updateTagId = attrs.getValue("id");
            this.inUpdateTag = true;
            if (this.ajaxRequest && this.replaceDepth == 0) {
                super.startElement(uri, loc, raw, attrs);
            }
            ++this.replaceDepth;
        } else {
            if (this.inUpdateTag) {
                this.inUpdateTag = false;
                String localId = attrs.getValue("id");
                if (localId != null) {
                    if (this.updateTagId != null && !localId.equals(this.updateTagId)) {
                        throw new SAXParseException("Id on bu:replace (" + this.updateTagId + ") and " + raw + " (" + localId + ") don't match.", this.locator);
                    }
                } else {
                    if (this.updateTagId == null) {
                        throw new SAXParseException("Neither bu:replace nor " + raw + " have an id attribute.", this.locator);
                    }
                    AttributesImpl newAttrs = new AttributesImpl(attrs);
                    newAttrs.addCDATAAttribute("id", this.updateTagId);
                    attrs = newAttrs;
                }
                this.updateTagId = null;
            }
            if (!this.ajaxRequest || this.replaceDepth > 0) {
                super.startElement(uri, loc, raw, attrs);
            }
        }
    }

    public void characters(char[] buffer, int offset, int len) throws SAXException {
        if (this.inUpdateTag) {
            for (int i = offset; i < len; ++i) {
                if (Character.isWhitespace(buffer[i])) continue;
                throw new SAXParseException("bu:replace must include a single child element and no text.", this.locator);
            }
        }
        if (!this.ajaxRequest || this.replaceDepth > 0) {
            super.characters(buffer, offset, len);
        }
    }

    public void endElement(String uri, String loc, String raw) throws SAXException {
        if (BU_NSURI.equals(uri) && "replace".equals(loc)) {
            --this.replaceDepth;
            if (this.ajaxRequest && this.replaceDepth == 0) {
                super.endElement(uri, loc, raw);
            }
        } else if (!this.ajaxRequest || this.replaceDepth > 0) {
            super.endElement(uri, loc, raw);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        if (!this.ajaxRequest || this.replaceDepth > 0) {
            super.endPrefixMapping(prefix);
        }
    }

    public void endDocument() throws SAXException {
        if (this.ajaxRequest) {
            super.endElement(BU_NSURI, "document", "bu:document");
            super.endPrefixMapping("bu");
        }
        super.endDocument();
    }

    public void recycle() {
        this.locator = null;
        this.updateTagId = null;
        super.recycle();
    }
}

