/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.flow.java;

import java.io.OutputStream;
import java.util.Map;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.components.flow.FlowHelper;
import org.apache.cocoon.components.flow.java.Continuable;
import org.apache.cocoon.components.flow.java.Continuation;
import org.apache.cocoon.components.flow.java.ContinuationContext;
import org.apache.cocoon.components.flow.java.VarMap;
import org.apache.cocoon.components.flow.util.PipelineUtil;
import org.apache.cocoon.environment.Request;
import org.apache.excalibur.source.SourceUtil;

public abstract class AbstractContinuable
implements Continuable {
    private ContinuationContext getContext() {
        if (Continuation.currentContinuation() == null) {
            throw new IllegalStateException("No continuation is running");
        }
        return (ContinuationContext)Continuation.currentContinuation().getContext();
    }

    public Logger getLogger() {
        return this.getContext().getLogger();
    }

    public void sendPageAndWait(String uri) {
        this.sendPageAndWait(uri, new VarMap());
    }

    public void sendPageAndWait(String uri, Object bizdata) {
        ContinuationContext context = this.getContext();
        if (context.getLogger() != null) {
            context.getLogger().debug("send page and wait '" + uri + "'");
        }
        FlowHelper.setContextObject((Map)ContextHelper.getObjectModel((Context)context.getAvalonContext()), (Object)bizdata);
        if (SourceUtil.indexOfSchemeColon((String)uri) == -1) {
            uri = "cocoon:/" + uri;
            if (this.getContext().getRedirector().hasRedirected()) {
                throw new IllegalStateException("Pipeline has already been processed for this request");
            }
            try {
                context.getRedirector().redirect(false, uri);
            }
            catch (Exception e) {
                throw new CascadingRuntimeException("Cannot redirect to '" + uri + "'", (Throwable)e);
            }
        } else {
            throw new IllegalArgumentException("uri is not allowed to contain a scheme (cocoon:/ is always automatically used)");
        }
        Continuation.suspend();
    }

    public void sendPage(String uri) {
        this.sendPage(uri, new VarMap());
    }

    public void sendPage(String uri, Object bizdata) {
        ContinuationContext context = this.getContext();
        if (context.getLogger() != null) {
            context.getLogger().debug("send page '" + uri + "'");
        }
        FlowHelper.setContextObject((Map)ContextHelper.getObjectModel((Context)context.getAvalonContext()), (Object)bizdata);
        if (SourceUtil.indexOfSchemeColon((String)uri) == -1) {
            uri = "cocoon:/" + uri;
            if (this.getContext().getRedirector().hasRedirected()) {
                throw new IllegalStateException("Pipeline has already been processed for this request");
            }
            try {
                context.getRedirector().redirect(false, uri);
            }
            catch (Exception e) {
                throw new CascadingRuntimeException("Cannot redirect to '" + uri + "'", (Throwable)e);
            }
        } else {
            throw new IllegalArgumentException("uri is not allowed to contain a scheme (cocoon:/ is always automatically used)");
        }
    }

    public Request getRequest() {
        return ContextHelper.getRequest((Context)this.getContext().getAvalonContext());
    }

    public Map getObjectModel() {
        return ContextHelper.getObjectModel((Context)this.getContext().getAvalonContext());
    }

    public void processPipelineTo(String uri, Object bizdata, OutputStream out) {
        ContinuationContext context = this.getContext();
        PipelineUtil pipeUtil = new PipelineUtil();
        try {
            try {
                pipeUtil.contextualize(context.getAvalonContext());
                pipeUtil.service(context.getServiceManager());
                pipeUtil.processToStream(uri, bizdata, out);
            }
            catch (Exception e) {
                throw new CascadingRuntimeException("Cannot process pipeline to '" + uri + "'", (Throwable)e);
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            pipeUtil.dispose();
            throw throwable;
        }
        pipeUtil.dispose();
    }

    public void redirectTo(String uri) {
        try {
            this.getContext().getRedirector().redirect(false, uri);
        }
        catch (Exception e) {
            throw new CascadingRuntimeException("Cannot redirect to '" + uri + "'", (Throwable)e);
        }
    }

    public void sendStatus(int sc) {
        this.getContext().getRedirector().sendStatus(sc);
    }

    public Object getComponent(String id) {
        try {
            return this.getContext().getServiceManager().lookup(id);
        }
        catch (Exception e) {
            throw new CascadingRuntimeException("Cannot lookup component '" + id + "'", (Throwable)e);
        }
    }

    public void releaseComponent(Object component) {
        if (component != null) {
            this.getContext().getServiceManager().release(component);
        }
    }
}

