/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.flow.java;

import java.util.ArrayList;
import java.util.Vector;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ACONST_NULL;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.GOTO;
import org.apache.bcel.generic.IFEQ;
import org.apache.bcel.generic.IFNONNULL;
import org.apache.bcel.generic.IFNULL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.InstructionTargeter;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.RET;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.ReturnaddressType;
import org.apache.bcel.generic.SWAP;
import org.apache.bcel.generic.TABLESWITCH;
import org.apache.bcel.generic.TargetLostException;
import org.apache.bcel.generic.Type;
import org.apache.bcel.util.ClassLoaderRepository;
import org.apache.bcel.verifier.exc.AssertionViolatedException;
import org.apache.bcel.verifier.structurals.ControlFlowGraph;
import org.apache.bcel.verifier.structurals.ExceptionHandler;
import org.apache.bcel.verifier.structurals.ExecutionVisitor;
import org.apache.bcel.verifier.structurals.Frame;
import org.apache.bcel.verifier.structurals.InstConstraintVisitor;
import org.apache.bcel.verifier.structurals.InstructionContext;
import org.apache.bcel.verifier.structurals.LocalVariables;
import org.apache.bcel.verifier.structurals.OperandStack;
import org.apache.bcel.verifier.structurals.UninitializedObjectType;

public class ContinuationClassLoader
extends ClassLoader {
    private static final String CONTINUATION_CLASS = (class$org$apache$cocoon$components$flow$java$Continuation == null ? (class$org$apache$cocoon$components$flow$java$Continuation = ContinuationClassLoader.class$("org.apache.cocoon.components.flow.java.Continuation")) : class$org$apache$cocoon$components$flow$java$Continuation).getName();
    private static final ObjectType CONTINUATION_TYPE = new ObjectType(CONTINUATION_CLASS);
    private static final String STACK_CLASS = (class$org$apache$cocoon$components$flow$java$ContinuationStack == null ? (class$org$apache$cocoon$components$flow$java$ContinuationStack = ContinuationClassLoader.class$("org.apache.cocoon.components.flow.java.ContinuationStack")) : class$org$apache$cocoon$components$flow$java$ContinuationStack).getName();
    private static final ObjectType STACK_TYPE = new ObjectType(STACK_CLASS);
    private static final String CONTINUABLE_CLASS = (class$org$apache$cocoon$components$flow$java$Continuable == null ? (class$org$apache$cocoon$components$flow$java$Continuable = ContinuationClassLoader.class$("org.apache.cocoon.components.flow.java.Continuable")) : class$org$apache$cocoon$components$flow$java$Continuable).getName();
    private static final String CONTINUATIONCAPABLE_CLASS = (class$org$apache$cocoon$components$flow$java$ContinuationCapable == null ? (class$org$apache$cocoon$components$flow$java$ContinuationCapable = ContinuationClassLoader.class$("org.apache.cocoon.components.flow.java.ContinuationCapable")) : class$org$apache$cocoon$components$flow$java$ContinuationCapable).getName();
    private static final String CONTINUATION_METHOD = "currentContinuation";
    private static final String STACK_METHOD = "getStack";
    private static final String POP_METHOD = "pop";
    private static final String PUSH_METHOD = "push";
    private static final String RESTORING_METHOD = "isRestoring";
    private static final String CAPURING_METHOD = "isCapturing";
    private static boolean currentMethodStatic;
    static /* synthetic */ Class class$org$apache$cocoon$components$flow$java$Continuation;
    static /* synthetic */ Class class$org$apache$cocoon$components$flow$java$ContinuationStack;
    static /* synthetic */ Class class$org$apache$cocoon$components$flow$java$Continuable;
    static /* synthetic */ Class class$org$apache$cocoon$components$flow$java$ContinuationCapable;

    public ContinuationClassLoader(ClassLoader parent) {
        super(parent);
        Repository.setRepository((org.apache.bcel.util.Repository)new ClassLoaderRepository(parent));
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c;
        if ((class$org$apache$cocoon$components$flow$java$Continuable == null ? (class$org$apache$cocoon$components$flow$java$Continuable = ContinuationClassLoader.class$("org.apache.cocoon.components.flow.java.Continuable")) : class$org$apache$cocoon$components$flow$java$Continuable).isAssignableFrom(c = super.loadClass(name, resolve)) && !(class$org$apache$cocoon$components$flow$java$ContinuationCapable == null ? (class$org$apache$cocoon$components$flow$java$ContinuationCapable = ContinuationClassLoader.class$("org.apache.cocoon.components.flow.java.ContinuationCapable")) : class$org$apache$cocoon$components$flow$java$ContinuationCapable).isAssignableFrom(c) && !c.isInterface()) {
            JavaClass clazz = Repository.lookupClass(c);
            byte[] data = this.transform(clazz);
            c = this.defineClass(name, data, 0, data.length);
        }
        if (c == null) {
            throw new ClassNotFoundException(name);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    private byte[] transform(JavaClass javaclazz) throws ClassNotFoundException {
        ClassGen clazz = new ClassGen(javaclazz);
        ConstantPoolGen cp = clazz.getConstantPool();
        InstConstraintVisitor icv = new InstConstraintVisitor();
        icv.setConstantPoolGen(cp);
        ExecutionVisitor ev = new ExecutionVisitor();
        ev.setConstantPoolGen(cp);
        Method[] methods = clazz.getMethods();
        int i = 0;
        while (i < methods.length) {
            MethodGen method = new MethodGen(methods[i], clazz.getClassName(), cp);
            currentMethodStatic = methods[i].isStatic();
            if (this.isValid(method)) {
                ControlFlowGraph cfg = new ControlFlowGraph(method);
                this.analyse(clazz, method, cfg, icv, ev);
                this.rewrite(method, cfg);
                clazz.replaceMethod(methods[i], method.getMethod());
            }
            ++i;
        }
        clazz.addInterface(CONTINUATIONCAPABLE_CLASS);
        return clazz.getJavaClass().getBytes();
    }

    private boolean isValid(MethodGen m) {
        return !m.getName().equals("<init>") && !m.getName().equals("<clinit>") && !m.isNative() && !m.isAbstract();
    }

    private void analyse(ClassGen clazz, MethodGen method, ControlFlowGraph cfg, InstConstraintVisitor icv, ExecutionVisitor ev) {
        Frame vanillaFrame = new Frame(method.getMaxLocals(), method.getMaxStack());
        if (!method.isStatic()) {
            if (method.getName().equals("<init>")) {
                Frame._this = new UninitializedObjectType(new ObjectType(clazz.getClassName()));
                vanillaFrame.getLocals().set(0, (Type)new UninitializedObjectType(new ObjectType(clazz.getClassName())));
            } else {
                Frame._this = null;
                vanillaFrame.getLocals().set(0, (Type)new ObjectType(clazz.getClassName()));
            }
        }
        Type[] argtypes = method.getArgumentTypes();
        int twoslotoffset = 0;
        int j = 0;
        while (j < argtypes.length) {
            if (argtypes[j] == Type.SHORT || argtypes[j] == Type.BYTE || argtypes[j] == Type.CHAR || argtypes[j] == Type.BOOLEAN) {
                argtypes[j] = Type.INT;
            }
            vanillaFrame.getLocals().set(twoslotoffset + j + (method.isStatic() ? 0 : 1), argtypes[j]);
            if (argtypes[j].getSize() == 2) {
                vanillaFrame.getLocals().set(++twoslotoffset + j + (method.isStatic() ? 0 : 1), Type.UNKNOWN);
            }
            ++j;
        }
        icv.setMethodGen(method);
        Vector<InstructionContext> ics = new Vector<InstructionContext>();
        Vector<Object> ecs = new Vector<Object>();
        InstructionContext start = cfg.contextOf(method.getInstructionList().getStart());
        start.execute(vanillaFrame, new ArrayList(), icv, ev);
        ics.add(start);
        ecs.add(new ArrayList());
        while (!ics.isEmpty()) {
            InstructionContext v;
            int s;
            InstructionContext u = (InstructionContext)ics.remove(0);
            ArrayList ec = (ArrayList)ecs.remove(0);
            ArrayList oldchain = (ArrayList)ec.clone();
            ArrayList newchain = (ArrayList)ec.clone();
            newchain.add(u);
            if (u.getInstruction().getInstruction() instanceof RET) {
                RET ret = (RET)u.getInstruction().getInstruction();
                ReturnaddressType t = (ReturnaddressType)u.getOutFrame(oldchain).getLocals().get(ret.getIndex());
                InstructionContext theSuccessor = cfg.contextOf(t.getTarget());
                if (theSuccessor.execute(u.getOutFrame(oldchain), newchain, icv, ev)) {
                    ics.add(theSuccessor);
                    ecs.add(newchain.clone());
                }
            } else {
                InstructionContext[] succs = u.getSuccessors();
                s = 0;
                while (s < succs.length) {
                    v = succs[s];
                    if (v.execute(u.getOutFrame(oldchain), newchain, icv, ev)) {
                        ics.add(v);
                        ecs.add(newchain.clone());
                    }
                    ++s;
                }
            }
            ExceptionHandler[] exc_hds = u.getExceptionHandlers();
            s = 0;
            while (s < exc_hds.length) {
                OperandStack newStack;
                LocalVariables newLocals;
                Frame newFrame;
                v = cfg.contextOf(exc_hds[s].getHandlerStart());
                if (v.execute(newFrame = new Frame(newLocals = u.getOutFrame(oldchain).getLocals(), newStack = new OperandStack(u.getOutFrame(oldchain).getStack().maxStack(), exc_hds[s].getExceptionType() == null ? Type.THROWABLE : exc_hds[s].getExceptionType())), new ArrayList(), icv, ev)) {
                    ics.add(v);
                    ecs.add(new ArrayList());
                }
                ++s;
            }
        }
    }

    private void rewrite(MethodGen method, ControlFlowGraph cfg) throws ClassNotFoundException {
        InstructionFactory insFactory = new InstructionFactory(method.getConstantPool());
        Vector<InstructionHandle> invokeIns = new Vector<InstructionHandle>();
        int count = 0;
        InstructionList insList = method.getInstructionList();
        InstructionHandle ins = insList.getStart();
        InstructionList restorer = new InstructionList();
        while (ins != null) {
            InstructionHandle next = ins.getNext();
            InstructionContext context = null;
            Frame frame = null;
            try {
                context = cfg.contextOf(ins);
                frame = context.getOutFrame(new ArrayList());
            }
            catch (AssertionViolatedException ave) {
                // empty catch block
            }
            if (frame != null) {
                Type[] arguments;
                InvokeInstruction invoke;
                if (this.rewriteable(method, ins)) {
                    invoke = (InvokeInstruction)ins.getInstruction();
                    arguments = invoke.getArgumentTypes(method.getConstantPool());
                    ObjectType objecttype = null;
                    if (!(invoke instanceof INVOKESTATIC)) {
                        objecttype = (ObjectType)context.getInFrame().getStack().peek(arguments.length);
                    }
                    InstructionList rList = this.restoreFrame(method, ins, insFactory, frame, objecttype);
                    insList.append(ins, this.saveFrame(method, ins, count++, insFactory, frame));
                    invokeIns.addElement(rList.getStart());
                    restorer.append(rList);
                }
                if (ins.getInstruction().getOpcode() == 187) {
                    try {
                        while (next != null && next.getInstruction().getOpcode() == 89) {
                            context = cfg.contextOf(next);
                            frame = context.getOutFrame(new ArrayList());
                            InstructionHandle newnext = next.getNext();
                            insList.delete(next);
                            next = newnext;
                        }
                        InstructionTargeter[] targeter = ins.getTargeters();
                        if (targeter != null) {
                            InstructionHandle newnext = ins.getNext();
                            int i = 0;
                            while (i < targeter.length) {
                                targeter[i].updateTarget(ins, newnext);
                                ++i;
                            }
                        }
                        insList.delete(ins);
                    }
                    catch (TargetLostException tle) {
                        throw new ClassNotFoundException(tle.getMessage(), tle);
                    }
                } else if (ins.getInstruction().getOpcode() == 183) {
                    frame = context.getInFrame();
                    invoke = (InvokeInstruction)ins.getInstruction();
                    arguments = invoke.getArgumentTypes(method.getConstantPool());
                    OperandStack os = frame.getStack();
                    Type type = os.peek(arguments.length);
                    if (type instanceof UninitializedObjectType) {
                        ObjectType objecttype = ((UninitializedObjectType)type).getInitialized();
                        InstructionList duplicator = this.duplicateStack(method, invoke, objecttype);
                        InstructionTargeter[] targeter = ins.getTargeters();
                        if (targeter != null) {
                            InstructionHandle newnext = duplicator.getStart();
                            int i = 0;
                            while (i < targeter.length) {
                                targeter[i].updateTarget(ins, newnext);
                                ++i;
                            }
                        }
                        insList.insert(ins, duplicator);
                    }
                }
            }
            ins = next;
        }
        InstructionHandle firstIns = insList.getStart();
        if (count > 0) {
            Object[] tableTargets = new InstructionHandle[count];
            int[] match = new int[count];
            int i = 0;
            while (i < count) {
                match[i] = i;
                ++i;
            }
            invokeIns.copyInto(tableTargets);
            insList.insert(restorer);
            insList.insert((BranchInstruction)new TABLESWITCH(match, (InstructionHandle[])tableTargets, firstIns));
            insList.insert((Instruction)insFactory.createInvoke(STACK_CLASS, this.getPopMethod((Type)Type.INT), (Type)Type.INT, Type.NO_ARGS, (short)182));
            insList.insert((Instruction)InstructionFactory.createLoad((Type)STACK_TYPE, (int)(method.getMaxLocals() + 1)));
            insList.insert((BranchInstruction)new IFEQ(firstIns));
            insList.insert((Instruction)insFactory.createInvoke(CONTINUATION_CLASS, RESTORING_METHOD, (Type)Type.BOOLEAN, Type.NO_ARGS, (short)182));
            insList.insert((Instruction)InstructionFactory.createLoad((Type)CONTINUATION_TYPE, (int)method.getMaxLocals()));
        }
        insList.insert((Instruction)InstructionFactory.createStore((Type)STACK_TYPE, (int)(method.getMaxLocals() + 1)));
        insList.insert((Instruction)insFactory.createInvoke(CONTINUATION_CLASS, STACK_METHOD, (Type)STACK_TYPE, Type.NO_ARGS, (short)182));
        InstructionHandle restore_handle = insList.insert((Instruction)InstructionFactory.createLoad((Type)CONTINUATION_TYPE, (int)method.getMaxLocals()));
        insList.insert((BranchInstruction)new GOTO(firstIns));
        insList.insert((Instruction)InstructionFactory.createStore((Type)STACK_TYPE, (int)(method.getMaxLocals() + 1)));
        insList.insert((Instruction)insFactory.createInvoke(STACK_CLASS, "<init>", (Type)Type.VOID, Type.NO_ARGS, (short)183));
        insList.insert((Instruction)InstructionFactory.createDup((int)STACK_TYPE.getSize()));
        insList.insert((Instruction)insFactory.createNew(STACK_TYPE));
        insList.insert((BranchInstruction)new IFNONNULL(restore_handle));
        insList.insert((Instruction)InstructionFactory.createLoad((Type)CONTINUATION_TYPE, (int)method.getMaxLocals()));
        insList.insert((Instruction)InstructionFactory.createStore((Type)CONTINUATION_TYPE, (int)method.getMaxLocals()));
        insList.insert((Instruction)insFactory.createInvoke(CONTINUATION_CLASS, CONTINUATION_METHOD, (Type)CONTINUATION_TYPE, Type.NO_ARGS, (short)184));
        method.setMaxLocals(method.getMaxLocals() + 2);
        method.setMaxStack(method.getMaxStack() + 2);
    }

    private InstructionList duplicateStack(MethodGen method, InvokeInstruction invoke, ObjectType objecttype) throws ClassNotFoundException {
        InstructionFactory insFactory = new InstructionFactory(method.getConstantPool());
        InstructionList insList = new InstructionList();
        Type[] arguments = invoke.getArgumentTypes(method.getConstantPool());
        int i = arguments.length - 1;
        while (i >= 0) {
            Type type = arguments[i];
            insList.append((Instruction)InstructionFactory.createLoad((Type)STACK_TYPE, (int)(method.getMaxLocals() + 1)));
            insList.append((Instruction)new SWAP());
            if (type instanceof BasicType) {
                if (type.getSize() < 2 && !type.equals(Type.FLOAT)) {
                    type = Type.INT;
                }
                insList.append((Instruction)insFactory.createInvoke(STACK_CLASS, this.getPushMethod(type), (Type)Type.VOID, new Type[]{type}, (short)182));
            } else if (type instanceof ReferenceType) {
                insList.append((Instruction)insFactory.createInvoke(STACK_CLASS, this.getPushMethod((Type)Type.OBJECT), (Type)Type.VOID, new Type[]{Type.OBJECT}, (short)182));
            }
            --i;
        }
        insList.append((Instruction)insFactory.createNew(objecttype));
        insList.append((Instruction)InstructionFactory.createDup((int)objecttype.getSize()));
        int i2 = 0;
        while (i2 < arguments.length) {
            Type type = arguments[i2];
            insList.append((Instruction)InstructionFactory.createLoad((Type)STACK_TYPE, (int)(method.getMaxLocals() + 1)));
            if (type instanceof BasicType) {
                if (type.getSize() < 2 && !type.equals(Type.FLOAT)) {
                    type = Type.INT;
                }
                insList.append((Instruction)insFactory.createInvoke(STACK_CLASS, this.getPopMethod(type), type, Type.NO_ARGS, (short)182));
            } else if (type instanceof ReferenceType) {
                insList.append((Instruction)insFactory.createInvoke(STACK_CLASS, this.getPopMethod((Type)Type.OBJECT), (Type)Type.OBJECT, Type.NO_ARGS, (short)182));
                if (!type.equals(Type.OBJECT)) {
                    insList.append(insFactory.createCast((Type)Type.OBJECT, type));
                }
            }
            ++i2;
        }
        return insList;
    }

    private boolean rewriteable(MethodGen method, InstructionHandle handle) throws ClassNotFoundException {
        short opcode = handle.getInstruction().getOpcode();
        boolean invokeSpecialSuper = false;
        if (opcode == 183) {
            InvokeInstruction ivs = (InvokeInstruction)handle.getInstruction();
            String mName = ivs.getMethodName(method.getConstantPool());
            boolean bl = invokeSpecialSuper = !mName.equals("<init>");
        }
        if (opcode == 182 || opcode == 184 || opcode == 185 || invokeSpecialSuper) {
            int index = ((InvokeInstruction)handle.getInstruction()).getIndex();
            String classname = this.getObjectType(method.getConstantPool().getConstantPool(), index).getClassName();
            return Repository.implementationOf((String)classname, (String)CONTINUABLE_CLASS) || Repository.instanceOf((String)classname, (String)CONTINUATION_CLASS);
        }
        return false;
    }

    private InstructionList saveFrame(MethodGen method, InstructionHandle handle, int pc, InstructionFactory insFactory, Frame frame) {
        InstructionList insList = new InstructionList();
        InvokeInstruction inv = (InvokeInstruction)handle.getInstruction();
        Type returnType = this.getReturnType(method.getConstantPool().getConstantPool(), inv.getIndex());
        if (returnType.getSize() > 0) {
            insList.insert((Instruction)InstructionFactory.createPop((int)returnType.getSize()));
        }
        boolean skipFirst = returnType.getSize() > 0;
        OperandStack os = frame.getStack();
        int i = skipFirst ? 1 : 0;
        while (i < os.size()) {
            Type type = os.peek(i);
            if (type instanceof BasicType) {
                if (type.getSize() < 2 && !type.equals(Type.FLOAT)) {
                    type = Type.INT;
                }
                insList.append((Instruction)InstructionFactory.createLoad((Type)STACK_TYPE, (int)(method.getMaxLocals() + 1)));
                insList.append((Instruction)new SWAP());
                insList.append((Instruction)insFactory.createInvoke(STACK_CLASS, this.getPushMethod(type), (Type)Type.VOID, new Type[]{type}, (short)182));
            } else if (type == null) {
                insList.append((Instruction)InstructionConstants.POP);
            } else if (!(type instanceof UninitializedObjectType) && type instanceof ReferenceType) {
                insList.append((Instruction)InstructionFactory.createLoad((Type)STACK_TYPE, (int)(method.getMaxLocals() + 1)));
                insList.append((Instruction)new SWAP());
                insList.append((Instruction)insFactory.createInvoke(STACK_CLASS, this.getPushMethod((Type)Type.OBJECT), (Type)Type.VOID, new Type[]{Type.OBJECT}, (short)182));
            }
            ++i;
        }
        insList.insert((BranchInstruction)new IFEQ(handle.getNext()));
        insList.insert((Instruction)insFactory.createInvoke(CONTINUATION_CLASS, CAPURING_METHOD, (Type)Type.BOOLEAN, Type.NO_ARGS, (short)182));
        insList.insert((Instruction)InstructionFactory.createLoad((Type)CONTINUATION_TYPE, (int)method.getMaxLocals()));
        insList.insert((BranchInstruction)new IFNULL(handle.getNext()));
        insList.insert((Instruction)InstructionFactory.createLoad((Type)CONTINUATION_TYPE, (int)method.getMaxLocals()));
        LocalVariables lvs = frame.getLocals();
        int i2 = 0;
        while (i2 < lvs.maxLocals()) {
            Type type = lvs.get(i2);
            if (type instanceof BasicType) {
                insList.append((Instruction)InstructionFactory.createLoad((Type)STACK_TYPE, (int)(method.getMaxLocals() + 1)));
                insList.append((Instruction)InstructionFactory.createLoad((Type)type, (int)i2));
                if (type.getSize() < 2 && !type.equals(Type.FLOAT)) {
                    type = Type.INT;
                }
                insList.append((Instruction)insFactory.createInvoke(STACK_CLASS, this.getPushMethod(type), (Type)Type.VOID, new Type[]{type}, (short)182));
            } else if (type != null && !(type instanceof UninitializedObjectType) && type instanceof ReferenceType) {
                if (i2 == 0 && !currentMethodStatic) {
                    insList.append((Instruction)InstructionFactory.createLoad((Type)STACK_TYPE, (int)(method.getMaxLocals() + 1)));
                    insList.append((Instruction)InstructionFactory.createLoad((Type)type, (int)i2));
                    insList.append((Instruction)insFactory.createInvoke(STACK_CLASS, "pushReference", (Type)Type.VOID, new Type[]{Type.OBJECT}, (short)182));
                }
                insList.append((Instruction)InstructionFactory.createLoad((Type)STACK_TYPE, (int)(method.getMaxLocals() + 1)));
                insList.append((Instruction)InstructionFactory.createLoad((Type)type, (int)i2));
                insList.append((Instruction)insFactory.createInvoke(STACK_CLASS, this.getPushMethod((Type)Type.OBJECT), (Type)Type.VOID, new Type[]{Type.OBJECT}, (short)182));
            }
            ++i2;
        }
        insList.append((Instruction)InstructionFactory.createLoad((Type)STACK_TYPE, (int)(method.getMaxLocals() + 1)));
        insList.append((CompoundInstruction)new PUSH(method.getConstantPool(), pc));
        insList.append((Instruction)insFactory.createInvoke(STACK_CLASS, this.getPushMethod((Type)Type.INT), (Type)Type.VOID, new Type[]{Type.INT}, (short)182));
        insList.append(InstructionFactory.createNull((Type)method.getReturnType()));
        insList.append((Instruction)InstructionFactory.createReturn((Type)method.getReturnType()));
        return insList;
    }

    private InstructionList restoreFrame(MethodGen method, InstructionHandle handle, InstructionFactory insFactory, Frame frame, ObjectType objecttype) {
        InstructionList insList = new InstructionList();
        LocalVariables lvs = frame.getLocals();
        int i = lvs.maxLocals() - 1;
        while (i >= 0) {
            Type type = lvs.get(i);
            if (type instanceof BasicType) {
                insList.append((Instruction)InstructionFactory.createLoad((Type)STACK_TYPE, (int)(method.getMaxLocals() + 1)));
                if (type.getSize() < 2 && !type.equals(Type.FLOAT)) {
                    type = Type.INT;
                }
                insList.append((Instruction)insFactory.createInvoke(STACK_CLASS, this.getPopMethod(type), type, Type.NO_ARGS, (short)182));
                insList.append((Instruction)InstructionFactory.createStore((Type)type, (int)i));
            } else if (type == null) {
                insList.append((Instruction)new ACONST_NULL());
                insList.append((Instruction)InstructionFactory.createStore((Type)new ObjectType("<null object>"), (int)i));
            } else if (!(type instanceof UninitializedObjectType) && type instanceof ReferenceType) {
                insList.append((Instruction)InstructionFactory.createLoad((Type)STACK_TYPE, (int)(method.getMaxLocals() + 1)));
                insList.append((Instruction)insFactory.createInvoke(STACK_CLASS, this.getPopMethod((Type)Type.OBJECT), (Type)Type.OBJECT, Type.NO_ARGS, (short)182));
                if (!type.equals(Type.OBJECT) && !type.equals(Type.NULL)) {
                    insList.append(insFactory.createCast((Type)Type.OBJECT, type));
                }
                insList.append((Instruction)InstructionFactory.createStore((Type)type, (int)i));
            }
            --i;
        }
        InvokeInstruction inv = (InvokeInstruction)handle.getInstruction();
        Type returnType = this.getReturnType(method.getConstantPool().getConstantPool(), inv.getIndex());
        boolean skipFirst = returnType.getSize() > 0;
        OperandStack os = frame.getStack();
        int i2 = os.size() - 1;
        while (i2 >= (skipFirst ? 1 : 0)) {
            Type type = os.peek(i2);
            if (type instanceof BasicType) {
                if (type.getSize() < 2 && !type.equals(Type.FLOAT)) {
                    type = Type.INT;
                }
                insList.append((Instruction)InstructionFactory.createLoad((Type)STACK_TYPE, (int)(method.getMaxLocals() + 1)));
                insList.append((Instruction)insFactory.createInvoke(STACK_CLASS, this.getPopMethod(type), type, Type.NO_ARGS, (short)182));
            } else if (type == null) {
                insList.append((Instruction)new ACONST_NULL());
            } else if (!(type instanceof UninitializedObjectType) && type instanceof ReferenceType) {
                insList.append((Instruction)InstructionFactory.createLoad((Type)STACK_TYPE, (int)(method.getMaxLocals() + 1)));
                insList.append((Instruction)insFactory.createInvoke(STACK_CLASS, this.getPopMethod((Type)Type.OBJECT), (Type)Type.OBJECT, Type.NO_ARGS, (short)182));
                if (!type.equals(Type.OBJECT)) {
                    insList.append(insFactory.createCast((Type)Type.OBJECT, type));
                }
            }
            --i2;
        }
        if (!(inv instanceof INVOKESTATIC)) {
            insList.append((Instruction)InstructionFactory.createLoad((Type)STACK_TYPE, (int)(method.getMaxLocals() + 1)));
            insList.append((Instruction)insFactory.createInvoke(STACK_CLASS, "popReference", (Type)Type.OBJECT, Type.NO_ARGS, (short)182));
            insList.append(insFactory.createCast((Type)Type.OBJECT, (Type)objecttype));
        }
        Type[] paramTypes = this.getParamTypes(method.getConstantPool().getConstantPool(), inv.getIndex());
        int j = 0;
        while (j < paramTypes.length) {
            insList.append(InstructionFactory.createNull((Type)paramTypes[j]));
            ++j;
        }
        insList.append((BranchInstruction)new GOTO(handle));
        return insList;
    }

    private ObjectType getObjectType(ConstantPool cp, int index) {
        ConstantCP cmr = (ConstantCP)cp.getConstant(index);
        String sig = cp.getConstantString(cmr.getClassIndex(), (byte)7);
        return new ObjectType(sig.replace('/', '.'));
    }

    private Type[] getParamTypes(ConstantPool cp, int index) {
        ConstantCP cmr = (ConstantCP)cp.getConstant(index);
        ConstantNameAndType cnat = (ConstantNameAndType)cp.getConstant(cmr.getNameAndTypeIndex());
        String sig = ((ConstantUtf8)cp.getConstant(cnat.getSignatureIndex())).getBytes();
        return Type.getArgumentTypes((String)sig);
    }

    private Type getReturnType(ConstantPool cp, int index) {
        ConstantCP cmr = (ConstantCP)cp.getConstant(index);
        ConstantNameAndType cnat = (ConstantNameAndType)cp.getConstant(cmr.getNameAndTypeIndex());
        String sig = ((ConstantUtf8)cp.getConstant(cnat.getSignatureIndex())).getBytes();
        return Type.getReturnType((String)sig);
    }

    private String getPopMethod(Type type) {
        return POP_METHOD + this.getTypeSuffix(type);
    }

    private String getPushMethod(Type type) {
        return PUSH_METHOD + this.getTypeSuffix(type);
    }

    private String getTypeSuffix(Type type) {
        if (type.equals(Type.BOOLEAN)) {
            return "Int";
        }
        if (type.equals(Type.CHAR)) {
            return "Int";
        }
        if (type.equals(Type.FLOAT)) {
            return "Float";
        }
        if (type.equals(Type.DOUBLE)) {
            return "Double";
        }
        if (type.equals(Type.BYTE)) {
            return "Int";
        }
        if (type.equals(Type.SHORT)) {
            return "Int";
        }
        if (type.equals(Type.INT)) {
            return "Int";
        }
        if (type.equals(Type.LONG)) {
            return "Long";
        }
        return "Object";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

