/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.acting;

import java.util.Locale;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.SitemapComponentTestCase;
import org.apache.cocoon.environment.Cookie;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.environment.mock.MockCookie;
import org.apache.cocoon.environment.mock.MockSession;

public class LocaleActionTestCase
extends SitemapComponentTestCase {
    public void testFindLocale() throws Exception {
        Parameters parameters = new Parameters();
        Map result = this.act("locale0", null, parameters);
        LocaleActionTestCase.assertNull((String)"Action should have failed", (Object)result);
        result = this.act("locale1", null, parameters);
        LocaleActionTestCase.assertNotNull((String)"Action should always succeed", (Object)result);
        LocaleActionTestCase.assertEquals((String)"Test for locale", (Object)"en_US", result.get("locale"));
        LocaleActionTestCase.assertEquals((String)"Test for language", (Object)"en", result.get("language"));
        LocaleActionTestCase.assertEquals((String)"Test for country", (Object)"US", result.get("country"));
        LocaleActionTestCase.assertEquals((String)"Test for variant", (Object)"", result.get("variant"));
        result = this.act("locale2", null, parameters);
        LocaleActionTestCase.assertNotNull((String)"Action should always succeed", (Object)result);
        LocaleActionTestCase.assertEquals((String)"Test for locale", (Object)"de_DE_EURO", result.get("locale"));
        LocaleActionTestCase.assertEquals((String)"Test for language", (Object)"de", result.get("language"));
        LocaleActionTestCase.assertEquals((String)"Test for country", (Object)"DE", result.get("country"));
        LocaleActionTestCase.assertEquals((String)"Test for variant", (Object)"EURO", result.get("variant"));
        this.getRequest().setLocale(new Locale("fr", "FR", "MAC"));
        result = this.act("locale3", null, parameters);
        LocaleActionTestCase.assertNotNull((String)"Action should always succeed", (Object)result);
        LocaleActionTestCase.assertEquals((String)"Test for locale", (Object)"fr_FR_MAC", result.get("locale"));
        LocaleActionTestCase.assertEquals((String)"Test for language", (Object)"fr", result.get("language"));
        LocaleActionTestCase.assertEquals((String)"Test for country", (Object)"FR", result.get("country"));
        LocaleActionTestCase.assertEquals((String)"Test for variant", (Object)"MAC", result.get("variant"));
        parameters.setParameter("locale", "zh_CN_WIN");
        result = this.act("locale3", null, parameters);
        LocaleActionTestCase.assertNotNull((String)"Action should always succeed", (Object)result);
        LocaleActionTestCase.assertEquals((String)"Test for locale", (Object)"zh_CN_WIN", result.get("locale"));
        LocaleActionTestCase.assertEquals((String)"Test for language", (Object)"zh", result.get("language"));
        LocaleActionTestCase.assertEquals((String)"Test for country", (Object)"CN", result.get("country"));
        LocaleActionTestCase.assertEquals((String)"Test for variant", (Object)"WIN", result.get("variant"));
        Map cookies = this.getRequest().getCookieMap();
        MockCookie mockCookie = new MockCookie();
        mockCookie.setName("locale");
        mockCookie.setValue("no_NO_B");
        cookies.put("locale", mockCookie);
        result = this.act("locale3", null, parameters);
        LocaleActionTestCase.assertNotNull((String)"Action should always succeed", (Object)result);
        LocaleActionTestCase.assertEquals((String)"Test for locale", (Object)"no_NO_B", result.get("locale"));
        LocaleActionTestCase.assertEquals((String)"Test for language", (Object)"no", result.get("language"));
        LocaleActionTestCase.assertEquals((String)"Test for country", (Object)"NO", result.get("country"));
        LocaleActionTestCase.assertEquals((String)"Test for variant", (Object)"B", result.get("variant"));
        MockSession session = (MockSession)this.getRequest().getSession();
        session.setAttribute("locale", "th_TH_TH");
        result = this.act("locale3", null, parameters);
        LocaleActionTestCase.assertNotNull((String)"Action should always succeed", (Object)result);
        LocaleActionTestCase.assertEquals((String)"Test for locale", (Object)"th_TH_TH", result.get("locale"));
        LocaleActionTestCase.assertEquals((String)"Test for language", (Object)"th", result.get("language"));
        LocaleActionTestCase.assertEquals((String)"Test for country", (Object)"TH", result.get("country"));
        LocaleActionTestCase.assertEquals((String)"Test for variant", (Object)"TH", result.get("variant"));
        this.getRequest().addParameter("locale", "es_MX_POSIX");
        result = this.act("locale3", null, parameters);
        LocaleActionTestCase.assertNotNull((String)"Action should always succeed", (Object)result);
        LocaleActionTestCase.assertEquals((String)"Test for locale", (Object)"es_MX_POSIX", result.get("locale"));
        LocaleActionTestCase.assertEquals((String)"Test for language", (Object)"es", result.get("language"));
        LocaleActionTestCase.assertEquals((String)"Test for country", (Object)"MX", result.get("country"));
        LocaleActionTestCase.assertEquals((String)"Test for variant", (Object)"POSIX", result.get("variant"));
    }

    public void testStoreLocale() throws Exception {
        Parameters parameters = new Parameters();
        Map result = this.act("locale2", null, parameters);
        LocaleActionTestCase.assertNotNull((String)"Action should always succeed", (Object)result);
        LocaleActionTestCase.assertNull((String)"Test for request attribute", (Object)this.getRequest().getAttribute("locale"));
        LocaleActionTestCase.assertNull((String)"Test for session", (Object)this.getRequest().getSession(false));
        LocaleActionTestCase.assertTrue((String)"Test for cookie", (boolean)this.getResponse().getCookies().isEmpty());
        result = this.act("locale4", null, parameters);
        LocaleActionTestCase.assertNotNull((String)"Action should always succeed", (Object)result);
        LocaleActionTestCase.assertEquals((String)"Test for request attribute", (Object)"no_NO_B", (Object)this.getRequest().getAttribute("locale"));
        LocaleActionTestCase.assertNull((String)"Test for session", (Object)this.getRequest().getSession(false));
        LocaleActionTestCase.assertEquals((String)"Test for cookie", (int)1, (int)this.getResponse().getCookies().size());
        Cookie cookie = (Cookie)this.getResponse().getCookies().toArray()[0];
        LocaleActionTestCase.assertEquals((String)"Check cookie name", (String)"locale", (String)cookie.getName());
        LocaleActionTestCase.assertEquals((String)"Check cookie value", (String)"no_NO_B", (String)cookie.getValue());
        this.getRequest().reset();
        this.getRequest().clearSession();
        this.getResponse().reset();
        result = this.act("locale5", null, parameters);
        LocaleActionTestCase.assertNotNull((String)"Action should always succeed", (Object)result);
        LocaleActionTestCase.assertEquals((String)"Test for request attribute", (Object)"en_GB_SCOUSE", (Object)this.getRequest().getAttribute("locale"));
        Session session = this.getRequest().getSession(false);
        LocaleActionTestCase.assertNotNull((String)"Test for session", (Object)session);
        LocaleActionTestCase.assertEquals((String)"Test session attribute", (Object)"en_GB_SCOUSE", (Object)session.getAttribute("locale"));
        LocaleActionTestCase.assertEquals((String)"Test for cookie", (int)1, (int)this.getResponse().getCookies().size());
        cookie = (Cookie)this.getResponse().getCookies().toArray()[0];
        LocaleActionTestCase.assertEquals((String)"Check cookie name", (String)"locale", (String)cookie.getName());
        LocaleActionTestCase.assertEquals((String)"Check cookie value", (String)"en_GB_SCOUSE", (String)cookie.getValue());
        this.getRequest().reset();
        this.getRequest().clearSession();
        this.getResponse().reset();
        session = this.getRequest().getSession(true);
        result = this.act("locale4", null, parameters);
        LocaleActionTestCase.assertNotNull((String)"Action should always succeed", (Object)result);
        LocaleActionTestCase.assertEquals((String)"Test for request attribute", (Object)"no_NO_B", (Object)this.getRequest().getAttribute("locale"));
        session = this.getRequest().getSession(false);
        LocaleActionTestCase.assertNotNull((String)"Test for session", (Object)session);
        LocaleActionTestCase.assertEquals((String)"Test session attribute", (Object)"no_NO_B", (Object)session.getAttribute("locale"));
        LocaleActionTestCase.assertEquals((String)"Test for cookie", (int)1, (int)this.getResponse().getCookies().size());
        cookie = (Cookie)this.getResponse().getCookies().toArray()[0];
        LocaleActionTestCase.assertEquals((String)"Check cookie name", (String)"locale", (String)cookie.getName());
        LocaleActionTestCase.assertEquals((String)"Check cookie value", (String)"no_NO_B", (String)cookie.getValue());
    }
}

