/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.sax;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.cocoon.components.sax.XMLByteStreamCompiler;
import org.apache.cocoon.components.sax.XMLByteStreamInterpreter;
import org.apache.cocoon.xml.AbstractXMLTestCase;
import org.apache.cocoon.xml.DefaultHandlerWrapper;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.dom.DOMBuilder;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.DefaultHandler;

public final class XMLByteStreamCompilerInterpreterTestCase
extends AbstractXMLTestCase {
    public XMLByteStreamCompilerInterpreterTestCase(String s) {
        super(s);
    }

    public void testCompareDOM() throws Exception {
        DOMBuilder in = new DOMBuilder();
        this.generateLargeSAX((ContentHandler)in);
        XMLByteStreamCompiler xmlc = new XMLByteStreamCompiler();
        this.generateLargeSAX((ContentHandler)xmlc);
        XMLByteStreamInterpreter xmli = new XMLByteStreamInterpreter();
        DOMBuilder out = new DOMBuilder();
        xmli.setConsumer((XMLConsumer)out);
        xmli.deserialize(xmlc.getSAXFragment());
        this.assertXMLEqual(in.getDocument(), out.getDocument());
    }

    public void testCompareByteArray() throws Exception {
        XMLByteStreamCompiler sa = new XMLByteStreamCompiler();
        this.generateLargeSAX((ContentHandler)sa);
        byte[] aa = (byte[])sa.getSAXFragment();
        XMLByteStreamCompiler sb = new XMLByteStreamCompiler();
        XMLByteStreamInterpreter xmli = new XMLByteStreamInterpreter();
        xmli.setConsumer((XMLConsumer)sb);
        xmli.deserialize((Object)aa);
        byte[] ab = (byte[])sb.getSAXFragment();
        XMLByteStreamCompilerInterpreterTestCase.assertTrue((aa.length == ab.length ? 1 : 0) != 0);
        for (int i = 0; i < aa.length; ++i) {
            XMLByteStreamCompilerInterpreterTestCase.assertEquals((byte)aa[i], (byte)ab[i]);
        }
    }

    public void testStressLoop() throws Exception {
        XMLByteStreamCompiler xmlc = new XMLByteStreamCompiler();
        long loop = 10000L;
        long start = System.currentTimeMillis();
        int i = 0;
        while ((long)i < loop) {
            this.generateSmallSAX((ContentHandler)xmlc);
            xmlc.recycle();
            ++i;
        }
        long stop = System.currentTimeMillis();
        double r = 1000L * loop / (stop - start);
        System.out.println("consuming: " + r + " documents per second");
    }

    public void testCompareToParsing() throws Exception {
        DOMBuilder in = new DOMBuilder();
        this.generateSmallSAX((ContentHandler)in);
        SAXParserFactory pfactory = SAXParserFactory.newInstance();
        SAXParser p = pfactory.newSAXParser();
        XMLByteStreamCompiler xmlc = new XMLByteStreamCompiler();
        DefaultHandlerWrapper wrapper = new DefaultHandlerWrapper((ContentHandler)xmlc);
        ByteArrayInputStream bis = new ByteArrayInputStream(this.generateByteArray());
        long loop = 10000L;
        long start = System.currentTimeMillis();
        int i = 0;
        while ((long)i < loop) {
            xmlc.recycle();
            bis.reset();
            p.parse((InputStream)bis, (DefaultHandler)wrapper);
            ++i;
        }
        long stop = System.currentTimeMillis();
        double r = 1000L * loop / (stop - start);
        System.out.println("parsed: " + r + " documents per second");
        XMLByteStreamInterpreter xmli = new XMLByteStreamInterpreter();
        DefaultHandler ch = new DefaultHandler();
        start = System.currentTimeMillis();
        int i2 = 0;
        while ((long)i2 < loop) {
            xmli.setContentHandler((ContentHandler)ch);
            xmli.deserialize(xmlc.getSAXFragment());
            ++i2;
        }
        stop = System.currentTimeMillis();
        r = 1000L * loop / (stop - start);
        System.out.println("recalling: " + r + " documents per second");
    }
}

