/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.cocoon.components.source.impl.ZipSource;
import org.apache.cocoon.core.container.ContainerTestCase;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceResolver;

public class ZipSourceTestCase
extends ContainerTestCase {
    public void testURIHandling() throws Exception {
        Source zipSource;
        String zipFilePath = "/test.zip";
        String filePath = "test.xml";
        String zipSourceUri = "zip:file://test.zip!/test.xml";
        SourceResolver resolver = null;
        try {
            resolver = (SourceResolver)this.getManager().lookup(SourceResolver.ROLE);
            zipSource = resolver.resolveURI("zip:file://test.zip!/test.xml");
        }
        catch (ServiceException se) {
            throw new SourceException("SourceResolver is not available.", (Throwable)se);
        }
        finally {
            this.getManager().release((Object)resolver);
        }
        ZipSourceTestCase.assertTrue((String)"Resolved Source is not an instance of ZipSource.", (boolean)(zipSource instanceof ZipSource));
        ZipSourceTestCase.assertEquals((String)"Scheme/protocol is wrong.", (String)"zip", (String)zipSource.getScheme());
        int index = zipSource.getURI().lastIndexOf(58);
        String testFilePath = zipSource.getURI().substring(index + 2);
        while (testFilePath.startsWith("/")) {
            testFilePath = testFilePath.substring(1);
        }
        testFilePath = "/" + testFilePath;
        ZipSourceTestCase.assertEquals((String)"Uri is wrong.", (String)"zip:file://test.zip!/test.xml", (String)(zipSource.getURI().substring(0, index + 2) + testFilePath));
    }
}

