/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.thread;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.easymock.MockControl;

public class AbstractTestCase
extends TestCase {
    private List m_controls;

    public AbstractTestCase(String name) {
        super(name);
    }

    public AbstractTestCase() {
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_controls = new ArrayList();
    }

    protected Configuration createBooleanConfigMock(boolean value, boolean defaultValue) {
        MockControl valueConfigControl = this.createStrictControl(Configuration.class);
        Configuration valueConfig = (Configuration)valueConfigControl.getMock();
        valueConfig.getValueAsBoolean(defaultValue);
        valueConfigControl.setReturnValue(value);
        valueConfigControl.replay();
        return valueConfig;
    }

    protected Configuration createBooleanConfigMock(boolean value) throws ConfigurationException {
        MockControl valueConfigControl = this.createStrictControl(Configuration.class);
        Configuration valueConfig = (Configuration)valueConfigControl.getMock();
        valueConfig.getValueAsBoolean();
        valueConfigControl.setReturnValue(value);
        valueConfigControl.replay();
        return valueConfig;
    }

    protected Configuration createChildConfigMock(String name, Configuration value) {
        MockControl childConfigControl = this.createStrictControl(Configuration.class);
        Configuration childConfig = (Configuration)childConfigControl.getMock();
        childConfig.getChild(name);
        childConfigControl.setReturnValue((Object)value);
        childConfigControl.replay();
        return childConfig;
    }

    protected Configuration createChildrenConfigMock(String name, Configuration[] value) {
        MockControl childrenConfigControl = this.createStrictControl(Configuration.class);
        Configuration childrenConfig = (Configuration)childrenConfigControl.getMock();
        childrenConfig.getChildren(name);
        childrenConfigControl.setReturnValue((Object)value);
        childrenConfigControl.replay();
        return childrenConfig;
    }

    protected Configuration createIntegerConfigMock(int value, int defaultValue) {
        MockControl valueConfigControl = this.createStrictControl(Configuration.class);
        Configuration valueConfig = (Configuration)valueConfigControl.getMock();
        valueConfig.getValueAsInteger(defaultValue);
        valueConfigControl.setReturnValue((long)value);
        valueConfigControl.replay();
        return valueConfig;
    }

    protected Configuration createIntegerConfigMock(int value) throws ConfigurationException {
        MockControl valueConfigControl = this.createStrictControl(Configuration.class);
        Configuration valueConfig = (Configuration)valueConfigControl.getMock();
        valueConfig.getValueAsInteger();
        valueConfigControl.setReturnValue((long)value);
        valueConfigControl.replay();
        return valueConfig;
    }

    protected Configuration createLongConfigMock(long value, long defaultValue) {
        MockControl valueConfigControl = this.createStrictControl(Configuration.class);
        Configuration valueConfig = (Configuration)valueConfigControl.getMock();
        valueConfig.getValueAsLong(defaultValue);
        valueConfigControl.setReturnValue(value);
        valueConfigControl.replay();
        return valueConfig;
    }

    protected Configuration createLongConfigMock(long value) throws ConfigurationException {
        MockControl valueConfigControl = this.createStrictControl(Configuration.class);
        Configuration valueConfig = (Configuration)valueConfigControl.getMock();
        valueConfig.getValueAsLong();
        valueConfigControl.setReturnValue(value);
        valueConfigControl.replay();
        return valueConfig;
    }

    protected MockControl createStrictControl(Class clazz) {
        MockControl control = MockControl.createStrictControl((Class)clazz);
        this.m_controls.add(control);
        return control;
    }

    protected Configuration createValueConfigMock(String value, String defaultValue) {
        MockControl valueConfigControl = this.createStrictControl(Configuration.class);
        Configuration valueConfig = (Configuration)valueConfigControl.getMock();
        valueConfig.getValue(defaultValue);
        valueConfigControl.setReturnValue((Object)value);
        valueConfigControl.replay();
        return valueConfig;
    }

    protected Configuration createValueConfigMock(String value) throws ConfigurationException {
        MockControl valueConfigControl = this.createStrictControl(Configuration.class);
        Configuration valueConfig = (Configuration)valueConfigControl.getMock();
        valueConfig.getValue();
        valueConfigControl.setReturnValue((Object)value);
        valueConfigControl.replay();
        return valueConfig;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.m_controls = null;
    }

    protected void verify() {
        Iterator i = this.m_controls.iterator();
        while (i.hasNext()) {
            MockControl control = (MockControl)i.next();
            control.verify();
        }
    }
}

