/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.thread;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.components.thread.AbstractTestCase;
import org.apache.cocoon.components.thread.DefaultRunnableManager;
import org.apache.cocoon.components.thread.ThreadPool;
import org.easymock.MockControl;

public class DefaultRunnableManagerTestCase
extends AbstractTestCase {
    public DefaultRunnableManagerTestCase(String name) {
        super(name);
    }

    public final void testConfigureDaemonPool() throws Exception {
        MockControl threadPoolConfigControl = this.createStrictControl(Configuration.class);
        Configuration threadPoolConfig = (Configuration)threadPoolConfigControl.getMock();
        threadPoolConfigControl.expectAndReturn((Object)threadPoolConfig.getChild("name"), (Object)this.createValueConfigMock("daemon"));
        threadPoolConfigControl.expectAndReturn((Object)threadPoolConfig.getChild("queue-size"), (Object)this.createIntegerConfigMock(-2, -1));
        threadPoolConfigControl.expectAndReturn((Object)threadPoolConfig.getChild("max-pool-size"), (Object)this.createIntegerConfigMock(10, 5));
        threadPoolConfigControl.expectAndReturn((Object)threadPoolConfig.getChild("min-pool-size"), (Object)this.createIntegerConfigMock(1, 5));
        threadPoolConfigControl.expectAndReturn((Object)threadPoolConfig.getChild("priority"), (Object)this.createValueConfigMock("LOW", "NORM"));
        threadPoolConfigControl.expectAndReturn((Object)threadPoolConfig.getChild("daemon"), (Object)this.createBooleanConfigMock(false, false));
        threadPoolConfigControl.expectAndReturn((Object)threadPoolConfig.getChild("keep-alive-time-ms"), (Object)this.createLongConfigMock(30000L, 60000L));
        threadPoolConfigControl.expectAndReturn((Object)threadPoolConfig.getChild("block-policy"), (Object)this.createValueConfigMock("WAIT", "RUN"));
        threadPoolConfigControl.expectAndReturn((Object)threadPoolConfig.getChild("shutdown-graceful"), (Object)this.createBooleanConfigMock(true, false));
        threadPoolConfigControl.expectAndReturn((Object)threadPoolConfig.getChild("shutdown-wait-time-ms"), (Object)this.createIntegerConfigMock(0, -1));
        threadPoolConfigControl.replay();
        MockControl mainConfigControl = this.createStrictControl(Configuration.class);
        Configuration mainConfig = (Configuration)mainConfigControl.getMock();
        mainConfigControl.expectAndReturn((Object)mainConfig.getChild("thread-factory"), (Object)this.createValueConfigMock(DefaultRunnableManager.DEFAULT_THREAD_FACTORY, DefaultRunnableManager.DEFAULT_THREAD_FACTORY));
        mainConfigControl.expectAndReturn((Object)mainConfig.getChild("thread-pools"), (Object)this.createChildrenConfigMock("thread-pool", new Configuration[]{threadPoolConfig}));
        mainConfigControl.replay();
        MockControl childLoggerDaemonControl = this.createStrictControl(Logger.class);
        Logger childLoggerDaemon = (Logger)childLoggerDaemonControl.getMock();
        childLoggerDaemonControl.replay();
        MockControl childLoggerDefaultControl = this.createStrictControl(Logger.class);
        Logger childLoggerDefault = (Logger)childLoggerDefaultControl.getMock();
        childLoggerDefaultControl.replay();
        MockControl loggerControl = this.createStrictControl(Logger.class);
        Logger logger = (Logger)loggerControl.getMock();
        logger.warn("Unknown thread priority \"LOW\". Set to \"NORM\".");
        loggerControl.expectAndReturn((Object)logger.getChildLogger("daemon"), (Object)childLoggerDaemon);
        loggerControl.expectAndReturn(logger.isInfoEnabled(), true);
        logger.info("ThreadPool named \"daemon\" created with maximum queue-size=2147483647,max-pool-size=10,min-pool-size=1,priority=5,isDaemon=false,keep-alive-time-ms=30000,block-policy=\"WAIT\",shutdown-wait-time-ms=0");
        loggerControl.expectAndReturn((Object)logger.getChildLogger("default"), (Object)childLoggerDefault);
        loggerControl.expectAndReturn(logger.isInfoEnabled(), true);
        logger.info("ThreadPool named \"default\" created with maximum queue-size=2147483647,max-pool-size=5,min-pool-size=5,priority=5,isDaemon=false,keep-alive-time-ms=60000,block-policy=\"RUN\",shutdown-wait-time-ms=-1");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Disposing all thread pools");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Disposing thread pool daemon");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Thread pool daemon disposed");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Disposing thread pool default");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Thread pool default disposed");
        loggerControl.replay();
        DefaultRunnableManager runnableManager = new DefaultRunnableManager();
        runnableManager.enableLogging(logger);
        try {
            runnableManager.configure(mainConfig);
        }
        catch (ConfigurationException ce) {
            DefaultRunnableManagerTestCase.assertTrue((String)"Throw unexpected ConfigurationException", (boolean)false);
        }
        runnableManager.dispose();
        this.verify();
    }

    public final void testConfigureMinimal() {
        MockControl mainConfigControl = this.createStrictControl(Configuration.class);
        Configuration mainConfig = (Configuration)mainConfigControl.getMock();
        mainConfigControl.expectAndReturn((Object)mainConfig.getChild("thread-factory"), (Object)this.createValueConfigMock(DefaultRunnableManager.DEFAULT_THREAD_FACTORY, DefaultRunnableManager.DEFAULT_THREAD_FACTORY));
        mainConfigControl.expectAndReturn((Object)mainConfig.getChild("thread-pools"), (Object)this.createChildrenConfigMock("thread-pool", new Configuration[0]));
        mainConfigControl.replay();
        MockControl childLoggerDefaultControl = this.createStrictControl(Logger.class);
        Logger childLoggerDefault = (Logger)childLoggerDefaultControl.getMock();
        childLoggerDefaultControl.replay();
        MockControl loggerControl = this.createStrictControl(Logger.class);
        Logger logger = (Logger)loggerControl.getMock();
        loggerControl.expectAndReturn((Object)logger.getChildLogger("default"), (Object)childLoggerDefault);
        loggerControl.expectAndReturn(logger.isInfoEnabled(), true);
        logger.info("ThreadPool named \"default\" created with maximum queue-size=2147483647,max-pool-size=5,min-pool-size=5,priority=5,isDaemon=false,keep-alive-time-ms=60000,block-policy=\"RUN\",shutdown-wait-time-ms=-1");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Disposing all thread pools");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Disposing thread pool default");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Thread pool default disposed");
        loggerControl.replay();
        DefaultRunnableManager runnableManager = new DefaultRunnableManager();
        runnableManager.enableLogging(logger);
        try {
            runnableManager.configure(mainConfig);
        }
        catch (ConfigurationException ce) {
            DefaultRunnableManagerTestCase.assertTrue((String)"Throw unexpected ConfigurationException", (boolean)false);
        }
        runnableManager.dispose();
        this.verify();
    }

    public final void testConfigureMyPool() throws Exception {
        MockControl threadPoolConfigControl = this.createStrictControl(Configuration.class);
        Configuration threadPoolConfig = (Configuration)threadPoolConfigControl.getMock();
        threadPoolConfigControl.expectAndReturn((Object)threadPoolConfig.getChild("name"), (Object)this.createValueConfigMock("mypool"));
        threadPoolConfigControl.expectAndReturn((Object)threadPoolConfig.getChild("queue-size"), (Object)this.createIntegerConfigMock(-2, -1));
        threadPoolConfigControl.expectAndReturn((Object)threadPoolConfig.getChild("max-pool-size"), (Object)this.createIntegerConfigMock(10, 5));
        threadPoolConfigControl.expectAndReturn((Object)threadPoolConfig.getChild("min-pool-size"), (Object)this.createIntegerConfigMock(1, 5));
        threadPoolConfigControl.expectAndReturn((Object)threadPoolConfig.getChild("priority"), (Object)this.createValueConfigMock("MIN", "NORM"));
        threadPoolConfigControl.expectAndReturn((Object)threadPoolConfig.getChild("daemon"), (Object)this.createBooleanConfigMock(false, false));
        threadPoolConfigControl.expectAndReturn((Object)threadPoolConfig.getChild("keep-alive-time-ms"), (Object)this.createLongConfigMock(30000L, 60000L));
        threadPoolConfigControl.expectAndReturn((Object)threadPoolConfig.getChild("block-policy"), (Object)this.createValueConfigMock("WAIT", "RUN"));
        threadPoolConfigControl.expectAndReturn((Object)threadPoolConfig.getChild("shutdown-graceful"), (Object)this.createBooleanConfigMock(true, false));
        threadPoolConfigControl.expectAndReturn((Object)threadPoolConfig.getChild("shutdown-wait-time-ms"), (Object)this.createIntegerConfigMock(0, -1));
        threadPoolConfigControl.replay();
        MockControl mainConfigControl = this.createStrictControl(Configuration.class);
        Configuration mainConfig = (Configuration)mainConfigControl.getMock();
        mainConfigControl.expectAndReturn((Object)mainConfig.getChild("thread-factory"), (Object)this.createValueConfigMock(DefaultRunnableManager.DEFAULT_THREAD_FACTORY, DefaultRunnableManager.DEFAULT_THREAD_FACTORY));
        mainConfigControl.expectAndReturn((Object)mainConfig.getChild("thread-pools"), (Object)this.createChildrenConfigMock("thread-pool", new Configuration[]{threadPoolConfig}));
        mainConfigControl.replay();
        MockControl childLoggerDefaultControl = this.createStrictControl(Logger.class);
        Logger childLoggerDefault = (Logger)childLoggerDefaultControl.getMock();
        childLoggerDefaultControl.replay();
        MockControl childLoggerMyPoolControl = this.createStrictControl(Logger.class);
        Logger childLoggerMyPool = (Logger)childLoggerMyPoolControl.getMock();
        childLoggerMyPoolControl.replay();
        MockControl loggerControl = this.createStrictControl(Logger.class);
        Logger logger = (Logger)loggerControl.getMock();
        loggerControl.expectAndReturn((Object)logger.getChildLogger("mypool"), (Object)childLoggerMyPool);
        loggerControl.expectAndReturn(logger.isInfoEnabled(), true);
        logger.info("ThreadPool named \"mypool\" created with maximum queue-size=2147483647,max-pool-size=10,min-pool-size=1,priority=1,isDaemon=false,keep-alive-time-ms=30000,block-policy=\"WAIT\",shutdown-wait-time-ms=0");
        loggerControl.expectAndReturn((Object)logger.getChildLogger("default"), (Object)childLoggerDefault);
        loggerControl.expectAndReturn(logger.isInfoEnabled(), true);
        logger.info("ThreadPool named \"default\" created with maximum queue-size=2147483647,max-pool-size=5,min-pool-size=5,priority=5,isDaemon=false,keep-alive-time-ms=60000,block-policy=\"RUN\",shutdown-wait-time-ms=-1");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Disposing all thread pools");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Disposing thread pool mypool");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Thread pool mypool disposed");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Disposing thread pool default");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Thread pool default disposed");
        loggerControl.replay();
        DefaultRunnableManager runnableManager = new DefaultRunnableManager();
        runnableManager.enableLogging(logger);
        try {
            runnableManager.configure(mainConfig);
        }
        catch (ConfigurationException ce) {
            DefaultRunnableManagerTestCase.assertTrue((String)"Throw unexpected ConfigurationException", (boolean)false);
        }
        runnableManager.dispose();
        this.verify();
    }

    public final void testCreatePoolStringintintintintbooleanlongStringbooleanint() {
        MockControl mainConfigControl = this.createStrictControl(Configuration.class);
        Configuration mainConfig = (Configuration)mainConfigControl.getMock();
        mainConfigControl.expectAndReturn((Object)mainConfig.getChild("thread-factory"), (Object)this.createValueConfigMock(DefaultRunnableManager.DEFAULT_THREAD_FACTORY, DefaultRunnableManager.DEFAULT_THREAD_FACTORY));
        mainConfigControl.expectAndReturn((Object)mainConfig.getChild("thread-pools"), (Object)this.createChildrenConfigMock("thread-pool", new Configuration[0]));
        mainConfigControl.replay();
        MockControl childLoggerDefaultControl = this.createStrictControl(Logger.class);
        Logger childLoggerDefault = (Logger)childLoggerDefaultControl.getMock();
        childLoggerDefaultControl.replay();
        MockControl childLoggerMyPoolControl = this.createStrictControl(Logger.class);
        Logger childLoggerMyPool = (Logger)childLoggerMyPoolControl.getMock();
        childLoggerMyPoolControl.replay();
        MockControl loggerControl = this.createStrictControl(Logger.class);
        Logger logger = (Logger)loggerControl.getMock();
        loggerControl.expectAndReturn((Object)logger.getChildLogger("default"), (Object)childLoggerDefault);
        loggerControl.expectAndReturn(logger.isInfoEnabled(), true);
        logger.info("ThreadPool named \"default\" created with maximum queue-size=2147483647,max-pool-size=5,min-pool-size=5,priority=5,isDaemon=false,keep-alive-time-ms=60000,block-policy=\"RUN\",shutdown-wait-time-ms=-1");
        loggerControl.expectAndReturn((Object)logger.getChildLogger("mypool"), (Object)childLoggerMyPool);
        loggerControl.expectAndReturn(logger.isInfoEnabled(), true);
        logger.info("ThreadPool named \"mypool\" created with maximum queue-size=230,max-pool-size=15,min-pool-size=12,priority=1,isDaemon=false,keep-alive-time-ms=15500,block-policy=\"DISCARD\",shutdown-wait-time-ms=22200");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Disposing all thread pools");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Disposing thread pool mypool");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Thread pool mypool disposed");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Disposing thread pool default");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Thread pool default disposed");
        loggerControl.replay();
        DefaultRunnableManager runnableManager = new DefaultRunnableManager();
        runnableManager.enableLogging(logger);
        try {
            runnableManager.configure(mainConfig);
        }
        catch (ConfigurationException ce) {
            DefaultRunnableManagerTestCase.assertTrue((String)"Throw unexpected ConfigurationException", (boolean)false);
        }
        runnableManager.createPool("mypool", 230, 15, 12, 1, false, 15500L, "DISCARD", false, 22200);
        runnableManager.dispose();
        this.verify();
    }

    public final void testCreatePoolintintintintbooleanlongStringbooleanint() {
        MockControl mainConfigControl = this.createStrictControl(Configuration.class);
        Configuration mainConfig = (Configuration)mainConfigControl.getMock();
        mainConfigControl.expectAndReturn((Object)mainConfig.getChild("thread-factory"), (Object)this.createValueConfigMock(DefaultRunnableManager.DEFAULT_THREAD_FACTORY, DefaultRunnableManager.DEFAULT_THREAD_FACTORY));
        mainConfigControl.expectAndReturn((Object)mainConfig.getChild("thread-pools"), (Object)this.createChildrenConfigMock("thread-pool", new Configuration[0]));
        mainConfigControl.replay();
        MockControl childLoggerDefaultControl = this.createStrictControl(Logger.class);
        Logger childLoggerDefault = (Logger)childLoggerDefaultControl.getMock();
        childLoggerDefaultControl.replay();
        MockControl childLoggerAnonControl = this.createStrictControl(Logger.class);
        Logger childLoggerAnon = (Logger)childLoggerAnonControl.getMock();
        childLoggerAnonControl.replay();
        MockControl loggerControl = this.createStrictControl(Logger.class);
        Logger logger = (Logger)loggerControl.getMock();
        loggerControl.expectAndReturn((Object)logger.getChildLogger("default"), (Object)childLoggerDefault);
        loggerControl.expectAndReturn(logger.isInfoEnabled(), true);
        logger.info("ThreadPool named \"default\" created with maximum queue-size=2147483647,max-pool-size=5,min-pool-size=5,priority=5,isDaemon=false,keep-alive-time-ms=60000,block-policy=\"RUN\",shutdown-wait-time-ms=-1");
        loggerControl.expectAndReturn((Object)logger.getChildLogger("anon-xxx"), (Object)childLoggerAnon);
        loggerControl.setMatcher(MockControl.ALWAYS_MATCHER);
        loggerControl.expectAndReturn(logger.isInfoEnabled(), true);
        logger.info("ThreadPool named \"anon-xxx\" created with maximum queue-size=2147483647,max-pool-size=5,min-pool-size=5,priority=10,isDaemon=false,keep-alive-time-ms=60000,block-policy=\"RUN\",shutdown-wait-time-ms=-1");
        loggerControl.setMatcher(MockControl.ALWAYS_MATCHER);
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Disposing all thread pools");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Disposing thread pool anon-xxx");
        loggerControl.setMatcher(MockControl.ALWAYS_MATCHER);
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Thread pool anon-xxx disposed");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Disposing thread pool default");
        loggerControl.setMatcher(MockControl.ALWAYS_MATCHER);
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Thread pool default disposed");
        loggerControl.replay();
        DefaultRunnableManager runnableManager = new DefaultRunnableManager();
        runnableManager.enableLogging(logger);
        try {
            runnableManager.configure(mainConfig);
        }
        catch (ConfigurationException ce) {
            DefaultRunnableManagerTestCase.assertTrue((String)"Throw unexpected ConfigurationException", (boolean)false);
        }
        ThreadPool threadPool = runnableManager.createPool(200, 5, 2, 10, true, 15000L, "ABORT", true, 22000);
        DefaultRunnableManagerTestCase.assertEquals((String)"queue-size", (int)200, (int)threadPool.getMaximumQueueSize());
        DefaultRunnableManagerTestCase.assertEquals((String)"max-pool-size", (int)5, (int)threadPool.getMaximumPoolSize());
        DefaultRunnableManagerTestCase.assertEquals((String)"min-pool-size", (int)2, (int)threadPool.getMinimumPoolSize());
        DefaultRunnableManagerTestCase.assertEquals((String)"priority", (int)10, (int)threadPool.getPriority());
        DefaultRunnableManagerTestCase.assertEquals((String)"keep-alive-time-ms", (long)15000L, (long)threadPool.getKeepAliveTime());
        DefaultRunnableManagerTestCase.assertEquals((String)"block-policy", (String)"ABORT", (String)threadPool.getBlockPolicy());
        runnableManager.dispose();
        this.verify();
    }

    public final void testExecuteRunnable() {
        MockControl mainConfigControl = this.createStrictControl(Configuration.class);
        Configuration mainConfig = (Configuration)mainConfigControl.getMock();
        mainConfigControl.expectAndReturn((Object)mainConfig.getChild("thread-factory"), (Object)this.createValueConfigMock(DefaultRunnableManager.DEFAULT_THREAD_FACTORY, DefaultRunnableManager.DEFAULT_THREAD_FACTORY));
        mainConfigControl.expectAndReturn((Object)mainConfig.getChild("thread-pools"), (Object)this.createChildrenConfigMock("thread-pool", new Configuration[0]));
        mainConfigControl.replay();
        MockControl childLoggerControl = this.createStrictControl(Logger.class);
        Logger childLogger = (Logger)childLoggerControl.getMock();
        childLoggerControl.expectAndReturn(childLogger.isDebugEnabled(), true);
        childLogger.debug("Executing Command: org.apache.cocoon.components.thread.DefaultRunnableManager");
        childLoggerControl.setMatcher(MockControl.ALWAYS_MATCHER);
        childLoggerControl.expectAndReturn(childLogger.isDebugEnabled(), true);
        childLogger.debug("Executing Command: org.apache.cocoon.components.thread.DefaultRunnableManager");
        childLoggerControl.replay();
        MockControl loggerControl = this.createStrictControl(Logger.class);
        Logger logger = (Logger)loggerControl.getMock();
        loggerControl.expectAndReturn((Object)logger.getChildLogger("default"), (Object)childLogger);
        loggerControl.expectAndReturn(logger.isInfoEnabled(), true);
        logger.info("ThreadPool named \"default\" created with maximum queue-size=2147483647,max-pool-size=5,min-pool-size=5,priority=5,isDaemon=false,keep-alive-time-ms=60000,block-policy=\"RUN\",shutdown-wait-time-ms=-1");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Starting the heart");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Entering loop");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("No commands available. Will just wait for one");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Command entered: EasyMock for interface java.lang.Runnable, pool=default, delay=0, interval=0");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Executing command EasyMock for interface java.lang.Runnable in pool \"default\", schedule with interval=0");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("No commands available. Will just wait for one");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Exiting loop");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Disposing all thread pools");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Disposing thread pool default");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Thread pool default disposed");
        loggerControl.replay();
        DefaultRunnableManager runnableManager = new DefaultRunnableManager();
        runnableManager.enableLogging(logger);
        try {
            runnableManager.configure(mainConfig);
        }
        catch (ConfigurationException ce) {
            DefaultRunnableManagerTestCase.assertTrue((String)"Throw unexpected ConfigurationException", (boolean)false);
        }
        MockControl runnableControl = this.createStrictControl(Runnable.class);
        Runnable runnable = (Runnable)runnableControl.getMock();
        runnable.run();
        runnableControl.replay();
        try {
            runnableManager.start();
            Thread.yield();
            Thread.sleep(20L);
            runnableManager.execute(runnable);
            Thread.yield();
            Thread.sleep(20L);
            runnableManager.stop();
            Thread.yield();
            Thread.sleep(20L);
            runnableManager.dispose();
            Thread.sleep(20L);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            DefaultRunnableManagerTestCase.assertTrue((String)"Unexpected Exception", (boolean)false);
        }
        this.verify();
    }

    public final void testExecuteRunnablelong() {
        MockControl mainConfigControl = this.createStrictControl(Configuration.class);
        Configuration mainConfig = (Configuration)mainConfigControl.getMock();
        mainConfigControl.expectAndReturn((Object)mainConfig.getChild("thread-factory"), (Object)this.createValueConfigMock(DefaultRunnableManager.DEFAULT_THREAD_FACTORY, DefaultRunnableManager.DEFAULT_THREAD_FACTORY));
        mainConfigControl.expectAndReturn((Object)mainConfig.getChild("thread-pools"), (Object)this.createChildrenConfigMock("thread-pool", new Configuration[0]));
        mainConfigControl.replay();
        MockControl childLoggerControl = this.createStrictControl(Logger.class);
        Logger childLogger = (Logger)childLoggerControl.getMock();
        childLoggerControl.expectAndReturn(childLogger.isDebugEnabled(), true);
        childLogger.debug("Executing Command: org.apache.cocoon.components.thread.DefaultRunnableManager");
        childLoggerControl.setMatcher(MockControl.ALWAYS_MATCHER);
        childLoggerControl.expectAndReturn(childLogger.isDebugEnabled(), true);
        childLogger.debug("Executing Command: org.apache.cocoon.components.thread.DefaultRunnableManager");
        childLoggerControl.replay();
        MockControl loggerControl = this.createStrictControl(Logger.class);
        Logger logger = (Logger)loggerControl.getMock();
        loggerControl.expectAndReturn((Object)logger.getChildLogger("default"), (Object)childLogger);
        loggerControl.expectAndReturn(logger.isInfoEnabled(), true);
        logger.info("ThreadPool named \"default\" created with maximum queue-size=2147483647,max-pool-size=5,min-pool-size=5,priority=5,isDaemon=false,keep-alive-time-ms=60000,block-policy=\"RUN\",shutdown-wait-time-ms=-1");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Starting the heart");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Entering loop");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("No commands available. Will just wait for one");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Command entered: EasyMock for interface java.lang.Runnable, pool=default, delay=100, interval=0");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Executing command EasyMock for interface java.lang.Runnable in pool \"default\", schedule with interval=0");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("No commands available. Will just wait for one");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Exiting loop");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Disposing all thread pools");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Disposing thread pool default");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Thread pool default disposed");
        loggerControl.replay();
        DefaultRunnableManager runnableManager = new DefaultRunnableManager();
        runnableManager.enableLogging(logger);
        try {
            runnableManager.configure(mainConfig);
        }
        catch (ConfigurationException ce) {
            DefaultRunnableManagerTestCase.assertTrue((String)"Throw unexpected ConfigurationException", (boolean)false);
        }
        MockControl runnableControl = this.createStrictControl(Runnable.class);
        Runnable runnable = (Runnable)runnableControl.getMock();
        runnable.run();
        runnableControl.replay();
        try {
            runnableManager.start();
            Thread.yield();
            Thread.sleep(20L);
            runnableManager.execute(runnable, 100L, 0L);
            Thread.yield();
            Thread.sleep(200L);
            runnableManager.stop();
            Thread.yield();
            Thread.sleep(20L);
            runnableManager.dispose();
            Thread.sleep(20L);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            DefaultRunnableManagerTestCase.assertTrue((String)"Unexpected Exception", (boolean)false);
        }
        this.verify();
    }

    public final void testExecuteRunnablelonglong() {
        MockControl mainConfigControl = this.createStrictControl(Configuration.class);
        Configuration mainConfig = (Configuration)mainConfigControl.getMock();
        mainConfigControl.expectAndReturn((Object)mainConfig.getChild("thread-factory"), (Object)this.createValueConfigMock(DefaultRunnableManager.DEFAULT_THREAD_FACTORY, DefaultRunnableManager.DEFAULT_THREAD_FACTORY));
        mainConfigControl.expectAndReturn((Object)mainConfig.getChild("thread-pools"), (Object)this.createChildrenConfigMock("thread-pool", new Configuration[0]));
        mainConfigControl.replay();
        MockControl childLoggerControl = this.createStrictControl(Logger.class);
        Logger childLogger = (Logger)childLoggerControl.getMock();
        childLoggerControl.expectAndReturn(childLogger.isDebugEnabled(), true);
        childLogger.debug("Executing Command: org.apache.cocoon.components.thread.DefaultRunnableManager");
        childLoggerControl.setMatcher(MockControl.ALWAYS_MATCHER);
        childLoggerControl.expectAndReturn(childLogger.isDebugEnabled(), true);
        childLogger.debug("Executing Command: org.apache.cocoon.components.thread.DefaultRunnableManager");
        childLoggerControl.replay();
        MockControl loggerControl = this.createStrictControl(Logger.class);
        Logger logger = (Logger)loggerControl.getMock();
        loggerControl.expectAndReturn((Object)logger.getChildLogger("default"), (Object)childLogger);
        loggerControl.expectAndReturn(logger.isInfoEnabled(), true);
        logger.info("ThreadPool named \"default\" created with maximum queue-size=2147483647,max-pool-size=5,min-pool-size=5,priority=5,isDaemon=false,keep-alive-time-ms=60000,block-policy=\"RUN\",shutdown-wait-time-ms=-1");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Starting the heart");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Entering loop");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("No commands available. Will just wait for one");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Command entered: EasyMock for interface java.lang.Runnable, pool=default, delay=100, interval=100");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Executing command EasyMock for interface java.lang.Runnable in pool \"default\", schedule with interval=100");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Exiting loop");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Disposing all thread pools");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Disposing thread pool default");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Thread pool default disposed");
        loggerControl.replay();
        DefaultRunnableManager runnableManager = new DefaultRunnableManager();
        runnableManager.enableLogging(logger);
        try {
            runnableManager.configure(mainConfig);
        }
        catch (ConfigurationException ce) {
            DefaultRunnableManagerTestCase.assertTrue((String)"Throw unexpected ConfigurationException", (boolean)false);
        }
        MockControl runnableControl = this.createStrictControl(Runnable.class);
        Runnable runnable = (Runnable)runnableControl.getMock();
        runnable.run();
        runnableControl.setVoidCallable(MockControl.ONE_OR_MORE);
        runnableControl.replay();
        try {
            runnableManager.start();
            Thread.yield();
            Thread.sleep(20L);
            runnableManager.execute(runnable, 100L, 100L);
            Thread.yield();
            Thread.sleep(200L);
            runnableManager.stop();
            Thread.yield();
            Thread.sleep(20L);
            runnableManager.dispose();
            Thread.sleep(20L);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            DefaultRunnableManagerTestCase.assertTrue((String)"Unexpected Exception", (boolean)false);
        }
        this.verify();
    }

    public final void testExecuteStringRunnable() {
        MockControl mainConfigControl = this.createStrictControl(Configuration.class);
        Configuration mainConfig = (Configuration)mainConfigControl.getMock();
        mainConfigControl.expectAndReturn((Object)mainConfig.getChild("thread-factory"), (Object)this.createValueConfigMock(DefaultRunnableManager.DEFAULT_THREAD_FACTORY, DefaultRunnableManager.DEFAULT_THREAD_FACTORY));
        mainConfigControl.expectAndReturn((Object)mainConfig.getChild("thread-pools"), (Object)this.createChildrenConfigMock("thread-pool", new Configuration[0]));
        mainConfigControl.replay();
        MockControl childLoggerDefaultControl = this.createStrictControl(Logger.class);
        Logger childLoggerDefault = (Logger)childLoggerDefaultControl.getMock();
        childLoggerDefaultControl.expectAndReturn(childLoggerDefault.isDebugEnabled(), true);
        childLoggerDefault.debug("Executing Command: org.apache.cocoon.components.thread.DefaultRunnableManager");
        childLoggerDefaultControl.setMatcher(MockControl.ALWAYS_MATCHER);
        childLoggerDefaultControl.replay();
        MockControl childLoggerMyPoolControl = this.createStrictControl(Logger.class);
        Logger childLoggerMyPool = (Logger)childLoggerMyPoolControl.getMock();
        childLoggerMyPoolControl.expectAndReturn(childLoggerMyPool.isDebugEnabled(), true);
        childLoggerMyPool.debug("Executing Command: EasyMock for interface java.lang.Runnable,pool=mypool");
        childLoggerMyPoolControl.replay();
        MockControl loggerControl = this.createStrictControl(Logger.class);
        Logger logger = (Logger)loggerControl.getMock();
        loggerControl.expectAndReturn((Object)logger.getChildLogger("default"), (Object)childLoggerDefault);
        loggerControl.expectAndReturn(logger.isInfoEnabled(), true);
        logger.info("ThreadPool named \"default\" created with maximum queue-size=2147483647,max-pool-size=5,min-pool-size=5,priority=5,isDaemon=false,keep-alive-time-ms=60000,block-policy=\"RUN\",shutdown-wait-time-ms=-1");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Starting the heart");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Entering loop");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("No commands available. Will just wait for one");
        loggerControl.expectAndReturn((Object)logger.getChildLogger("mypool"), (Object)childLoggerMyPool);
        loggerControl.expectAndReturn(logger.isInfoEnabled(), true);
        logger.info("ThreadPool named \"mypool\" created with maximum queue-size=230,max-pool-size=15,min-pool-size=12,priority=1,isDaemon=false,keep-alive-time-ms=15500,block-policy=\"DISCARD\",shutdown-wait-time-ms=22200");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Command entered: EasyMock for interface java.lang.Runnable, pool=mypool, delay=0, interval=0");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Executing command EasyMock for interface java.lang.Runnable in pool \"mypool\", schedule with interval=0");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("No commands available. Will just wait for one");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Exiting loop");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Disposing all thread pools");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Disposing thread pool mypool");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Thread pool mypool disposed");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Disposing thread pool default");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Thread pool default disposed");
        loggerControl.replay();
        DefaultRunnableManager runnableManager = new DefaultRunnableManager();
        runnableManager.enableLogging(logger);
        try {
            runnableManager.configure(mainConfig);
        }
        catch (ConfigurationException ce) {
            DefaultRunnableManagerTestCase.assertTrue((String)"Throw unexpected ConfigurationException", (boolean)false);
        }
        MockControl runnableControl = this.createStrictControl(Runnable.class);
        Runnable runnable = (Runnable)runnableControl.getMock();
        runnable.run();
        runnableControl.replay();
        try {
            runnableManager.start();
            Thread.yield();
            Thread.sleep(20L);
            runnableManager.createPool("mypool", 230, 15, 12, 1, false, 15500L, "DISCARD", false, 22200);
            runnableManager.execute("mypool", runnable);
            Thread.yield();
            Thread.sleep(20L);
            runnableManager.stop();
            Thread.yield();
            Thread.sleep(20L);
            runnableManager.dispose();
            Thread.sleep(20L);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            DefaultRunnableManagerTestCase.assertTrue((String)"Unexpected Exception", (boolean)false);
        }
        this.verify();
    }

    public final void testExecuteStringRunnablelong() {
        MockControl mainConfigControl = this.createStrictControl(Configuration.class);
        Configuration mainConfig = (Configuration)mainConfigControl.getMock();
        mainConfigControl.expectAndReturn((Object)mainConfig.getChild("thread-factory"), (Object)this.createValueConfigMock(DefaultRunnableManager.DEFAULT_THREAD_FACTORY, DefaultRunnableManager.DEFAULT_THREAD_FACTORY));
        mainConfigControl.expectAndReturn((Object)mainConfig.getChild("thread-pools"), (Object)this.createChildrenConfigMock("thread-pool", new Configuration[0]));
        mainConfigControl.replay();
        MockControl childLoggerDefaultControl = this.createStrictControl(Logger.class);
        Logger childLoggerDefault = (Logger)childLoggerDefaultControl.getMock();
        childLoggerDefaultControl.expectAndReturn(childLoggerDefault.isDebugEnabled(), true);
        childLoggerDefault.debug("Executing Command: org.apache.cocoon.components.thread.DefaultRunnableManager");
        childLoggerDefaultControl.setMatcher(MockControl.ALWAYS_MATCHER);
        childLoggerDefaultControl.replay();
        MockControl childLoggerMyPoolControl = this.createStrictControl(Logger.class);
        Logger childLoggerMyPool = (Logger)childLoggerMyPoolControl.getMock();
        childLoggerMyPoolControl.expectAndReturn(childLoggerMyPool.isDebugEnabled(), true);
        childLoggerMyPool.debug("Executing Command: EasyMock for interface java.lang.Runnable,pool=mypool");
        childLoggerMyPoolControl.replay();
        MockControl loggerControl = this.createStrictControl(Logger.class);
        Logger logger = (Logger)loggerControl.getMock();
        loggerControl.expectAndReturn((Object)logger.getChildLogger("default"), (Object)childLoggerDefault);
        loggerControl.expectAndReturn(logger.isInfoEnabled(), true);
        logger.info("ThreadPool named \"default\" created with maximum queue-size=2147483647,max-pool-size=5,min-pool-size=5,priority=5,isDaemon=false,keep-alive-time-ms=60000,block-policy=\"RUN\",shutdown-wait-time-ms=-1");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Starting the heart");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Entering loop");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("No commands available. Will just wait for one");
        loggerControl.expectAndReturn((Object)logger.getChildLogger("mypool"), (Object)childLoggerMyPool);
        loggerControl.expectAndReturn(logger.isInfoEnabled(), true);
        logger.info("ThreadPool named \"mypool\" created with maximum queue-size=230,max-pool-size=15,min-pool-size=12,priority=1,isDaemon=false,keep-alive-time-ms=15500,block-policy=\"DISCARD\",shutdown-wait-time-ms=22200");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Command entered: EasyMock for interface java.lang.Runnable, pool=mypool, delay=100, interval=0");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Executing command EasyMock for interface java.lang.Runnable in pool \"mypool\", schedule with interval=0");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("No commands available. Will just wait for one");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Exiting loop");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Disposing all thread pools");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Disposing thread pool mypool");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Thread pool mypool disposed");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Disposing thread pool default");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Thread pool default disposed");
        loggerControl.replay();
        DefaultRunnableManager runnableManager = new DefaultRunnableManager();
        runnableManager.enableLogging(logger);
        try {
            runnableManager.configure(mainConfig);
        }
        catch (ConfigurationException ce) {
            DefaultRunnableManagerTestCase.assertTrue((String)"Throw unexpected ConfigurationException", (boolean)false);
        }
        MockControl runnableControl = this.createStrictControl(Runnable.class);
        Runnable runnable = (Runnable)runnableControl.getMock();
        runnable.run();
        runnableControl.replay();
        try {
            runnableManager.start();
            Thread.yield();
            Thread.sleep(20L);
            runnableManager.createPool("mypool", 230, 15, 12, 1, false, 15500L, "DISCARD", false, 22200);
            runnableManager.execute("mypool", runnable, 100L, 0L);
            Thread.yield();
            Thread.sleep(200L);
            runnableManager.stop();
            Thread.yield();
            Thread.sleep(20L);
            runnableManager.dispose();
            Thread.sleep(20L);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            DefaultRunnableManagerTestCase.assertTrue((String)"Unexpected Exception", (boolean)false);
        }
        this.verify();
    }

    public final void testExecuteStringRunnablelonglong() {
        MockControl mainConfigControl = this.createStrictControl(Configuration.class);
        Configuration mainConfig = (Configuration)mainConfigControl.getMock();
        mainConfigControl.expectAndReturn((Object)mainConfig.getChild("thread-factory"), (Object)this.createValueConfigMock(DefaultRunnableManager.DEFAULT_THREAD_FACTORY, DefaultRunnableManager.DEFAULT_THREAD_FACTORY));
        mainConfigControl.expectAndReturn((Object)mainConfig.getChild("thread-pools"), (Object)this.createChildrenConfigMock("thread-pool", new Configuration[0]));
        mainConfigControl.replay();
        MockControl childLoggerDefaultControl = this.createStrictControl(Logger.class);
        Logger childLoggerDefault = (Logger)childLoggerDefaultControl.getMock();
        childLoggerDefaultControl.expectAndReturn(childLoggerDefault.isDebugEnabled(), true);
        childLoggerDefault.debug("Executing Command: org.apache.cocoon.components.thread.DefaultRunnableManager");
        childLoggerDefaultControl.setMatcher(MockControl.ALWAYS_MATCHER);
        childLoggerDefaultControl.replay();
        MockControl childLoggerMyPoolControl = this.createStrictControl(Logger.class);
        Logger childLoggerMyPool = (Logger)childLoggerMyPoolControl.getMock();
        childLoggerMyPoolControl.expectAndReturn(childLoggerMyPool.isDebugEnabled(), true);
        childLoggerMyPool.debug("Executing Command: EasyMock for interface java.lang.Runnable,pool=mypool");
        childLoggerMyPoolControl.replay();
        MockControl loggerControl = this.createStrictControl(Logger.class);
        Logger logger = (Logger)loggerControl.getMock();
        loggerControl.expectAndReturn((Object)logger.getChildLogger("default"), (Object)childLoggerDefault);
        loggerControl.expectAndReturn(logger.isInfoEnabled(), true);
        logger.info("ThreadPool named \"default\" created with maximum queue-size=2147483647,max-pool-size=5,min-pool-size=5,priority=5,isDaemon=false,keep-alive-time-ms=60000,block-policy=\"RUN\",shutdown-wait-time-ms=-1");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Starting the heart");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Entering loop");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("No commands available. Will just wait for one");
        loggerControl.expectAndReturn((Object)logger.getChildLogger("mypool"), (Object)childLoggerMyPool);
        loggerControl.expectAndReturn(logger.isInfoEnabled(), true);
        logger.info("ThreadPool named \"mypool\" created with maximum queue-size=230,max-pool-size=15,min-pool-size=12,priority=1,isDaemon=false,keep-alive-time-ms=15500,block-policy=\"DISCARD\",shutdown-wait-time-ms=22200");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Command entered: EasyMock for interface java.lang.Runnable, pool=mypool, delay=100, interval=100");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Executing command EasyMock for interface java.lang.Runnable in pool \"mypool\", schedule with interval=100");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Exiting loop");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Disposing all thread pools");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Disposing thread pool mypool");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Thread pool mypool disposed");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Disposing thread pool default");
        loggerControl.expectAndReturn(logger.isDebugEnabled(), true);
        logger.debug("Thread pool default disposed");
        loggerControl.replay();
        DefaultRunnableManager runnableManager = new DefaultRunnableManager();
        runnableManager.enableLogging(logger);
        try {
            runnableManager.configure(mainConfig);
        }
        catch (ConfigurationException ce) {
            DefaultRunnableManagerTestCase.assertTrue((String)"Throw unexpected ConfigurationException", (boolean)false);
        }
        MockControl runnableControl = this.createStrictControl(Runnable.class);
        Runnable runnable = (Runnable)runnableControl.getMock();
        runnable.run();
        runnableControl.replay();
        try {
            runnableManager.start();
            Thread.yield();
            Thread.sleep(20L);
            runnableManager.createPool("mypool", 230, 15, 12, 1, false, 15500L, "DISCARD", false, 22200);
            runnableManager.execute("mypool", runnable, 100L, 100L);
            Thread.yield();
            Thread.sleep(200L);
            runnableManager.stop();
            Thread.yield();
            Thread.sleep(20L);
            runnableManager.dispose();
            Thread.sleep(20L);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            DefaultRunnableManagerTestCase.assertTrue((String)"Unexpected Exception", (boolean)false);
        }
        this.verify();
    }
}

