/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.thread;

import junit.framework.TestCase;
import org.apache.cocoon.components.thread.DefaultThreadFactory;

public class DefaultThreadFactoryTestCase
extends TestCase {
    public final void testGetPriority() {
        DefaultThreadFactory factory = new DefaultThreadFactory();
        factory.setPriority(10);
        DefaultThreadFactoryTestCase.assertEquals((String)"priority", (int)10, (int)factory.getPriority());
    }

    public final void testIsDaemon() {
        DefaultThreadFactory factory = new DefaultThreadFactory();
        factory.setDaemon(false);
        DefaultThreadFactoryTestCase.assertEquals((String)"daemon mode", (boolean)false, (boolean)factory.isDaemon());
    }

    public final void testNewThread() {
        DefaultThreadFactory factory = new DefaultThreadFactory();
        factory.setDaemon(true);
        factory.setPriority(1);
        Thread thread = factory.newThread((Runnable)new DummyRunnable());
        DefaultThreadFactoryTestCase.assertEquals((String)"new thread daemon mode", (boolean)true, (boolean)thread.isDaemon());
        DefaultThreadFactoryTestCase.assertEquals((String)"new thread priority", (int)1, (int)thread.getPriority());
        DefaultThreadFactoryTestCase.assertEquals((String)"factory daemon mode", (boolean)factory.isDaemon(), (boolean)thread.isDaemon());
        DefaultThreadFactoryTestCase.assertEquals((String)"factory priority", (int)factory.getPriority(), (int)thread.getPriority());
    }

    public final void testSetDaemon() {
        DefaultThreadFactory factory = new DefaultThreadFactory();
        factory.setDaemon(false);
        Thread thread = factory.newThread((Runnable)new DummyRunnable());
        DefaultThreadFactoryTestCase.assertEquals((String)"daemon mode", (boolean)false, (boolean)thread.isDaemon());
    }

    public final void testSetPriority() {
        DefaultThreadFactory factory = new DefaultThreadFactory();
        factory.setPriority(10);
        Thread thread = factory.newThread((Runnable)new DummyRunnable());
        DefaultThreadFactoryTestCase.assertEquals((String)"priority", (int)10, (int)thread.getPriority());
    }

    private static class DummyRunnable
    implements Runnable {
        private DummyRunnable() {
        }

        public void run() {
        }
    }
}

