/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.thread;

import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.components.thread.AbstractTestCase;
import org.apache.cocoon.components.thread.DefaultThreadFactory;
import org.apache.cocoon.components.thread.DefaultThreadPool;
import org.easymock.MockControl;

public class DefaultThreadPoolTestCase
extends AbstractTestCase {
    public final void testDefaultThreadPool() {
        DefaultThreadPool pool = new DefaultThreadPool();
        pool.enableLogging((Logger)new ConsoleLogger(0));
        pool.setName("mypool");
        DefaultThreadFactory threadFactory = new DefaultThreadFactory();
        threadFactory.setPriority(10);
        pool.setThreadFactory((ThreadFactory)threadFactory);
        pool.setQueue(230);
        pool.setMaximumPoolSize(15);
        pool.setMinimumPoolSize(9);
        pool.setKeepAliveTime(11000L);
        pool.setBlockPolicy("ABORT");
        pool.setShutdownGraceful(false);
        pool.setShutdownWaitTimeMs(12345);
        DefaultThreadPoolTestCase.assertEquals((String)"block-policy", (String)"ABORT", (String)pool.getBlockPolicy());
        DefaultThreadPoolTestCase.assertEquals((String)"keep-alive-time-ms", (long)11000L, (long)pool.getKeepAliveTime());
        DefaultThreadPoolTestCase.assertEquals((String)"max-queueu-size", (int)230, (int)pool.getMaximumQueueSize());
        DefaultThreadPoolTestCase.assertEquals((String)"max-pool-size", (int)15, (int)pool.getMaximumPoolSize());
        DefaultThreadPoolTestCase.assertEquals((String)"min-pool-size", (int)9, (int)pool.getMinimumPoolSize());
        DefaultThreadPoolTestCase.assertEquals((String)"name", (String)"mypool", (String)pool.getName());
        DefaultThreadPoolTestCase.assertEquals((String)"priority", (int)10, (int)pool.getPriority());
        DefaultThreadPoolTestCase.assertEquals((String)"queue-size", (int)0, (int)pool.getQueueSize());
        DefaultThreadPoolTestCase.assertEquals((String)"isQueued", (boolean)true, (boolean)pool.isQueued());
        DefaultThreadPoolTestCase.assertEquals((String)"isTerminatedAfterShutdown", (boolean)false, (boolean)pool.isTerminatedAfterShutdown());
        this.verify();
    }

    public final void testExecuteRunnable() throws InterruptedException {
        MockControl runnableControl = this.createStrictControl(Runnable.class);
        Runnable runnable = (Runnable)runnableControl.getMock();
        runnable.run();
        runnableControl.replay();
        DefaultThreadPool pool = new DefaultThreadPool();
        pool.enableLogging((Logger)new ConsoleLogger(0));
        pool.setName("mypool");
        pool.setThreadFactory((ThreadFactory)new DefaultThreadFactory());
        pool.setQueue(230);
        pool.setMaximumPoolSize(15);
        pool.setMinimumPoolSize(9);
        pool.setKeepAliveTime(100L);
        pool.setBlockPolicy("ABORT");
        pool.setShutdownGraceful(false);
        pool.setShutdownWaitTimeMs(1234);
        pool.execute(runnable);
        Thread.yield();
        Thread.sleep(100L);
        pool.shutdown();
        this.verify();
    }

    public final void testShutdown() throws InterruptedException {
        Runnable runnable = new Runnable(){

            public void run() {
                ConsoleLogger logger = new ConsoleLogger(0);
                logger.info("runnable runs");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    logger.info("runnable has been interrupted ");
                }
                logger.info("runnable terminated");
            }
        };
        DefaultThreadPool pool = new DefaultThreadPool();
        pool.enableLogging((Logger)new ConsoleLogger(0));
        pool.setName("mypool");
        pool.setThreadFactory((ThreadFactory)new DefaultThreadFactory());
        pool.setQueue(0);
        pool.setMaximumPoolSize(15);
        pool.setMinimumPoolSize(9);
        pool.setKeepAliveTime(1000L);
        pool.setBlockPolicy("ABORT");
        pool.setShutdownGraceful(true);
        pool.setShutdownWaitTimeMs(100);
        pool.execute(runnable);
        pool.execute(runnable);
        Thread.yield();
        Thread.sleep(200L);
        pool.shutdown();
        Thread.sleep(200L);
        this.verify();
    }
}

