/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.variables;

import java.util.HashMap;
import org.apache.cocoon.SitemapComponentTestCase;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.variables.PreparedVariableResolver;
import org.apache.cocoon.environment.mock.MockRequest;
import org.apache.cocoon.sitemap.PatternException;

public class PreparedVariableResolverTestCase
extends SitemapComponentTestCase {
    public void testNestedExpressions() throws Exception {
        String expr = "{request-param:{request-param:foo}}";
        MockRequest request = this.getRequest();
        request.reset();
        request.addParameter("foo", "bar");
        request.addParameter("bar", "123");
        InvokeContext context = new InvokeContext(true);
        context.enableLogging(this.getLogger());
        HashMap sitemapElements = new HashMap();
        context.pushMap("sitemap", sitemapElements);
        PreparedVariableResolver resolver = new PreparedVariableResolver(expr, this.getManager());
        PreparedVariableResolverTestCase.assertEquals((String)"123", (String)resolver.resolve(context, this.getObjectModel()));
    }

    public void testNestedModuleAndSitemapExpressions() throws Exception {
        String expr = "{request-param:f{1}}";
        MockRequest request = this.getRequest();
        request.reset();
        request.addParameter("foo", "123");
        InvokeContext context = new InvokeContext(true);
        context.enableLogging(this.getLogger());
        HashMap<String, String> sitemapElements = new HashMap<String, String>();
        sitemapElements.put("1", "oo");
        context.pushMap("sitemap", sitemapElements);
        PreparedVariableResolver resolver = new PreparedVariableResolver(expr, this.getManager());
        PreparedVariableResolverTestCase.assertEquals((String)"123", (String)resolver.resolve(context, this.getObjectModel()));
    }

    public void testAnchors() throws PatternException {
        String expr = "{#label:name}";
        InvokeContext context = new InvokeContext(true);
        context.enableLogging(this.getLogger());
        HashMap<String, String> sitemapElements = new HashMap<String, String>();
        sitemapElements.put("name", "123");
        context.pushMap("label", sitemapElements);
        PreparedVariableResolver resolver = new PreparedVariableResolver(expr, this.getManager());
        PreparedVariableResolverTestCase.assertEquals((String)"123", (String)resolver.resolve(context, this.getObjectModel()));
    }

    public void testSitemapVariables() throws PatternException {
        String expr = "123{1}";
        InvokeContext context = new InvokeContext(true);
        context.enableLogging(this.getLogger());
        HashMap<String, String> sitemapElements = new HashMap<String, String>();
        sitemapElements.put("1", "abc");
        context.pushMap("label", sitemapElements);
        PreparedVariableResolver resolver = new PreparedVariableResolver(expr, this.getManager());
        PreparedVariableResolverTestCase.assertEquals((String)"123abc", (String)resolver.resolve(context, this.getObjectModel()));
    }

    public void testSitemapVariablesWithText() throws PatternException {
        String expr = "123{1}/def";
        InvokeContext context = new InvokeContext(true);
        context.enableLogging(this.getLogger());
        HashMap<String, String> sitemapElements = new HashMap<String, String>();
        sitemapElements.put("1", "abc");
        context.pushMap("label", sitemapElements);
        PreparedVariableResolver resolver = new PreparedVariableResolver(expr, this.getManager());
        PreparedVariableResolverTestCase.assertEquals((String)"123abc/def", (String)resolver.resolve(context, this.getObjectModel()));
    }

    public void testPrefixedSitemapVariable() throws PatternException {
        String expr = "123{sitemap:1}/def";
        InvokeContext context = new InvokeContext(true);
        context.enableLogging(this.getLogger());
        HashMap<String, String> sitemapElements = new HashMap<String, String>();
        sitemapElements.put("1", "abc");
        context.pushMap("label", sitemapElements);
        PreparedVariableResolver resolver = new PreparedVariableResolver(expr, this.getManager());
        PreparedVariableResolverTestCase.assertEquals((String)"123abc/def", (String)resolver.resolve(context, this.getObjectModel()));
    }

    public void testMultilevelSitemapVariables() throws PatternException {
        String expr = "from {../1} to {1}";
        InvokeContext context = new InvokeContext(true);
        context.enableLogging(this.getLogger());
        HashMap<String, String> sitemapElements = new HashMap<String, String>();
        sitemapElements.put("1", "juliet");
        context.pushMap("label1", sitemapElements);
        sitemapElements = new HashMap();
        sitemapElements.put("1", "oscar");
        context.pushMap("label2", sitemapElements);
        PreparedVariableResolver resolver = new PreparedVariableResolver(expr, this.getManager());
        PreparedVariableResolverTestCase.assertEquals((String)"from juliet to oscar", (String)resolver.resolve(context, this.getObjectModel()));
    }

    public void testRootSitemapVariables() throws PatternException {
        String expr = "from {/1} to {1}";
        InvokeContext context = new InvokeContext(true);
        context.enableLogging(this.getLogger());
        HashMap<String, String> sitemapElements = new HashMap<String, String>();
        sitemapElements.put("1", "juliet");
        context.pushMap("label1", sitemapElements);
        sitemapElements = new HashMap();
        sitemapElements.put("1", "oscar");
        context.pushMap("label2", sitemapElements);
        PreparedVariableResolver resolver = new PreparedVariableResolver(expr, this.getManager());
        PreparedVariableResolverTestCase.assertEquals((String)"from juliet to oscar", (String)resolver.resolve(context, this.getObjectModel()));
    }

    public void testColonInTextContent() throws PatternException {
        String expr = "http://cocoon.apache.org";
        InvokeContext context = new InvokeContext(true);
        context.enableLogging(this.getLogger());
        HashMap sitemapElements = new HashMap();
        context.pushMap("label", sitemapElements);
        PreparedVariableResolver resolver = new PreparedVariableResolver(expr, this.getManager());
        PreparedVariableResolverTestCase.assertEquals((String)"http://cocoon.apache.org", (String)resolver.resolve(context, this.getObjectModel()));
    }

    public void testColonBeginningTextContent() throws PatternException {
        String expr = ":colon-starts-this";
        InvokeContext context = new InvokeContext(true);
        context.enableLogging(this.getLogger());
        HashMap sitemapElements = new HashMap();
        context.pushMap("label", sitemapElements);
        PreparedVariableResolver resolver = new PreparedVariableResolver(expr, this.getManager());
        PreparedVariableResolverTestCase.assertEquals((String)":colon-starts-this", (String)resolver.resolve(context, this.getObjectModel()));
    }

    public void testEmbeddedColon() throws PatternException {
        String expr = "{1}:{1}";
        InvokeContext context = new InvokeContext(true);
        context.enableLogging(this.getLogger());
        HashMap<String, String> sitemapElements = new HashMap<String, String>();
        sitemapElements.put("1", "abc");
        context.pushMap("label", sitemapElements);
        PreparedVariableResolver resolver = new PreparedVariableResolver(expr, this.getManager());
        PreparedVariableResolverTestCase.assertEquals((String)"abc:abc", (String)resolver.resolve(context, this.getObjectModel()));
    }

    public void testEscapedBraces() throws PatternException {
        String expr = "This is a \\{brace\\}";
        InvokeContext context = new InvokeContext(true);
        context.enableLogging(this.getLogger());
        HashMap sitemapElements = new HashMap();
        context.pushMap("label", sitemapElements);
        PreparedVariableResolver resolver = new PreparedVariableResolver(expr, this.getManager());
        PreparedVariableResolverTestCase.assertEquals((String)"This is a {brace}", (String)resolver.resolve(context, this.getObjectModel()));
    }

    public void testModuleWithoutOption() throws PatternException {
        String expr = "{baselink:}";
        InvokeContext context = new InvokeContext(true);
        context.enableLogging(this.getLogger());
        HashMap sitemapElements = new HashMap();
        context.pushMap("sitemap", sitemapElements);
        PreparedVariableResolver resolver = new PreparedVariableResolver(expr, this.getManager());
        PreparedVariableResolverTestCase.assertEquals((String)"", (String)resolver.resolve(context, this.getObjectModel()));
    }
}

