/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.core.container;

import java.io.InputStream;
import java.net.URL;
import junit.framework.TestCase;
import org.apache.avalon.excalibur.component.DefaultRoleManager;
import org.apache.avalon.excalibur.component.ExcaliburComponentManager;
import org.apache.avalon.excalibur.component.RoleManager;
import org.apache.avalon.excalibur.logger.LoggerManager;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.WrapperServiceManager;
import org.apache.cocoon.util.Deprecation;

public class ContainerTestCase
extends TestCase {
    private Logger logger;
    private ServiceManager manager;

    protected Logger getLogger() {
        return this.logger;
    }

    protected ServiceManager getManager() {
        return this.manager;
    }

    protected void setUp() throws Exception {
        super.setUp();
        String level = System.getProperty("junit.test.loglevel", "2");
        this.logger = new ConsoleLogger(Integer.parseInt(level));
        Deprecation.setLogger((Logger)this.logger);
        this.prepare();
    }

    protected void prepare() throws Exception {
        String resourceName = ((Object)((Object)this)).getClass().getName().replace('.', '/') + ".xtest";
        URL resource = ((Object)((Object)this)).getClass().getClassLoader().getResource(resourceName);
        if (resource != null) {
            this.getLogger().debug("Loading resource " + resourceName);
            this.prepare(resource.openStream());
        } else {
            this.getLogger().debug("Resource not found " + resourceName);
        }
    }

    protected final void prepare(InputStream testconf) throws Exception {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("ContainerTestCase.initialize");
        }
        DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
        Configuration conf = builder.build(testconf);
        Context context = this.setupContext(conf.getChild("context"));
        this.setupManagers(conf.getChild("components"), conf.getChild("roles"), context);
    }

    protected void tearDown() throws Exception {
        this.done();
        super.tearDown();
    }

    private final void done() {
        if (this.manager != null) {
            ContainerUtil.dispose((Object)this.manager);
            this.manager = null;
        }
    }

    private final Context setupContext(Configuration conf) throws Exception {
        DefaultContext context = new DefaultContext();
        Configuration[] confs = conf.getChildren("entry");
        for (int i = 0; i < confs.length; ++i) {
            String key = confs[i].getAttribute("name");
            String value = confs[i].getAttribute("value", null);
            if (value == null) {
                String clazz = confs[i].getAttribute("class");
                Object obj = ((Object)((Object)this)).getClass().getClassLoader().loadClass(clazz).newInstance();
                context.put((Object)key, obj);
                if (!this.getLogger().isInfoEnabled()) continue;
                this.getLogger().info("ContainerTestCase: added an instance of class " + clazz + " to context entry " + key);
                continue;
            }
            context.put((Object)key, (Object)value);
            if (!this.getLogger().isInfoEnabled()) continue;
            this.getLogger().info("ContainerTestCase: added value \"" + value + "\" to context entry " + key);
        }
        this.addContext(context);
        return context;
    }

    protected void addContext(DefaultContext context) {
    }

    private final void setupManagers(Configuration confCM, Configuration confRM, Context context) throws Exception {
        DefaultRoleManager roleManager = new DefaultRoleManager();
        roleManager.enableLogging(this.getLogger());
        roleManager.configure(confRM);
        ExcaliburComponentManager ecManager = new ExcaliburComponentManager();
        ecManager.enableLogging(this.getLogger());
        ecManager.contextualize(context);
        ecManager.setRoleManager((RoleManager)roleManager);
        ecManager.setLoggerManager((LoggerManager)new DefaultLoggerManager(this.getLogger()));
        ecManager.configure(confCM);
        ecManager.initialize();
        this.manager = new WrapperServiceManager((ComponentManager)ecManager);
    }

    protected final Object lookup(String key) throws ServiceException {
        return this.manager.lookup(key);
    }

    protected final void release(Object object) {
        this.manager.release(object);
    }

    protected static class DefaultLoggerManager
    implements LoggerManager {
        private Logger logger;

        public DefaultLoggerManager(Logger logger) {
            this.logger = logger;
        }

        public Logger getDefaultLogger() {
            return this.logger;
        }

        public Logger getLoggerForCategory(String arg0) {
            return this.logger;
        }
    }
}

