/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.environment.commandline.test;

import java.io.File;
import java.net.URL;
import junit.framework.TestCase;
import junit.swingui.TestRunner;
import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.environment.commandline.CommandLineContext;

public final class CommandLineContextTestCase
extends TestCase {
    private String commandLineContextDir;
    private CommandLineContext commandLineContext;

    public CommandLineContextTestCase() {
        this("CommandLineContextTestCase");
    }

    public CommandLineContextTestCase(String name) {
        super(name);
    }

    public static void main(String[] args) throws Exception {
        String[] testCaseName = new String[]{CommandLineContextTestCase.class.getName()};
        TestRunner.main((String[])testCaseName);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.commandLineContextDir = System.getProperty("java.io.tmpdir", "/tmp");
        new File(this.commandLineContextDir, "foo" + File.separator + "bar").mkdirs();
        String level = System.getProperty("junit.test.loglevel", "0");
        ConsoleLogger logger = new ConsoleLogger(Integer.parseInt(level));
        this.commandLineContext = new CommandLineContext(this.commandLineContextDir);
        this.commandLineContext.enableLogging((Logger)logger);
    }

    public void tearDown() throws Exception {
        super.tearDown();
        new File(this.commandLineContextDir, "foo" + File.separator + "bar").delete();
        new File(this.commandLineContextDir, "foo").delete();
    }

    public void testGetResource() throws Exception {
        Object[] test_values = new Object[]{new String[]{"", this.commandLineContextDir}, new String[]{"/", this.commandLineContextDir}, new String[]{"foo", this.commandLineContextDir + File.separator + "foo"}, new String[]{"foo/bar", this.commandLineContextDir + File.separator + "foo/bar"}, new String[]{"foo/bar/nonexistent", null}};
        for (int i = 0; i < test_values.length; ++i) {
            String[] tests = (String[])test_values[i];
            String test = tests[0];
            URL result = this.commandLineContext.getResource(test);
            URL expected = null;
            if (result != null) {
                expected = new File(tests[1]).toURL();
            }
            String message = "Test '" + test + "'";
            CommandLineContextTestCase.assertEquals((String)message, (Object)expected, (Object)result);
        }
    }

    public void testGetRealPath() throws Exception {
        Object[] test_values = new Object[]{new String[]{"", ""}, new String[]{"/", "/"}, new String[]{"foo", "foo"}, new String[]{"foo/bar", "foo/bar"}};
        for (int i = 0; i < test_values.length; ++i) {
            String[] tests = (String[])test_values[i];
            String test = tests[0];
            File expected_file = new File(this.commandLineContextDir, tests[1]);
            String expected = expected_file.getAbsolutePath();
            String result = this.commandLineContext.getRealPath(test);
            String message = "Test '" + test + "'";
            CommandLineContextTestCase.assertEquals((String)message, (String)expected, (String)result);
        }
    }

    public void testAttributes() throws Exception {
        Object[] test_values = new Object[]{new String[]{"a", "b"}, new String[]{"foo", "foo"}, new String[]{"foo/bar", "foo/bar"}};
        for (int i = 0; i < test_values.length; ++i) {
            String[] tests = (String[])test_values[i];
            String name = tests[0];
            String expected = tests[1];
            this.commandLineContext.setAttribute(name, (Object)expected);
            String result = (String)this.commandLineContext.getAttribute(name);
            CommandLineContextTestCase.assertEquals((String)"Test 'n'", (String)expected, (String)result);
            this.commandLineContext.removeAttribute(name);
            result = (String)this.commandLineContext.getAttribute(name);
            CommandLineContextTestCase.assertEquals((String)"Test '<null>'", null, (String)result);
        }
    }
}

