/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.environment.mock;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import junit.framework.AssertionFailedError;
import org.apache.cocoon.environment.Cookie;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.mock.MockCookie;

public class MockResponse
implements Response {
    private String encoding;
    private Locale locale;
    private HashSet cookies = new HashSet();
    private HashMap header = new HashMap();

    public void setCharacterEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getCharacterEncoding() {
        return this.encoding;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Cookie createCookie(String name, String value) {
        MockCookie cookie = new MockCookie();
        cookie.setName(name);
        cookie.setValue(value);
        return cookie;
    }

    public void addCookie(Cookie cookie) {
        this.cookies.add(cookie);
    }

    public Set getCookies() {
        return this.cookies;
    }

    public boolean containsHeader(String name) {
        return this.header.containsKey(name);
    }

    public String encodeURL(String url) {
        throw new AssertionFailedError("Not implemented");
    }

    public void setDateHeader(String name, long date) {
        this.header.put(name, new Long(date));
    }

    public void addDateHeader(String name, long date) {
        this.header.put(name, new Long(date));
    }

    public void setHeader(String name, String value) {
        this.header.put(name, value);
    }

    public void addHeader(String name, String value) {
        this.header.put(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.header.put(name, new Integer(value));
    }

    public void addIntHeader(String name, int value) {
        this.header.put(name, new Integer(value));
    }

    public Map getHeader() {
        return this.header;
    }

    public void reset() {
        this.encoding = null;
        this.locale = null;
        this.cookies.clear();
        this.header.clear();
    }
}

