/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.matching;

import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.SitemapComponentTestCase;

public class WildcardURIMatcherTestCase
extends SitemapComponentTestCase {
    public void testWildcardURIMatch() throws Exception {
        this.getRequest().setRequestURI("/test/foo/bla/end");
        Parameters parameters = new Parameters();
        Map result = this.match("wildcard-uri", "**", parameters);
        WildcardURIMatcherTestCase.assertNotNull((String)"Test if resource exists", (Object)result);
        WildcardURIMatcherTestCase.assertEquals((String)"Test for **", (Object)"test/foo/bla/end", result.get("1"));
        result = this.match("wildcard-uri", "**/bla/*", parameters);
        WildcardURIMatcherTestCase.assertNotNull((String)"Test if resource exists", (Object)result);
        WildcardURIMatcherTestCase.assertEquals((String)"Test for **/bla/* {1}", (Object)"test/foo", result.get("1"));
        WildcardURIMatcherTestCase.assertEquals((String)"Test for **/bla/* {2}", (Object)"end", result.get("2"));
    }

    public void testWildcardURIMatchSimplePattern() throws Exception {
        this.getRequest().setRequestURI("/test");
        Parameters parameters = new Parameters();
        Map result = this.match("wildcard-uri", "*", parameters);
        WildcardURIMatcherTestCase.assertNotNull((String)"Test if resource exists", (Object)result);
        WildcardURIMatcherTestCase.assertEquals((String)"Test for *", (Object)"test", result.get("1"));
    }

    public void testWildcardURIMatchDoublePattern() throws Exception {
        this.getRequest().setRequestURI("/test/something.xmlbla.xml");
        Parameters parameters = new Parameters();
        Map result = this.match("wildcard-uri", "*/*.xml", parameters);
        WildcardURIMatcherTestCase.assertNotNull((String)"Test if resource exists", (Object)result);
        WildcardURIMatcherTestCase.assertEquals((String)"Test for */*.xml", (Object)"test", result.get("1"));
        WildcardURIMatcherTestCase.assertEquals((String)"Test for */*.xml", (Object)"something.xmlbla", result.get("2"));
    }

    public void testWildcardURIMatchMultiSinglePattern() throws Exception {
        this.getRequest().setRequestURI("foo/bar/baz.html");
        Parameters parameters = new Parameters();
        Map result = this.match("wildcard-uri", "**/*.html", parameters);
        WildcardURIMatcherTestCase.assertNotNull((String)"Test if resource exists", (Object)result);
        WildcardURIMatcherTestCase.assertEquals((String)"Test for {1} in **/*.html", (Object)"foo/bar", result.get("1"));
        WildcardURIMatcherTestCase.assertEquals((String)"Test for {2} in **/*.html", (Object)"baz", result.get("2"));
    }
}

