/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.selection;

import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.SitemapComponentTestCase;
import org.apache.cocoon.environment.mock.MockCookie;

public class CookieSelectorTestCase
extends SitemapComponentTestCase {
    private static final String COOKIE_SELECTOR = "cookie";

    public static void main(String[] args) {
        TestRunner.run((Test)CookieSelectorTestCase.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(CookieSelectorTestCase.class);
        return suite;
    }

    public void testCookieSelect() throws Exception {
        String cookieName = "cookieSelectorTestCase";
        String cookieValue = "cookieValue";
        Map cookies = this.getRequest().getCookieMap();
        MockCookie mockCookie = new MockCookie();
        mockCookie.setName("cookieSelectorTestCase");
        mockCookie.setValue("cookieValue");
        cookies.put("cookieSelectorTestCase", mockCookie);
        Parameters parameters = new Parameters();
        boolean result = this.select(COOKIE_SELECTOR, "cookieValue", parameters);
        System.out.println(result);
        CookieSelectorTestCase.assertTrue((String)"Test if a cookie is selected", (boolean)result);
        result = this.select(COOKIE_SELECTOR, "unknownCookieValue", parameters);
        System.out.println(result);
        CookieSelectorTestCase.assertTrue((String)"Test if a cookie is not selected", (!result ? 1 : 0) != 0);
    }

    public void testCookieSelectUsingParameters() throws Exception {
        String cookieName = "cookieSelectorTestCase1";
        String cookieValue = "cookieValue";
        Map cookies = this.getRequest().getCookieMap();
        MockCookie mockCookie = new MockCookie();
        mockCookie.setName("cookieSelectorTestCase1");
        mockCookie.setValue("cookieValue");
        cookies.put("cookieSelectorTestCase1", mockCookie);
        mockCookie = new MockCookie();
        mockCookie.setName("cookieSelectorTestCase");
        mockCookie.setValue("unknownCookieValue");
        cookies.put("cookieSelectorTestCase", mockCookie);
        Parameters parameters = new Parameters();
        parameters.setParameter("cookie-name", "cookieSelectorTestCase1");
        boolean result = this.select(COOKIE_SELECTOR, "cookieValue", parameters);
        System.out.println(result);
        CookieSelectorTestCase.assertTrue((String)"Test if a cookie is selected", (boolean)result);
        result = this.select(COOKIE_SELECTOR, "unknownCookieValue", parameters);
        System.out.println(result);
        CookieSelectorTestCase.assertTrue((String)"Test if a cookie is not selected", (!result ? 1 : 0) != 0);
    }
}

