/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.selection;

import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.SitemapComponentTestCase;

public class ExceptionSelectorTestCase
extends SitemapComponentTestCase {
    private static final String EXCEPTION_SELECTOR = "exception";

    public static void main(String[] args) {
        TestRunner.run((Test)ExceptionSelectorTestCase.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ExceptionSelectorTestCase.class);
        return suite;
    }

    public void testExceptionSelect() throws Exception {
        NullPointerException npe = new NullPointerException("ExceptionSelectorTestCase");
        Map objectModel = this.getObjectModel();
        objectModel.put("throwable", npe);
        Parameters parameters = new Parameters();
        boolean result = this.select(EXCEPTION_SELECTOR, "npe", parameters);
        System.out.println(result);
        ExceptionSelectorTestCase.assertTrue((String)"Test if a npe is selected", (boolean)result);
        result = this.select(EXCEPTION_SELECTOR, "non-specified-exception", parameters);
        System.out.println(result);
        ExceptionSelectorTestCase.assertTrue((String)"Test if a non specified exception is not selected", (!result ? 1 : 0) != 0);
    }

    public void testExceptionSelectUnknownException() throws Exception {
        IllegalArgumentException iae = new IllegalArgumentException("ExceptionSelectorTestCase");
        Map objectModel = this.getObjectModel();
        objectModel.put("throwable", iae);
        Parameters parameters = new Parameters();
        boolean result = this.select(EXCEPTION_SELECTOR, "npe", parameters);
        System.out.println(result);
        ExceptionSelectorTestCase.assertTrue((String)"Test if a npe is not selected selected", (!result ? 1 : 0) != 0);
    }

    public void testExceptionSelectProcessingException() throws Exception {
        NullPointerException npe = new NullPointerException("NullPointerExceptionSelectorTestCase");
        ProcessingException pe = new ProcessingException("ProcessingExceptionSelectorTestCase", (Throwable)npe);
        Map objectModel = this.getObjectModel();
        objectModel.put("throwable", pe);
        Parameters parameters = new Parameters();
        boolean result = this.select(EXCEPTION_SELECTOR, "npe", parameters);
        System.out.println(result);
        ExceptionSelectorTestCase.assertTrue((String)"Test if a npe is selected", (boolean)result);
        result = this.select(EXCEPTION_SELECTOR, "pe", parameters);
        System.out.println(result);
        ExceptionSelectorTestCase.assertTrue((String)"Test if a pe is not selected", (!result ? 1 : 0) != 0);
    }

    public void testExceptionSelectProcessingException2() throws Exception {
        IllegalArgumentException iae = new IllegalArgumentException("ExceptionSelectorTestCase");
        ProcessingException pe = new ProcessingException("ProcessingExceptionSelectorTestCase", (Throwable)iae);
        Map objectModel = this.getObjectModel();
        objectModel.put("throwable", pe);
        Parameters parameters = new Parameters();
        boolean result = this.select(EXCEPTION_SELECTOR, "pe", parameters);
        System.out.println(result);
        ExceptionSelectorTestCase.assertTrue((String)"Test if a pe is not selected", (boolean)result);
    }
}

