/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.selection;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.SitemapComponentTestCase;

public class HostSelectorTestCase
extends SitemapComponentTestCase {
    private static final String HOST_SELECTOR = "host";

    public static void main(String[] args) {
        TestRunner.run((Test)HostSelectorTestCase.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(HostSelectorTestCase.class);
        return suite;
    }

    public void testHostSelectEurope() throws Exception {
        String host = "myhost-dns-name-in-a-europe-country";
        this.getRequest().setHeader("Host", "myhost-dns-name-in-a-europe-country");
        Parameters parameters = new Parameters();
        String expectedHostName = "myhost-eu";
        boolean result = this.select(HOST_SELECTOR, expectedHostName, parameters);
        System.out.println(result);
        HostSelectorTestCase.assertTrue((String)("Test if host is " + expectedHostName), (boolean)result);
        expectedHostName = "myhost-us";
        result = this.select(HOST_SELECTOR, expectedHostName, parameters);
        System.out.println(result);
        HostSelectorTestCase.assertTrue((String)("Test if host is not " + expectedHostName), (!result ? 1 : 0) != 0);
    }

    public void testHostSelectUnknownHost() throws Exception {
        String host = "myhost-dns-name-in-a-asia-country";
        this.getRequest().setHeader("Host", "myhost-dns-name-in-a-asia-country");
        Parameters parameters = new Parameters();
        String expectedHostName = "myhost-eu";
        boolean result = this.select(HOST_SELECTOR, expectedHostName, parameters);
        System.out.println(result);
        HostSelectorTestCase.assertTrue((String)("Test if host is not " + expectedHostName), (!result ? 1 : 0) != 0);
        expectedHostName = "myhost-us";
        result = this.select(HOST_SELECTOR, expectedHostName, parameters);
        System.out.println(result);
        HostSelectorTestCase.assertTrue((String)("Test if host is not " + expectedHostName), (!result ? 1 : 0) != 0);
    }
}

