/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.selection;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.SitemapComponentTestCase;
import org.apache.cocoon.environment.Session;

public class SessionAttributeSelectorTestCase
extends SitemapComponentTestCase {
    public static void main(String[] args) {
        TestRunner.run((Test)SessionAttributeSelectorTestCase.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(SessionAttributeSelectorTestCase.class);
        return suite;
    }

    public void testSessionAttributeSelect() throws Exception {
        String attributeName = "sessionAttributeSelector";
        String attributeValue = "sessionAttributeSelectorValue";
        Session session = this.getRequest().getSession(true);
        session.setAttribute("sessionAttributeSelector", (Object)"sessionAttributeSelectorValue");
        Parameters parameters = new Parameters();
        boolean result = this.select("session-attribute", "sessionAttributeSelectorValue", parameters);
        System.out.println(result);
        SessionAttributeSelectorTestCase.assertTrue((String)"Test if a session attribtue is selected", (boolean)result);
        result = this.select("session-attribute", "unknownValue", parameters);
        System.out.println(result);
        SessionAttributeSelectorTestCase.assertTrue((String)"Test if a session attribute is not selected", (!result ? 1 : 0) != 0);
    }

    public void testSessionAttributeSelectOverridden() throws Exception {
        String attributeName = "sessionAttributeSelector1";
        String attributeValue = "sessionAttributeSelectorValue1";
        Session session = this.getRequest().getSession(true);
        session.setAttribute("sessionAttributeSelector1", (Object)"sessionAttributeSelectorValue1");
        String attributeNameOverridden = "sessionAttributeSelector";
        String attributeValueOverridden = "sessionAttributeSelectorValue";
        session.setAttribute("sessionAttributeSelector", (Object)"sessionAttributeSelectorValue");
        Parameters parameters = new Parameters();
        parameters.setParameter("attribute-name", "sessionAttributeSelector1");
        boolean result = this.select("session-attribute", "sessionAttributeSelectorValue1", parameters);
        System.out.println(result);
        SessionAttributeSelectorTestCase.assertTrue((String)"Test if a requst attribtue is selected", (boolean)result);
        result = this.select("session-attribute", "sessionAttributeSelectorValue", parameters);
        System.out.println(result);
        SessionAttributeSelectorTestCase.assertTrue((String)"Test if a session attribute is not selected", (!result ? 1 : 0) != 0);
    }

    public void testSessionAttributeSelectMissingSession() throws Exception {
        String attributeValue = "sessionAttributeSelectorValue";
        this.getRequest().clearSession();
        Parameters parameters = new Parameters();
        boolean result = this.select("session-attribute", "sessionAttributeSelectorValue", parameters);
        System.out.println(result);
        SessionAttributeSelectorTestCase.assertTrue((String)"Test if a session attribtue is not selected", (!result ? 1 : 0) != 0);
    }
}

