/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.WrapperComponentManager;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.Processor;
import org.apache.cocoon.SitemapComponentTestCase;
import org.apache.cocoon.components.CocoonComponentManager;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.mock.MockEnvironment;

public class XIncludeTransformerTestCase
extends SitemapComponentTestCase {
    public static void main(String[] args) {
        TestRunner.run((Test)XIncludeTransformerTestCase.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(XIncludeTransformerTestCase.class);
        return suite;
    }

    private void xincludeTest(String input, String result) throws Exception {
        Parameters parameters = new Parameters();
        String src = null;
        MockEnvironment env = new MockEnvironment(null);
        Processor processor = (Processor)this.lookup(Processor.ROLE);
        CocoonComponentManager.enterEnvironment((Environment)env, (ComponentManager)new WrapperComponentManager(this.getManager()), (Processor)processor);
        this.assertEqual(this.load(result), this.transform("xinclude", src, parameters, this.load(input)));
        CocoonComponentManager.leaveEnvironment();
    }

    public void testXInclude1() throws Exception {
        this.getLogger().debug("testXInclude1");
        this.xincludeTest("resource://org/apache/cocoon/transformation/xinclude-input-1.xml", "resource://org/apache/cocoon/transformation/xinclude-result-1.xml");
    }

    public void testXInclude2() throws Exception {
        this.getLogger().debug("testXInclude2");
        this.xincludeTest("resource://org/apache/cocoon/transformation/xinclude-input-2.xml", "resource://org/apache/cocoon/transformation/xinclude-result-2.xml");
    }

    public void testXIncludeSimpleFallback() throws Exception {
        this.getLogger().debug("testXIncludeSimpleFallback");
        this.xincludeTest("resource://org/apache/cocoon/transformation/xinclude-input-fallbackTest.xml", "resource://org/apache/cocoon/transformation/xinclude-result-fallbackTest.xml");
    }

    public void testXIncludeNestedXincludeElementInAFallback() throws Exception {
        this.getLogger().debug("testXIncludeNestedXincludeElementInAFallback");
        this.xincludeTest("resource://org/apache/cocoon/transformation/xinclude-input-nestedXincludeFallbackTest.xml", "resource://org/apache/cocoon/transformation/xinclude-result-1.xml");
    }

    public void testXIncludeMultipleNestedFallback() throws Exception {
        this.getLogger().debug("testXIncludeMultipleNestedFallback");
        this.xincludeTest("resource://org/apache/cocoon/transformation/xinclude-input-multipleNestedFallbackTest.xml", "resource://org/apache/cocoon/transformation/xinclude-result-fallbackTest.xml");
    }

    public void testXIncludeSimpleFallbackForTextParse() throws Exception {
        this.getLogger().debug("testXIncludeSimpleFallbackForTextParse");
        this.xincludeTest("resource://org/apache/cocoon/transformation/xinclude-input-simpleFallbackForTextParseTest.xml", "resource://org/apache/cocoon/transformation/xinclude-result-fallbackTest.xml");
    }
}

