/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.util;

import java.util.Map;
import junit.framework.TestCase;
import org.apache.cocoon.util.WildcardMatcherHelper;

public class WildcardMatcherHelperTestCase
extends TestCase {
    public void test01WildcardURIMatch() throws Exception {
        Map result = WildcardMatcherHelper.match((String)"test", (String)"test");
        WildcardMatcherHelperTestCase.assertNotNull((Object)result);
        WildcardMatcherHelperTestCase.assertEquals((Object)"test", result.get("0"));
        WildcardMatcherHelperTestCase.assertNull(result.get("1"));
    }

    public void test02WildcardURIMatch() throws Exception {
        Map result = WildcardMatcherHelper.match((String)"end", (String)"enp");
        WildcardMatcherHelperTestCase.assertNull((Object)result);
    }

    public void test03WildcardURIMatch() throws Exception {
        Map result = WildcardMatcherHelper.match((String)"/t\\*d", (String)"/t*d");
        WildcardMatcherHelperTestCase.assertNotNull((Object)result);
        WildcardMatcherHelperTestCase.assertEquals((Object)"/t*d", result.get("0"));
    }

    public void test04WildcardURIMatch() throws Exception {
        Map result = WildcardMatcherHelper.match((String)"\\*d", (String)"*d");
        WildcardMatcherHelperTestCase.assertNotNull((Object)result);
        WildcardMatcherHelperTestCase.assertEquals((Object)"*d", result.get("0"));
    }

    public void test05WildcardURIMatch() throws Exception {
        Map result = WildcardMatcherHelper.match((String)"**", (String)"*d");
        WildcardMatcherHelperTestCase.assertNotNull((Object)result);
        WildcardMatcherHelperTestCase.assertEquals((Object)"*d", result.get("0"));
        WildcardMatcherHelperTestCase.assertEquals((Object)"*d", result.get("1"));
    }

    public void test06WildcardURIMatch() throws Exception {
        Map result = WildcardMatcherHelper.match((String)"foo**", (String)"foo*d");
        WildcardMatcherHelperTestCase.assertNotNull((Object)result);
        WildcardMatcherHelperTestCase.assertEquals((Object)"foo*d", result.get("0"));
        WildcardMatcherHelperTestCase.assertEquals((Object)"*d", result.get("1"));
    }

    public void test07WildcardURIMatch() throws Exception {
        Map result = WildcardMatcherHelper.match((String)"end", (String)"en");
        WildcardMatcherHelperTestCase.assertNull((Object)result);
    }

    public void test08WildcardURIMatch() throws Exception {
        Map result = WildcardMatcherHelper.match((String)"en", (String)"end");
        WildcardMatcherHelperTestCase.assertNull((Object)result);
    }

    public void test09WildcardURIMatch() throws Exception {
        Map result = WildcardMatcherHelper.match((String)"end**", (String)"end");
        WildcardMatcherHelperTestCase.assertNotNull((Object)result);
        WildcardMatcherHelperTestCase.assertEquals((Object)"", result.get("1"));
    }

    public void test10WildcardURIMatch() throws Exception {
        Map result = WildcardMatcherHelper.match((String)"end**end", (String)"endendend");
        WildcardMatcherHelperTestCase.assertNotNull((Object)result);
        WildcardMatcherHelperTestCase.assertEquals((Object)"end", result.get("1"));
    }

    public void test11WildcardURIMatch() throws Exception {
        Map result = WildcardMatcherHelper.match((String)"end**end", (String)"endxxend");
        WildcardMatcherHelperTestCase.assertNotNull((Object)result);
        WildcardMatcherHelperTestCase.assertEquals((Object)"xx", result.get("1"));
    }

    public void test12WildcardURIMatch() throws Exception {
        Map result = WildcardMatcherHelper.match((String)"*/end", (String)"xx/end");
        WildcardMatcherHelperTestCase.assertNotNull((Object)result);
        WildcardMatcherHelperTestCase.assertEquals((Object)"xx", result.get("1"));
    }

    public void test13WildcardURIMatch() throws Exception {
        Map result = WildcardMatcherHelper.match((String)"ab/cd*/end", (String)"ab/cdxx/end");
        WildcardMatcherHelperTestCase.assertNotNull((Object)result);
        WildcardMatcherHelperTestCase.assertEquals((Object)"xx", result.get("1"));
    }

    public void test14WildcardURIMatch() throws Exception {
        Map result = WildcardMatcherHelper.match((String)"a*/cd*/end", (String)"ab/cdxx/end");
        WildcardMatcherHelperTestCase.assertNotNull((Object)result);
        WildcardMatcherHelperTestCase.assertEquals((Object)"b", result.get("1"));
        WildcardMatcherHelperTestCase.assertEquals((Object)"xx", result.get("2"));
    }

    public void test15WildcardURIMatch() throws Exception {
        Map result = WildcardMatcherHelper.match((String)"a**/cd*/end", (String)"ab/yy/cdxx/end");
        WildcardMatcherHelperTestCase.assertNotNull((Object)result);
        WildcardMatcherHelperTestCase.assertEquals((Object)"b/yy", result.get("1"));
        WildcardMatcherHelperTestCase.assertEquals((Object)"xx", result.get("2"));
    }

    public void test16WildcardURIMatch() throws Exception {
        Map result = WildcardMatcherHelper.match((String)"a**/cd*/end/*", (String)"ab/yy/cdxx/end/foobar/ii");
        WildcardMatcherHelperTestCase.assertNull((Object)result);
    }

    public void test17WildcardURIMatch() throws Exception {
        Map result = WildcardMatcherHelper.match((String)"a**/cd*/end/**", (String)"ab/yy/cdxx/end/foobar/ii");
        WildcardMatcherHelperTestCase.assertNotNull((Object)result);
        WildcardMatcherHelperTestCase.assertEquals((Object)"b/yy", result.get("1"));
        WildcardMatcherHelperTestCase.assertEquals((Object)"xx", result.get("2"));
        WildcardMatcherHelperTestCase.assertEquals((Object)"foobar/ii", result.get("3"));
    }

    public void test18WildcardURIMatch() throws Exception {
        Map result = WildcardMatcherHelper.match((String)"a**cd*/end/**", (String)"ab/yy/cdxx/end/foobar/ii");
        WildcardMatcherHelperTestCase.assertNotNull((Object)result);
        WildcardMatcherHelperTestCase.assertEquals((Object)"b/yy/", result.get("1"));
        WildcardMatcherHelperTestCase.assertEquals((Object)"xx", result.get("2"));
        WildcardMatcherHelperTestCase.assertEquals((Object)"foobar/ii", result.get("3"));
    }

    public void test19WildcardURIMatch() throws Exception {
        Map result = WildcardMatcherHelper.match((String)"*/*.xml", (String)"test/something.xmlbla.xml");
        WildcardMatcherHelperTestCase.assertNotNull((Object)result);
        WildcardMatcherHelperTestCase.assertEquals((Object)"test", result.get("1"));
        WildcardMatcherHelperTestCase.assertEquals((Object)"something.xmlbla", result.get("2"));
    }

    public void test20WildcardURIMatch() throws Exception {
        Map result = WildcardMatcherHelper.match((String)"ab/cd*/end", (String)"ab/cd/end");
        WildcardMatcherHelperTestCase.assertNotNull((Object)result);
        WildcardMatcherHelperTestCase.assertEquals((Object)"", result.get("1"));
    }

    public void test21WildcardURIMatch() throws Exception {
        Map result = WildcardMatcherHelper.match((String)"*/**", (String)"samples/blocks/");
        WildcardMatcherHelperTestCase.assertNotNull((Object)result);
        WildcardMatcherHelperTestCase.assertEquals((Object)"samples", result.get("1"));
        WildcardMatcherHelperTestCase.assertEquals((Object)"blocks/", result.get("2"));
    }

    public void test22WildcardURIMatch() throws Exception {
        Map result = WildcardMatcherHelper.match((String)"*/**", (String)"samples/");
        WildcardMatcherHelperTestCase.assertNotNull((Object)result);
        WildcardMatcherHelperTestCase.assertEquals((Object)"samples", result.get("1"));
        WildcardMatcherHelperTestCase.assertEquals((Object)"", result.get("2"));
    }

    public void test23WildcardURIMatch() throws Exception {
        Map result = WildcardMatcherHelper.match((String)"**favicon.ico", (String)"samples/");
        WildcardMatcherHelperTestCase.assertNull((Object)result);
    }

    public void test24WildcardURIMatch() throws Exception {
        Map result = WildcardMatcherHelper.match((String)"**favicon.ico", (String)"samples1234/");
        WildcardMatcherHelperTestCase.assertNull((Object)result);
    }

    public void test25WildcardURIMatch() throws Exception {
        Map result = WildcardMatcherHelper.match((String)"**favicon.ico", (String)"samples123/");
        WildcardMatcherHelperTestCase.assertNull((Object)result);
    }

    public void test26WildcardURIMatch() throws Exception {
        Map result = WildcardMatcherHelper.match((String)"**/*/**", (String)"foo/bar/baz/bug");
        WildcardMatcherHelperTestCase.assertNotNull((Object)result);
        WildcardMatcherHelperTestCase.assertEquals((Object)"foo/bar", result.get("1"));
        WildcardMatcherHelperTestCase.assertEquals((Object)"baz", result.get("2"));
        WildcardMatcherHelperTestCase.assertEquals((Object)"bug", result.get("3"));
    }

    public void test27WildcardURIMatch() throws Exception {
        Map result = WildcardMatcherHelper.match((String)"end*end*end*end", (String)"endXXendYendend");
        WildcardMatcherHelperTestCase.assertNotNull((Object)result);
        WildcardMatcherHelperTestCase.assertEquals((Object)"XX", result.get("1"));
        WildcardMatcherHelperTestCase.assertEquals((Object)"Y", result.get("2"));
        WildcardMatcherHelperTestCase.assertEquals((Object)"", result.get("3"));
    }

    public void test28WildcardURIMatch() throws Exception {
        Map result = WildcardMatcherHelper.match((String)"end*end*end*end", (String)"endendendend");
        WildcardMatcherHelperTestCase.assertNotNull((Object)result);
        WildcardMatcherHelperTestCase.assertEquals((Object)"", result.get("1"));
        WildcardMatcherHelperTestCase.assertEquals((Object)"", result.get("2"));
        WildcardMatcherHelperTestCase.assertEquals((Object)"", result.get("3"));
    }

    public void test29WildcardURIMatch() throws Exception {
        Map result = WildcardMatcherHelper.match((String)"end**end**end**end", (String)"endXXendYendend");
        WildcardMatcherHelperTestCase.assertNotNull((Object)result);
        WildcardMatcherHelperTestCase.assertEquals((Object)"XX", result.get("1"));
        WildcardMatcherHelperTestCase.assertEquals((Object)"Y", result.get("2"));
        WildcardMatcherHelperTestCase.assertEquals((Object)"", result.get("3"));
    }

    public void test30WildcardURIMatch() throws Exception {
        Map result = WildcardMatcherHelper.match((String)"end**end**end**end", (String)"endendendend");
        WildcardMatcherHelperTestCase.assertNotNull((Object)result);
        WildcardMatcherHelperTestCase.assertEquals((Object)"", result.get("1"));
        WildcardMatcherHelperTestCase.assertEquals((Object)"", result.get("2"));
        WildcardMatcherHelperTestCase.assertEquals((Object)"", result.get("3"));
    }

    public void test31WildcardURIMatch() throws Exception {
        Map result = WildcardMatcherHelper.match((String)"*/", (String)"test/foo/bar");
        WildcardMatcherHelperTestCase.assertNull((Object)result);
    }

    public void test32WildcardURIMatch() throws Exception {
        Map result = WildcardMatcherHelper.match((String)"**/*.html", (String)"foo/bar/baz.html");
        WildcardMatcherHelperTestCase.assertNotNull((Object)result);
        WildcardMatcherHelperTestCase.assertEquals((Object)"baz", result.get("2"));
        WildcardMatcherHelperTestCase.assertEquals((Object)"foo/bar", result.get("1"));
    }

    public void test33WildcardURIMatch() throws Exception {
        Map result = WildcardMatcherHelper.match((String)"*.html", (String)"menu/baz.html");
        WildcardMatcherHelperTestCase.assertNull((Object)result);
    }

    public void test34WildcardURIMatch() throws Exception {
        Map result = WildcardMatcherHelper.match((String)"*.html", (String)"baz.html");
        WildcardMatcherHelperTestCase.assertNotNull((Object)result);
        WildcardMatcherHelperTestCase.assertEquals((Object)"baz", result.get("1"));
    }

    public void test35WildcardURIMatch() throws Exception {
        Map result = WildcardMatcherHelper.match((String)"menu/**/foo_*_bar.*", (String)"menu//foo_baz_bar.html");
        WildcardMatcherHelperTestCase.assertNotNull((Object)result);
        WildcardMatcherHelperTestCase.assertEquals((Object)"", result.get("1"));
        WildcardMatcherHelperTestCase.assertEquals((Object)"baz", result.get("2"));
        WildcardMatcherHelperTestCase.assertEquals((Object)"html", result.get("3"));
    }

    public void test36WildcardURIMatch() throws Exception {
        Map result = WildcardMatcherHelper.match((String)"menu/**/foo/*", (String)"menu/bar/baz.xml");
        WildcardMatcherHelperTestCase.assertNull((Object)result);
    }

    public void test37WildcardURIMatch() throws Exception {
        Map result = WildcardMatcherHelper.match((String)"menu/*.xml", (String)"menu/foo/bar.xml");
        WildcardMatcherHelperTestCase.assertNull((Object)result);
    }

    public void test38WildcardURIMatch() throws Exception {
        Map result = WildcardMatcherHelper.match((String)"\\\\foo\\*\\n\\0\\", (String)"\\foo*\\n\\0\\");
        WildcardMatcherHelperTestCase.assertNotNull((Object)result);
    }

    public void testEmptyPattern() throws Exception {
        WildcardMatcherHelperTestCase.assertNotNull((Object)WildcardMatcherHelper.match((String)"", (String)""));
        WildcardMatcherHelperTestCase.assertNull((Object)WildcardMatcherHelper.match((String)"", (String)"foo"));
        WildcardMatcherHelperTestCase.assertNull((Object)WildcardMatcherHelper.match((String)"", (String)"foo/bar"));
    }

    public void testEndPattern() throws Exception {
        WildcardMatcherHelperTestCase.assertNotNull((Object)WildcardMatcherHelper.match((String)"*/", (String)"foo/"));
        WildcardMatcherHelperTestCase.assertNull((Object)WildcardMatcherHelper.match((String)"*/", (String)"foo/bar/"));
        WildcardMatcherHelperTestCase.assertNull((Object)WildcardMatcherHelper.match((String)"*/", (String)"test/foo/bar/"));
    }
}

