/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.util.location;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.TestCase;
import org.apache.cocoon.util.location.Location;
import org.apache.cocoon.util.location.LocationImpl;
import org.apache.cocoon.util.location.LocationUtils;

public class LocationTestCase
extends TestCase {
    static final String str = "path/to/file.xml:1:40";

    public LocationTestCase(String name) {
        super(name);
    }

    public void testParse() throws Exception {
        String str = "<map:generate> - path/to/file.xml:1:40";
        LocationImpl loc = LocationUtils.parse((String)str);
        LocationTestCase.assertEquals((String)"<map:generate>", (String)loc.getDescription());
        LocationTestCase.assertEquals((String)"URI", (String)"path/to/file.xml", (String)loc.getURI());
        LocationTestCase.assertEquals((String)"line", (int)1, (int)loc.getLineNumber());
        LocationTestCase.assertEquals((String)"column", (int)40, (int)loc.getColumnNumber());
        LocationTestCase.assertEquals((String)"string representation", (String)str, (String)loc.toString());
    }

    public void testEquals() throws Exception {
        LocationImpl loc1 = LocationUtils.parse((String)str);
        LocationImpl loc2 = new LocationImpl(null, "path/to/file.xml", 1, 40);
        LocationTestCase.assertEquals((String)"locations", (Object)loc1, (Object)loc2);
        LocationTestCase.assertEquals((String)"hashcode", (int)loc1.hashCode(), (int)loc2.hashCode());
        LocationTestCase.assertEquals((String)"string representation", (String)loc1.toString(), (String)loc2.toString());
    }

    public void testSerializeUnknown() throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(Location.UNKNOWN);
        oos.close();
        bos.close();
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bis);
        Object obj = ois.readObject();
        LocationTestCase.assertSame((String)"unknown location", (Object)Location.UNKNOWN, (Object)obj);
    }
}

