/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.util.test;

import junit.framework.TestCase;
import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.util.Deprecation;
import org.apache.cocoon.util.DeprecationException;

public class DeprecationTestCase
extends TestCase {
    private Logger originalLogger;
    private Logger consoleLogger;

    public DeprecationTestCase(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.originalLogger = Deprecation.logger;
        this.consoleLogger = new ConsoleLogger(5);
        Deprecation.setLogger((Logger)this.consoleLogger);
        Deprecation.setForbiddenLevel((Deprecation.LogLevel)Deprecation.ERROR);
    }

    public void tearDown() throws Exception {
        Deprecation.setLogger((Logger)this.originalLogger);
        super.tearDown();
    }

    public void testPrecond() {
        DeprecationTestCase.assertFalse((boolean)this.consoleLogger.isInfoEnabled());
        DeprecationTestCase.assertFalse((boolean)this.consoleLogger.isWarnEnabled());
        DeprecationTestCase.assertFalse((boolean)this.consoleLogger.isErrorEnabled());
    }

    public void testInfoOk() {
        try {
            Deprecation.logger.info("testing deprecation logs");
        }
        catch (DeprecationException de) {
            DeprecationTestCase.fail((String)"Should not throw an exception");
        }
    }

    public void testWarnOk() {
        try {
            Deprecation.logger.warn("testing deprecation logs");
        }
        catch (DeprecationException de) {
            DeprecationTestCase.fail((String)"Should not throw an exception");
        }
    }

    public void testErrorFails() {
        try {
            Deprecation.logger.error("testing deprecation logs");
        }
        catch (DeprecationException de) {
            return;
        }
        DeprecationTestCase.fail((String)"Should throw an exception");
    }

    public void testDebugFails() {
        Deprecation.setForbiddenLevel((Deprecation.LogLevel)Deprecation.DEBUG);
        try {
            Deprecation.logger.debug("testing deprecation logs");
        }
        catch (DeprecationException de) {
            return;
        }
        DeprecationTestCase.fail((String)"Should throw an exception");
    }

    public void testInfoDisabled() {
        DeprecationTestCase.assertFalse((boolean)Deprecation.logger.isInfoEnabled());
    }

    public void testWarnDisabled() {
        DeprecationTestCase.assertFalse((boolean)Deprecation.logger.isWarnEnabled());
    }

    public void testErrorEnabled() {
        DeprecationTestCase.assertTrue((boolean)Deprecation.logger.isErrorEnabled());
    }
}

