/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.util.test;

import java.io.File;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.cocoon.util.IOUtils;

public class IOUtilsTestCase
extends TestCase {
    public IOUtilsTestCase(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)IOUtilsTestCase.class);
    }

    public void testNormalizedFilename() throws Exception {
        Object[] test_values = new Object[]{new String[]{".", "__"}, new String[]{"", ""}, new String[]{"file://", "file_"}, new String[]{"/a/b/c", "a" + File.separator + "b" + File.separator + "c"}, new String[]{"\\a\\b\\c", "a" + File.separator + "b" + File.separator + "c"}, new String[]{"a/b/c", "a" + File.separator + "b" + File.separator + "c"}, new String[]{"a\\b\\c", "a" + File.separator + "b" + File.separator + "c"}, new String[]{"a/b/../c", "a" + File.separator + "c"}, new String[]{"public/final.xml", "public_" + File.separator + "final_xml"}, new String[]{"123", "_123"}};
        for (int i = 0; i < test_values.length; ++i) {
            String[] tests = (String[])test_values[i];
            String test = tests[0];
            String expected = tests[1];
            String result = IOUtils.normalizedFilename((String)test);
            String message = "Test '" + test + "'";
            IOUtilsTestCase.assertEquals((String)message, (String)expected, (String)result);
        }
    }

    public void testGetContextFilePath() throws Exception {
        Object[] test_values = new Object[]{new String[]{"a", "a" + File.separator + "b", "b"}, new String[]{"a\\b", "a\\b" + File.separator + "c/d", "c" + File.separator + "d"}, new String[]{"a/b", "a/b" + File.separator + "c\\d", "c" + File.separator + "d"}};
        for (int i = 0; i < test_values.length; ++i) {
            String[] tests = (String[])test_values[i];
            String test_directory_path = tests[0];
            String test_file_path = tests[1];
            String expected = tests[2];
            String result = IOUtils.getContextFilePath((String)test_directory_path, (String)test_file_path);
            String message = "Test '" + test_directory_path + "'" + ", " + "'" + test_file_path + "'";
            IOUtilsTestCase.assertEquals((String)message, (String)expected, (String)result);
        }
    }

    public void testObjectToBytesBytesToObject() throws Exception {
        String test = "test";
        String expected = "test";
        String message = "Test '" + test + "'";
        byte[] bytes = IOUtils.objectToBytes((Object)test);
        String result = (String)IOUtils.bytesToObject((byte[])bytes);
        IOUtilsTestCase.assertEquals((String)message, (String)expected, (String)result);
    }
}

