/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.util.test;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.cocoon.util.MIMEUtils;
import org.apache.commons.lang.SystemUtils;

public class MIMEUtilsTestCase
extends TestCase {
    final String NL = SystemUtils.LINE_SEPARATOR;
    Map mimeMap;
    Map extMap;
    static final String M2E = "MIME to extension mappings";
    static final String E2M = "Extension to MIME mappings";

    public MIMEUtilsTestCase(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)MIMEUtilsTestCase.class);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.mimeMap = new HashMap();
        this.extMap = new HashMap();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.mimeMap = null;
        this.extMap = null;
    }

    public void tstGetMimeType() {
        MIMEUtilsTestCase.assertEquals((String)E2M, (String)"text/plain", (String)MIMEUtils.getMIMEType((String)".txt"));
        MIMEUtilsTestCase.assertEquals((String)E2M, (String)"image/jpeg", (String)MIMEUtils.getMIMEType((String)".jpg"));
        MIMEUtilsTestCase.assertEquals((String)E2M, (String)"video/mpeg", (String)MIMEUtils.getMIMEType((String)".mpg"));
        MIMEUtilsTestCase.assertEquals((String)E2M, null, (String)MIMEUtils.getMIMEType((String)".undefined"));
        MIMEUtilsTestCase.assertEquals((String)M2E, (String)".txt", (String)MIMEUtils.getDefaultExtension((String)"text/plain"));
        MIMEUtilsTestCase.assertEquals((String)M2E, (String)".jpeg", (String)MIMEUtils.getDefaultExtension((String)"image/jpeg"));
        MIMEUtilsTestCase.assertEquals((String)M2E, (String)".mpeg", (String)MIMEUtils.getDefaultExtension((String)"video/mpeg"));
        MIMEUtilsTestCase.assertEquals((String)M2E, null, (String)MIMEUtils.getDefaultExtension((String)"application/octet-stream"));
    }

    public void testTypicalUsage() throws Exception {
        String mime_types = "# MIME type mappings" + this.NL + "text/plain  txt text " + this.NL + "text/html   html htm" + this.NL + "   " + this.NL + "text/xml    xml" + this.NL + "text/css    css" + this.NL + "text/javascript\t\tjs " + this.NL + "application/x-javascript\tjs";
        MIMEUtils.loadMimeTypes((Reader)new StringReader(mime_types), (Map)this.extMap, (Map)this.mimeMap);
        MIMEUtilsTestCase.assertEquals((Object)".txt", this.extMap.get("text/plain"));
        MIMEUtilsTestCase.assertEquals((Object)".html", this.extMap.get("text/html"));
        MIMEUtilsTestCase.assertEquals((Object)".xml", this.extMap.get("text/xml"));
        MIMEUtilsTestCase.assertEquals((Object)".css", this.extMap.get("text/css"));
        MIMEUtilsTestCase.assertEquals((Object)".js", this.extMap.get("text/javascript"));
        MIMEUtilsTestCase.assertEquals((Object)".js", this.extMap.get("application/x-javascript"));
        MIMEUtilsTestCase.assertEquals((Object)"text/plain", this.mimeMap.get(".text"));
        MIMEUtilsTestCase.assertEquals((Object)"text/plain", this.mimeMap.get(".txt"));
        MIMEUtilsTestCase.assertEquals((Object)"text/html", this.mimeMap.get(".html"));
        MIMEUtilsTestCase.assertEquals((Object)"text/html", this.mimeMap.get(".htm"));
        MIMEUtilsTestCase.assertEquals((Object)"text/xml", this.mimeMap.get(".xml"));
        MIMEUtilsTestCase.assertEquals((Object)"text/css", this.mimeMap.get(".css"));
        MIMEUtilsTestCase.assertEquals((Object)"text/javascript", this.mimeMap.get(".js"));
        MIMEUtilsTestCase.assertEquals((String)M2E, (int)6, (int)this.extMap.size());
        MIMEUtilsTestCase.assertEquals((String)E2M, (int)7, (int)this.mimeMap.size());
    }

    public void tstEmpty() throws Exception {
        String mime_types = "";
        MIMEUtils.loadMimeTypes((Reader)new StringReader(mime_types), (Map)this.extMap, (Map)this.mimeMap);
        MIMEUtilsTestCase.assertEquals((String)M2E, (int)0, (int)this.extMap.size());
        MIMEUtilsTestCase.assertEquals((String)E2M, (int)0, (int)this.mimeMap.size());
    }

    public void tstCommentsAndWhitespace() throws Exception {
        String mime_types = "## A commented line" + this.NL + "   " + this.NL + "# Another comment";
        MIMEUtils.loadMimeTypes((Reader)new StringReader(mime_types), (Map)this.extMap, (Map)this.mimeMap);
        MIMEUtilsTestCase.assertEquals((String)M2E, (int)0, (int)this.extMap.size());
        MIMEUtilsTestCase.assertEquals((String)E2M, (int)0, (int)this.mimeMap.size());
    }

    public void tstMimeTypeWithoutExtension() throws Exception {
        String mime_types = "text/plain  txt text" + this.NL + "application/octet-stream" + this.NL + this.NL;
        MIMEUtils.loadMimeTypes((Reader)new StringReader(mime_types), (Map)this.extMap, (Map)this.mimeMap);
        MIMEUtilsTestCase.assertEquals((Object)".txt", this.extMap.get("text/plain"));
        MIMEUtilsTestCase.assertEquals((Object)"text/plain", this.mimeMap.get(".txt"));
        MIMEUtilsTestCase.assertEquals((Object)"text/plain", this.mimeMap.get(".text"));
        MIMEUtilsTestCase.assertEquals((String)M2E, (int)1, (int)this.extMap.size());
        MIMEUtilsTestCase.assertEquals((String)E2M, (int)2, (int)this.mimeMap.size());
    }
}

