/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.util.test;

import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.cocoon.util.NetUtils;

public class NetUtilsTestCase
extends TestCase {
    public NetUtilsTestCase(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)NetUtilsTestCase.class);
    }

    public void testGetPath() throws Exception {
        Object[] test_values = new Object[]{new String[]{"", ""}, new String[]{"/", ""}, new String[]{"/foo.bar", ""}, new String[]{"foo/bar", "foo"}, new String[]{"/foo/bar", "/foo"}};
        for (int i = 0; i < test_values.length; ++i) {
            String[] tests = (String[])test_values[i];
            String test = tests[0];
            String expected = tests[1];
            String result = NetUtils.getPath((String)test);
            String message = "Test '" + test + "'";
            NetUtilsTestCase.assertEquals((String)message, (String)expected, (String)result);
        }
    }

    public void testGetExtension() throws Exception {
        Object[] test_values = new Object[]{new String[]{"/foo.bar", ".bar"}, new String[]{"foo.bar#a", ".bar"}, new String[]{"foo.bar?b=c", ".bar"}, new String[]{"foo.bar#a?b=c", ".bar"}, new String[]{"foo.bar", ".bar"}, new String[]{"foo/bar", null}, new String[]{"/x.html", ".html"}, new String[]{"/foo.bar.org/x.y.z.html", ".html"}};
        for (int i = 0; i < test_values.length; ++i) {
            String[] tests = (String[])test_values[i];
            String test = tests[0];
            String expected = tests[1];
            String result = NetUtils.getExtension((String)test);
            String message = "Test '" + test + "'";
            NetUtilsTestCase.assertEquals((String)message, (String)expected, (String)result);
        }
    }

    public void testAbsolutize() throws Exception {
        Object[] test_values = new Object[]{new String[]{"/base/path", "foo.bar", "/base/path/foo.bar"}, new String[]{"/base/path/", "foo.bar", "/base/path/foo.bar"}, new String[]{"/base/path", "/foo.bar", "/foo.bar"}, new String[]{"/base/path", "", "/base/path"}, new String[]{"/base/path", null, "/base/path"}, new String[]{"", "foo.bar", "foo.bar"}, new String[]{null, "foo.bar", "foo.bar"}};
        for (int i = 0; i < test_values.length; ++i) {
            String[] tests = (String[])test_values[i];
            String test_path = tests[0];
            String test_rel_resource = tests[1];
            String expected = tests[2];
            String result = NetUtils.absolutize((String)test_path, (String)test_rel_resource);
            String message = "Test  path '" + test_path + "'" + " relativeResource " + "'" + test_rel_resource;
            NetUtilsTestCase.assertEquals((String)message, (String)expected, (String)result);
        }
    }

    public void testEncodePath() throws Exception {
        Object[] test_values = new Object[]{new String[]{"abc def", "abc%20def"}, new String[]{"foo/bar?n=v&N=V", "foo/bar%3Fn=v&N=V"}};
        for (int i = 0; i < test_values.length; ++i) {
            String[] tests = (String[])test_values[i];
            String original = tests[0];
            String expected = tests[1];
            String result = NetUtils.encodePath((String)original);
            String message = "Test  original '" + original + "'";
            NetUtilsTestCase.assertEquals((String)message, (String)expected, (String)result);
        }
    }

    public void testRelativize() throws Exception {
        Object[] test_values = new Object[]{new String[]{"/xml.apache.org", "/xml.apache.org/foo.bar", "foo.bar"}, new String[]{"/xml.apache.org", "/xml.apache.org/foo.bar", "foo.bar"}, new String[]{"/xml.apache.org", "/xml.apache.org/foo.bar", "foo.bar"}};
        for (int i = 0; i < test_values.length; ++i) {
            String[] tests = (String[])test_values[i];
            String test_path = tests[0];
            String test_abs_resource = tests[1];
            String expected = tests[2];
            String result = NetUtils.relativize((String)test_path, (String)test_abs_resource);
            String message = "Test  path '" + test_path + "'" + " absoluteResource " + "'" + test_abs_resource;
            NetUtilsTestCase.assertEquals((String)message, (String)expected, (String)result);
        }
    }

    public void testNormalize() throws Exception {
        Object[] test_values = new Object[]{new String[]{"", ""}, new String[]{"/", "/"}, new String[]{"/../", "/../"}, new String[]{"/../../", "/../../"}, new String[]{"/../../foo", "/../../foo"}, new String[]{"/../../foo//./../bar", "/../../bar"}, new String[]{"//foo//bar", "//foo/bar"}, new String[]{"//foo//./bar", "//foo/bar"}, new String[]{"/foo/bar", "/foo/bar"}, new String[]{"/foo/bar/", "/foo/bar/"}, new String[]{"/foo/../bar", "/bar"}, new String[]{"/foo/../bar/", "/bar/"}, new String[]{"bar", "bar"}, new String[]{"foo/../bar", "bar"}, new String[]{"foo/./bar", "foo/bar"}, new String[]{"foo/bar1/bar2/bar3/../../..", "foo/"}};
        for (int i = 0; i < test_values.length; ++i) {
            String[] tests = (String[])test_values[i];
            String test = tests[0];
            String expected = tests[1];
            String result = NetUtils.normalize((String)test);
            String message = "Test '" + test + "'";
            NetUtilsTestCase.assertEquals((String)message, (String)expected, (String)result);
        }
    }

    public void testDeparameterize() throws Exception {
        HashMap parameters = new HashMap();
        Object[] test_values = new Object[]{new String[]{"/foo/bar", "/foo/bar"}, new String[]{"bar?a=b&c=d", "bar"}};
        for (int i = 0; i < test_values.length; ++i) {
            String[] tests = (String[])test_values[i];
            String test = tests[0];
            String expected = tests[1];
            parameters.clear();
            String result = NetUtils.deparameterize((String)test, parameters);
            if (test.indexOf(63) > -1) {
                NetUtilsTestCase.assertTrue((parameters.size() > 0 ? 1 : 0) != 0);
            }
            String message = "Test '" + test + "'";
            NetUtilsTestCase.assertEquals((String)message, (String)expected, (String)result);
        }
    }

    public void testParameterize() throws Exception {
        String result;
        HashMap parameters1 = new HashMap();
        Object[] test_values = new Object[]{new Object[]{"/foo/bar", parameters1, "/foo/bar"}};
        for (int i = 0; i < test_values.length; ++i) {
            Object[] tests = (Object[])test_values[i];
            String test = (String)tests[0];
            Map parameters = (Map)tests[1];
            String expected = (String)tests[2];
            result = NetUtils.parameterize((String)test, (Map)parameters);
            String message = "Test '" + test + "'";
            NetUtilsTestCase.assertEquals((String)message, (String)expected, (String)result);
        }
        HashMap<String, String> parameters2 = new HashMap<String, String>();
        parameters2.put("a", "b");
        parameters2.put("c", "d");
        String test = "bar";
        String expected1 = "bar?a=b&c=d";
        String expected2 = "bar?c=d&a=b";
        String message = "Test '" + test + "'";
        result = NetUtils.parameterize((String)test, parameters2);
        if (expected1.equals(result)) {
            NetUtilsTestCase.assertEquals((String)message, (String)expected1, (String)result);
        } else {
            NetUtilsTestCase.assertEquals((String)message, (String)expected2, (String)result);
        }
    }
}

