/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.xml;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.cocoon.xml.NamespacesTable;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class NamespacesTableTestCase
extends TestCase {
    public NamespacesTableTestCase(String name) {
        super(name);
    }

    public void testSimple() {
        NamespacesTable ns = new NamespacesTable();
        ns.addDeclaration("ns1", "http://ns1");
        ns.addDeclaration("ns2", "http://ns2");
        ns.enterScope();
        NamespacesTableTestCase.assertEquals((String)"http://ns1", (String)ns.getUri("ns1"));
        NamespacesTableTestCase.assertEquals((String)"ns1", (String)ns.getPrefix("http://ns1"));
        NamespacesTableTestCase.assertEquals((String)"http://ns2", (String)ns.getUri("ns2"));
        NamespacesTableTestCase.assertEquals((String)"ns2", (String)ns.getPrefix("http://ns2"));
        ns.enterScope();
        ns.addDeclaration("ns3", "http://ns3");
        ns.enterScope();
        NamespacesTableTestCase.assertEquals((String)"ns1", (String)ns.getPrefix("http://ns1"));
        NamespacesTableTestCase.assertEquals((String)"ns3", (String)ns.getPrefix("http://ns3"));
        NamespacesTableTestCase.assertEquals((int)0, (int)ns.getCurrentScopeDeclarations().length);
        ns.leaveScope();
        NamespacesTableTestCase.assertNull((Object)ns.getUri("ns3"));
        NamespacesTableTestCase.assertEquals((int)1, (int)ns.getCurrentScopeDeclarations().length);
        NamespacesTableTestCase.assertEquals((String)"ns3", (String)ns.getCurrentScopeDeclarations()[0].getPrefix());
        ns.leaveScope();
        NamespacesTableTestCase.assertNull((Object)ns.getPrefix(ns.getPrefix("http://ns3")));
        NamespacesTableTestCase.assertNull((Object)ns.getUri("ns3"));
        ns.leaveScope();
        NamespacesTableTestCase.assertNull((Object)ns.getUri("ns1"));
        NamespacesTableTestCase.assertNull((Object)ns.getPrefix("http://ns1"));
        NamespacesTableTestCase.assertNull((Object)ns.getUri("ns2"));
        NamespacesTableTestCase.assertNull((Object)ns.getPrefix("http://ns2"));
        NamespacesTable.Declaration[] prefixes = ns.getCurrentScopeDeclarations();
        NamespacesTableTestCase.assertEquals((int)2, (int)prefixes.length);
        NamespacesTableTestCase.assertEquals((String)"ns2", (String)prefixes[0].getPrefix());
        NamespacesTableTestCase.assertEquals((String)"http://ns2", (String)prefixes[0].getUri());
        NamespacesTableTestCase.assertEquals((String)"ns1", (String)prefixes[1].getPrefix());
        NamespacesTableTestCase.assertEquals((String)"http://ns1", (String)prefixes[1].getUri());
    }

    public void testOverride() {
        NamespacesTable ns = new NamespacesTable();
        ns.addDeclaration("ns1", "http://ns1");
        ns.enterScope();
        ns.addDeclaration("ns1", "http://otherns1");
        ns.enterScope();
        ns.addDeclaration("ns1", "http://yetanotherns1");
        ns.enterScope();
        NamespacesTableTestCase.assertEquals((String)"http://yetanotherns1", (String)ns.getUri("ns1"));
        NamespacesTableTestCase.assertEquals((int)0, (int)ns.getPrefixes("http://ns1").length);
        ns.leaveScope();
        ns.leaveScope();
        NamespacesTableTestCase.assertEquals((String)"http://ns1", (String)ns.getUri("ns1"));
        NamespacesTableTestCase.assertEquals((int)1, (int)ns.getPrefixes("http://ns1").length);
        ns.leaveScope();
        NamespacesTableTestCase.assertNull((Object)ns.getUri("ns1"));
    }

    public void testMultiDeclaration() {
        NamespacesTable ns = new NamespacesTable();
        ns.addDeclaration("ns1", "http://ns1");
        ns.enterScope();
        ns.addDeclaration("ns2", "http://ns1");
        ns.addDeclaration("ns3", "http://ns1");
        ns.enterScope();
        String[] prefixes = ns.getPrefixes("http://ns1");
        NamespacesTableTestCase.assertEquals((int)3, (int)prefixes.length);
        NamespacesTableTestCase.assertEquals((String)"ns3", (String)prefixes[0]);
        NamespacesTableTestCase.assertEquals((String)"ns2", (String)prefixes[1]);
        NamespacesTableTestCase.assertEquals((String)"ns1", (String)prefixes[2]);
    }

    public void testStreamDeclarations() throws Exception {
        NamespacesTable ns = new NamespacesTable();
        ns.addDeclaration("ns1", "http://ns1");
        ns.enterScope();
        ns.addDeclaration("ns2", "http://ns2");
        ns.enterScope((ContentHandler)new DefaultHandler(){

            public void startPrefixMapping(String prefix, String uri) throws SAXException {
                Assert.assertEquals((String)"ns2", (String)prefix);
                Assert.assertEquals((String)"http://ns2", (String)uri);
            }
        });
        ns.addDeclaration("ns3", "http://ns3");
        ns.enterScope();
        ns.leaveScope();
        ns.leaveScope((ContentHandler)new DefaultHandler(){

            public void endPrefixMapping(String prefix) throws SAXException {
                Assert.assertEquals((String)"ns2", (String)prefix);
            }
        });
    }

    public void testJXImport() throws Exception {
        NamespacesTable ns = new NamespacesTable();
        DefaultHandler handler = new DefaultHandler();
        ns.addDeclaration("ft", "http://apache.org/cocoon/forms/1.0#template");
        ns.addDeclaration("fi", "http://apache.org/cocoon/forms/1.0#instance");
        ns.addDeclaration("jx", "http://apache.org/cocoon/templates/jx/1.0");
        ns.enterScope((ContentHandler)handler);
        NamespacesTableTestCase.assertEquals((String)"ft", (String)ns.getPrefix("http://apache.org/cocoon/forms/1.0#template"));
        NamespacesTableTestCase.assertEquals((String)"fi", (String)ns.getPrefix("http://apache.org/cocoon/forms/1.0#instance"));
        NamespacesTableTestCase.assertEquals((String)"jx", (String)ns.getPrefix("http://apache.org/cocoon/templates/jx/1.0"));
        ns.addDeclaration("jx", "http://apache.org/cocoon/templates/jx/1.0");
        ns.addDeclaration("fi", "http://apache.org/cocoon/forms/1.0#instance");
        ns.addDeclaration("bu", "http://apache.org/cocoon/browser-update/1.0");
        ns.leaveScope((ContentHandler)handler);
        NamespacesTableTestCase.assertNull((Object)ns.getPrefix("http://apache.org/cocoon/forms/1.0#template"));
        NamespacesTableTestCase.assertNull((Object)ns.getPrefix("http://apache.org/cocoon/forms/1.0#instance"));
        NamespacesTableTestCase.assertNull((Object)ns.getPrefix("http://apache.org/cocoon/templates/jx/1.0"));
        NamespacesTableTestCase.assertEquals((int)3, (int)ns.getCurrentScopeDeclarations().length);
    }

    public void testDuplicate() throws Exception {
        NamespacesTable ns = new NamespacesTable();
        ns.addDeclaration("ns1", "http://ns1");
        ns.enterScope();
        ns.addDeclaration("ns1", "http://ns1");
        ns.enterScope();
        ns.leaveScope();
        ns.removeDeclaration("ns1");
        NamespacesTableTestCase.assertEquals((String)"http://ns1", (String)ns.getUri("ns1"));
        ns.leaveScope();
        ns.removeDeclaration("ns1");
        NamespacesTableTestCase.assertNull((Object)ns.getUri("ns1"));
    }
}

