/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.xml;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.cocoon.xml.AbstractXMLTestCase;
import org.apache.cocoon.xml.DefaultHandlerWrapper;
import org.apache.cocoon.xml.SaxBuffer;
import org.apache.cocoon.xml.dom.DOMBuilder;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.DefaultHandler;

public final class SaxBufferTestCase
extends AbstractXMLTestCase {
    public SaxBufferTestCase(String s) {
        super(s);
    }

    public void testCompareDOM() throws Exception {
        DOMBuilder in = new DOMBuilder();
        this.generateLargeSAX((ContentHandler)in);
        SaxBuffer sb = new SaxBuffer();
        this.generateLargeSAX((ContentHandler)sb);
        DOMBuilder out = new DOMBuilder();
        sb.toSAX((ContentHandler)out);
        this.assertXMLEqual(in.getDocument(), out.getDocument());
    }

    public void testStressLoop() throws Exception {
        SaxBuffer sb = new SaxBuffer();
        long loop = 10000L;
        long start = System.currentTimeMillis();
        int i = 0;
        while ((long)i < loop) {
            this.generateSmallSAX((ContentHandler)sb);
            sb.recycle();
            ++i;
        }
        long stop = System.currentTimeMillis() + 1L;
        double r = 1000L * loop / (stop - start);
        System.out.println("consuming: " + r + " documents per second");
    }

    public void testCompareToParsing() throws Exception {
        DOMBuilder in = new DOMBuilder();
        this.generateSmallSAX((ContentHandler)in);
        SAXParserFactory pfactory = SAXParserFactory.newInstance();
        SAXParser p = pfactory.newSAXParser();
        SaxBuffer b = new SaxBuffer();
        DefaultHandlerWrapper wrapper = new DefaultHandlerWrapper((ContentHandler)b);
        ByteArrayInputStream bis = new ByteArrayInputStream(this.generateByteArray());
        long loop = 10000L;
        long start = System.currentTimeMillis();
        int i = 0;
        while ((long)i < loop) {
            b.recycle();
            bis.reset();
            p.parse((InputStream)bis, (DefaultHandler)wrapper);
            ++i;
        }
        long stop = System.currentTimeMillis() + 1L;
        double r = 1000L * loop / (stop - start);
        System.out.println("parsed:" + r + " documents per second");
        DefaultHandler ch = new DefaultHandler();
        start = System.currentTimeMillis();
        int i2 = 0;
        while ((long)i2 < loop) {
            b.toSAX((ContentHandler)ch);
            ++i2;
        }
        stop = System.currentTimeMillis() + 1L;
        r = 1000L * loop / (stop - start);
        System.out.println("recalling: " + r + " documents per second");
    }
}

