/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.xml;

import org.apache.cocoon.xml.AbstractXMLPipe;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class WhitespaceFilter
extends AbstractXMLPipe {
    private StringBuffer buffer = null;

    public WhitespaceFilter(ContentHandler handler) {
        this.setContentHandler(handler);
    }

    public void characters(char[] c, int start, int len) throws SAXException {
        if (this.contentHandler == null) {
            return;
        }
        if (this.buffer == null) {
            this.buffer = new StringBuffer();
        }
        this.buffer.append(c, start, len);
    }

    public void ignorableWhitespace(char[] c, int start, int len) throws SAXException {
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.pushText();
        this.contentHandler.startElement(namespaceURI, localName, qName, atts);
    }

    public void endElement(String uri, String loc, String raw) throws SAXException {
        this.pushText();
        this.contentHandler.endElement(uri, loc, raw);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.pushText();
        this.contentHandler.processingInstruction(target, data);
    }

    public void comment(char[] ch, int start, int len) throws SAXException {
        this.pushText();
        super.comment(ch, start, len);
    }

    public void pushText() throws SAXException {
        if (this.buffer != null) {
            String text = this.buffer.toString();
            StringBuffer normalized = new StringBuffer();
            for (int i = 0; i < text.length(); ++i) {
                if (Character.isWhitespace(text.charAt(i))) {
                    normalized.append(' ');
                    while (i + 1 < text.length() && Character.isWhitespace(text.charAt(i + 1))) {
                        ++i;
                    }
                    continue;
                }
                normalized.append(text.charAt(i));
            }
            text = normalized.toString().trim();
            if (text.length() > 0) {
                this.contentHandler.characters(text.toCharArray(), 0, text.length());
            }
            this.buffer = null;
        }
    }
}

