/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.xml.dom;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.dom.DOMBuilder;
import org.apache.cocoon.xml.dom.DOMStreamer;
import org.custommonkey.xmlunit.XMLTestCase;
import org.custommonkey.xmlunit.XMLUnit;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class DOMBuilderStreamerTestCase
extends XMLTestCase {
    public DOMBuilderStreamerTestCase(String name) {
        super(name);
    }

    public void testBuilderWithOneElement() throws Exception {
        AttributesImpl atts = new AttributesImpl();
        DOMBuilder builder = new DOMBuilder();
        builder.startDocument();
        builder.startElement("", "root", "root", (Attributes)atts);
        builder.endElement("", "root", "root");
        builder.endDocument();
        Document document = XMLUnit.buildControlDocument((String)"<root/>");
        this.assertXMLEqual(document, builder.getDocument());
    }

    public void testBuilderWithMoreElements() throws Exception {
        AttributesImpl atts = new AttributesImpl();
        DOMBuilder builder = new DOMBuilder();
        builder.startDocument();
        builder.startElement("", "root", "root", (Attributes)atts);
        builder.startElement("", "node", "node", (Attributes)atts);
        builder.endElement("", "node", "node");
        builder.startElement("", "node", "node", (Attributes)atts);
        builder.endElement("", "node", "node");
        builder.endElement("", "root", "root");
        builder.endDocument();
        Document document = XMLUnit.buildControlDocument((String)"<root><node/><node/></root>");
        this.assertXMLEqual(document, builder.getDocument());
    }

    public void testBuilderWithText() throws Exception {
        AttributesImpl atts = new AttributesImpl();
        DOMBuilder builder = new DOMBuilder();
        builder.startDocument();
        builder.startElement("", "root", "root", (Attributes)atts);
        builder.characters("abcd".toCharArray(), 0, 4);
        builder.endElement("", "root", "node");
        builder.endDocument();
        Document document = XMLUnit.buildControlDocument((String)"<root>abcd</root>");
        this.assertXMLEqual(document, builder.getDocument());
    }

    public void testBuilderWithComments() throws Exception {
        AttributesImpl atts = new AttributesImpl();
        DOMBuilder builder = new DOMBuilder();
        builder.startDocument();
        builder.startElement("", "root", "root", (Attributes)atts);
        builder.comment("abcd".toCharArray(), 0, 4);
        builder.endElement("", "root", "node");
        builder.endDocument();
        Document document = XMLUnit.buildControlDocument((String)"<root><!--abcd--></root>");
        this.assertXMLEqual(document, builder.getDocument());
    }

    public void testBuilderWithCommentWithinDocType() throws Exception {
        AttributesImpl atts = new AttributesImpl();
        DOMBuilder builder = new DOMBuilder();
        builder.startDocument();
        builder.startDTD("skinconfig", null, null);
        builder.comment("abcd".toCharArray(), 0, 4);
        builder.endDTD();
        builder.startElement("", "root", "root", (Attributes)atts);
        builder.endElement("", "root", "node");
        builder.endDocument();
        Document document = XMLUnit.buildControlDocument((String)"<!DOCTYPE skinconfig [<!--abcd-->]><root></root>");
        this.print(document);
        this.print(builder.getDocument());
        this.assertXMLEqual(document, builder.getDocument());
    }

    public final void print(Document document) {
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            Transformer serializer = factory.newTransformer();
            serializer.transform(new DOMSource(document), new StreamResult(System.out));
            System.out.println();
        }
        catch (TransformerException te) {
            te.printStackTrace();
        }
    }

    public void testTestFacility() throws Exception {
        Document document = XMLUnit.getControlParser().newDocument();
        Element elemA = document.createElement("root");
        document.appendChild(elemA);
        Document oneElementDocument = XMLUnit.buildControlDocument((String)"<root/>");
        this.assertXMLEqual(oneElementDocument, document);
        document = XMLUnit.getControlParser().newDocument();
        elemA = document.createElement("node");
        document.appendChild(elemA);
        oneElementDocument = XMLUnit.buildControlDocument((String)"<root/>");
        this.assertXMLNotEqual(oneElementDocument, document);
    }

    public void testStreamer() throws Exception {
        Document document = XMLUnit.getControlParser().newDocument();
        Element elemA = document.createElement("root");
        document.appendChild(elemA);
        Element elemB = document.createElement("node");
        elemA.appendChild(elemB);
        elemB = document.createElement("node");
        elemA.appendChild(elemB);
        DOMBuilder builder = new DOMBuilder();
        DOMStreamer streamer = new DOMStreamer((XMLConsumer)builder);
        streamer.stream((Node)document);
        document = builder.getDocument();
        Document moreElementDocument = XMLUnit.buildControlDocument((String)"<root><node/><node/></root>");
        this.assertXMLEqual(moreElementDocument, document);
    }
}

