/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.connectors;

import com.amazonaws.services.kinesis.connectors.interfaces.ITransformer;
import com.amazonaws.services.kinesis.model.Record;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BasicJsonTransformer<T, U>
implements ITransformer<T, U> {
    private static final Log LOG = LogFactory.getLog(BasicJsonTransformer.class);
    protected Class<T> inputClass;

    public BasicJsonTransformer(Class<T> inputClass) {
        this.inputClass = inputClass;
    }

    @Override
    public T toClass(Record record) throws IOException {
        try {
            return (T)new ObjectMapper().readValue(record.getData().array(), this.inputClass);
        }
        catch (IOException e) {
            String message = "Error parsing record from JSON: " + new String(record.getData().array());
            LOG.error((Object)message, (Throwable)e);
            throw new IOException(message, e);
        }
    }
}

