/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.connectors.redshift;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.services.kinesis.connectors.KinesisConnectorConfiguration;
import com.amazonaws.services.kinesis.connectors.UnmodifiableBuffer;
import com.amazonaws.services.kinesis.connectors.interfaces.IEmitter;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.PutObjectRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RedshiftManifestEmitter
implements IEmitter<String> {
    private static final Log LOG = LogFactory.getLog(RedshiftManifestEmitter.class);
    private final String s3Bucket;
    private final String dataTable;
    private final String fileTable;
    private final String fileKeyColumn;
    private final char dataDelimiter;
    private final AWSCredentialsProvider credentialsProvider;
    private final String s3Endpoint;
    private final AmazonS3Client s3Client;
    private final boolean copyMandatory;
    private final Properties loginProps;
    private final String redshiftURL;
    private static final String MANIFEST_PREFIX = "manifests/";

    public RedshiftManifestEmitter(KinesisConnectorConfiguration configuration) {
        this.dataTable = configuration.REDSHIFT_DATA_TABLE;
        this.fileTable = configuration.REDSHIFT_FILE_TABLE;
        this.fileKeyColumn = configuration.REDSHIFT_FILE_KEY_COLUMN;
        this.dataDelimiter = configuration.REDSHIFT_DATA_DELIMITER.charValue();
        this.copyMandatory = configuration.REDSHIFT_COPY_MANDATORY;
        this.s3Bucket = configuration.S3_BUCKET;
        this.s3Endpoint = configuration.S3_ENDPOINT;
        this.s3Client = new AmazonS3Client(configuration.AWS_CREDENTIALS_PROVIDER);
        if (this.s3Endpoint != null) {
            this.s3Client.setEndpoint(this.s3Endpoint);
        }
        this.credentialsProvider = configuration.AWS_CREDENTIALS_PROVIDER;
        this.loginProps = new Properties();
        this.loginProps.setProperty("user", configuration.REDSHIFT_USERNAME);
        this.loginProps.setProperty("password", configuration.REDSHIFT_PASSWORD);
        this.redshiftURL = configuration.REDSHIFT_URL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> emit(UnmodifiableBuffer<String> buffer) throws IOException {
        List<String> deduplicatedRecords;
        String manifestFileName;
        Connection conn;
        List<String> records;
        block6: {
            records = buffer.getRecords();
            conn = null;
            manifestFileName = this.getManifestFile(records);
            conn = DriverManager.getConnection(this.redshiftURL, this.loginProps);
            conn.setAutoCommit(false);
            deduplicatedRecords = this.checkForExistingFiles(conn, records);
            if (!deduplicatedRecords.isEmpty()) break block6;
            LOG.info((Object)"All the files in this set were already copied to Redshift.");
            this.rollbackConnection(conn);
            List<String> list = Collections.emptyList();
            this.closeConnection(conn);
            return list;
        }
        try {
            if (deduplicatedRecords.size() != records.size()) {
                manifestFileName = this.getManifestFile(deduplicatedRecords);
            }
            LOG.info((Object)("Writing manifest file " + manifestFileName + " to Amazon S3."));
            this.writeManifestToS3(manifestFileName, deduplicatedRecords);
            LOG.info((Object)("Inserting " + deduplicatedRecords.size() + " rows into the files table."));
            this.insertRecords(conn, deduplicatedRecords);
            LOG.info((Object)("Initiating Amazon Redshift manifest copy of " + deduplicatedRecords.size() + " files."));
            this.redshiftCopy(conn, manifestFileName);
            conn.commit();
            LOG.info((Object)("Successful Amazon Redshift manifest copy of " + this.getNumberOfCopiedRecords(conn) + " records from " + deduplicatedRecords.size() + " files using manifest s3://" + this.s3Bucket + "/" + this.getManifestFile(records)));
            List<String> list = Collections.emptyList();
            this.closeConnection(conn);
            return list;
        }
        catch (Exception e) {
            try {
                LOG.error((Object)("Error emitting data to Amazon Redshift for manifest file name " + manifestFileName + ". Failing this emit attempt."), (Throwable)e);
                this.rollbackConnection(conn);
                List<String> list = buffer.getRecords();
                this.closeConnection(conn);
                return list;
            }
            catch (Throwable throwable) {
                this.closeConnection(conn);
                throw throwable;
            }
        }
    }

    private void rollbackConnection(Connection conn) {
        try {
            if (conn != null && !conn.isClosed()) {
                conn.rollback();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Unable to rollback Amazon Redshift transaction.", (Throwable)e);
        }
    }

    private void closeConnection(Connection conn) {
        try {
            if (conn != null && !conn.isClosed()) {
                conn.close();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Unable to close Amazon Redshift connection.", (Throwable)e);
        }
    }

    @Override
    public void fail(List<String> records) {
        for (String record : records) {
            LOG.error((Object)("Record failed: " + record));
        }
    }

    private String writeManifestToS3(String fileName, List<String> records) throws IOException {
        String fileContents = this.generateManifestFile(records);
        PutObjectRequest putObjectRequest = new PutObjectRequest(this.s3Bucket, fileName, (InputStream)new ByteArrayInputStream(fileContents.getBytes()), null);
        this.s3Client.putObject(putObjectRequest);
        return fileName;
    }

    private void insertRecords(Connection conn, Collection<String> records) throws SQLException {
        String toInsert = this.getCollectionString(records, "(", "),(", ")");
        StringBuilder insertSQL = new StringBuilder();
        insertSQL.append("INSERT INTO ");
        insertSQL.append(this.fileTable);
        insertSQL.append(" VALUES ");
        insertSQL.append(toInsert);
        insertSQL.append(";");
        this.executeStatement(conn, insertSQL.toString());
    }

    /*
     * Exception decompiling
     */
    private List<String> checkForExistingFiles(Connection conn, List<String> records) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private int getNumberOfCopiedRecords(Connection conn) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void redshiftCopy(Connection conn, String manifestFile) throws SQLException {
        AWSCredentials credentials = this.credentialsProvider.getCredentials();
        StringBuilder redshiftCopy = new StringBuilder();
        redshiftCopy.append("COPY " + this.dataTable + " ");
        redshiftCopy.append("FROM 's3://" + this.s3Bucket + "/" + manifestFile + "' ");
        redshiftCopy.append("CREDENTIALS '");
        redshiftCopy.append("aws_access_key_id=" + credentials.getAWSAccessKeyId());
        redshiftCopy.append(";");
        redshiftCopy.append("aws_secret_access_key=" + credentials.getAWSSecretKey());
        if (credentials instanceof AWSSessionCredentials) {
            redshiftCopy.append(";");
            redshiftCopy.append("token=" + ((AWSSessionCredentials)credentials).getSessionToken());
        }
        redshiftCopy.append("' ");
        redshiftCopy.append("DELIMITER '" + this.dataDelimiter + "' ");
        redshiftCopy.append("MANIFEST");
        redshiftCopy.append(";");
        this.executeStatement(conn, redshiftCopy.toString());
    }

    private void executeStatement(Connection conn, String statement) throws SQLException {
        try (Statement stmt = conn.createStatement();){
            stmt.execute(statement);
        }
    }

    private String getCollectionString(Collection<String> members, String prepend, String delimiter, String append) {
        StringBuilder s = new StringBuilder();
        s.append(prepend);
        for (String m : members) {
            s.append("'");
            s.append(m);
            s.append("'");
            s.append(delimiter);
        }
        s.replace(s.length() - delimiter.length(), s.length(), "");
        s.append(append);
        return s.toString();
    }

    private String getManifestFile(List<String> records) {
        return MANIFEST_PREFIX + records.get(0) + "-" + records.get(records.size() - 1);
    }

    private String generateManifestFile(List<String> files) {
        StringBuilder s = new StringBuilder();
        s.append("{\n");
        s.append("\t\"entries\": [\n");
        for (String file : files) {
            s.append("\t\t{");
            s.append("\"url\":\"s3://");
            s.append(this.s3Bucket);
            s.append("/");
            s.append(file);
            s.append("\"");
            s.append(",");
            s.append("\"mandatory\":" + Boolean.toString(this.copyMandatory));
            s.append("},\n");
        }
        s.replace(s.length() - 2, s.length() - 1, "");
        s.append("\t]\n");
        s.append("}\n");
        return s.toString();
    }

    @Override
    public void shutdown() {
        this.s3Client.shutdown();
    }
}

