/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appfabric.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.appfabric.model.IngestionSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListIngestionsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<IngestionSummary> ingestions;
    private String nextToken;

    public List<IngestionSummary> getIngestions() {
        return this.ingestions;
    }

    public void setIngestions(Collection<IngestionSummary> ingestions) {
        if (ingestions == null) {
            this.ingestions = null;
            return;
        }
        this.ingestions = new ArrayList<IngestionSummary>(ingestions);
    }

    public ListIngestionsResult withIngestions(IngestionSummary ... ingestions) {
        if (this.ingestions == null) {
            this.setIngestions(new ArrayList<IngestionSummary>(ingestions.length));
        }
        for (IngestionSummary ele : ingestions) {
            this.ingestions.add(ele);
        }
        return this;
    }

    public ListIngestionsResult withIngestions(Collection<IngestionSummary> ingestions) {
        this.setIngestions(ingestions);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListIngestionsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIngestions() != null) {
            sb.append("Ingestions: ").append(this.getIngestions()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIngestionsResult)) {
            return false;
        }
        ListIngestionsResult other = (ListIngestionsResult)obj;
        if (other.getIngestions() == null ^ this.getIngestions() == null) {
            return false;
        }
        if (other.getIngestions() != null && !other.getIngestions().equals(this.getIngestions())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIngestions() == null ? 0 : this.getIngestions().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListIngestionsResult clone() {
        try {
            return (ListIngestionsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

