/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appflow.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appflow.model.S3InputFormatConfig;
import com.amazonaws.services.appflow.model.transform.S3SourcePropertiesMarshaller;
import java.io.Serializable;

public class S3SourceProperties
implements Serializable,
Cloneable,
StructuredPojo {
    private String bucketName;
    private String bucketPrefix;
    private S3InputFormatConfig s3InputFormatConfig;

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public S3SourceProperties withBucketName(String bucketName) {
        this.setBucketName(bucketName);
        return this;
    }

    public void setBucketPrefix(String bucketPrefix) {
        this.bucketPrefix = bucketPrefix;
    }

    public String getBucketPrefix() {
        return this.bucketPrefix;
    }

    public S3SourceProperties withBucketPrefix(String bucketPrefix) {
        this.setBucketPrefix(bucketPrefix);
        return this;
    }

    public void setS3InputFormatConfig(S3InputFormatConfig s3InputFormatConfig) {
        this.s3InputFormatConfig = s3InputFormatConfig;
    }

    public S3InputFormatConfig getS3InputFormatConfig() {
        return this.s3InputFormatConfig;
    }

    public S3SourceProperties withS3InputFormatConfig(S3InputFormatConfig s3InputFormatConfig) {
        this.setS3InputFormatConfig(s3InputFormatConfig);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBucketName() != null) {
            sb.append("BucketName: ").append(this.getBucketName()).append(",");
        }
        if (this.getBucketPrefix() != null) {
            sb.append("BucketPrefix: ").append(this.getBucketPrefix()).append(",");
        }
        if (this.getS3InputFormatConfig() != null) {
            sb.append("S3InputFormatConfig: ").append(this.getS3InputFormatConfig());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3SourceProperties)) {
            return false;
        }
        S3SourceProperties other = (S3SourceProperties)obj;
        if (other.getBucketName() == null ^ this.getBucketName() == null) {
            return false;
        }
        if (other.getBucketName() != null && !other.getBucketName().equals(this.getBucketName())) {
            return false;
        }
        if (other.getBucketPrefix() == null ^ this.getBucketPrefix() == null) {
            return false;
        }
        if (other.getBucketPrefix() != null && !other.getBucketPrefix().equals(this.getBucketPrefix())) {
            return false;
        }
        if (other.getS3InputFormatConfig() == null ^ this.getS3InputFormatConfig() == null) {
            return false;
        }
        return other.getS3InputFormatConfig() == null || other.getS3InputFormatConfig().equals(this.getS3InputFormatConfig());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBucketName() == null ? 0 : this.getBucketName().hashCode());
        hashCode = 31 * hashCode + (this.getBucketPrefix() == null ? 0 : this.getBucketPrefix().hashCode());
        hashCode = 31 * hashCode + (this.getS3InputFormatConfig() == null ? 0 : this.getS3InputFormatConfig().hashCode());
        return hashCode;
    }

    public S3SourceProperties clone() {
        try {
            return (S3SourceProperties)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3SourcePropertiesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

